import * as globalaccelerator from "../../aws-globalaccelerator";
import * as route53 from "../../aws-route53";
/**
 * (experimental) Use a Global Accelerator domain name as an alias record target.
 *
 * @experimental
 */
export declare class GlobalAcceleratorDomainTarget implements route53.IAliasRecordTarget {
    private readonly acceleratorDomainName;
    /**
     * (experimental) The hosted zone Id if using an alias record in Route53.
     *
     * This value never changes.
     * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
     *
     * @experimental
     */
    static readonly GLOBAL_ACCELERATOR_ZONE_ID = "Z2BJ6XQ5FK7U4H";
    /**
     * (experimental) Create an Alias Target for a Global Accelerator domain name.
     *
     * @experimental
     */
    constructor(acceleratorDomainName: string);
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
/**
 * (experimental) Use a Global Accelerator instance domain name as an alias record target.
 *
 * @experimental
 */
export declare class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * (experimental) Create an Alias Target for a Global Accelerator instance.
     *
     * @experimental
     */
    constructor(accelerator: globalaccelerator.IAccelerator);
}
