"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a CloudFront Distribution as an alias record target.
 *
 * @experimental
 */
class CloudFrontTarget {
    /**
     * @experimental
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * (experimental) Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @experimental
     */
    static getHostedZoneId(scope) {
        var _b;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_b = scopeStack.node.tryFindChild(mappingName)) !== null && _b !== void 0 ? _b : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.distributionDomainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontTarget[_a] = { fqn: "monocdk.aws_route53_targets.CloudFrontTarget", version: "1.106.1" };
/**
 * (experimental) The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 *
 * @experimental
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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