"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayv2DomainProperties = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Defines an API Gateway V2 domain name as the alias target.
 *
 * @experimental
 */
class ApiGatewayv2DomainProperties {
    /**
     * @param regionalDomainName the domain name associated with the regional endpoint for this custom domain name.
     * @param regionalHostedZoneId the region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     * @experimental
     */
    constructor(regionalDomainName, regionalHostedZoneId) {
        this.regionalDomainName = regionalDomainName;
        this.regionalHostedZoneId = regionalHostedZoneId;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: this.regionalDomainName,
            hostedZoneId: this.regionalHostedZoneId,
        };
    }
}
exports.ApiGatewayv2DomainProperties = ApiGatewayv2DomainProperties;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayv2DomainProperties[_a] = { fqn: "monocdk.aws_route53_targets.ApiGatewayv2DomainProperties", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXl2Mi1kb21haW4tbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaS1nYXRld2F5djItZG9tYWluLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEsNEJBQTRCOzs7Ozs7SUFLckMsWUFBNkIsa0JBQTBCLEVBQW1CLG9CQUE0QjtRQUF6RSx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFBbUIseUJBQW9CLEdBQXBCLG9CQUFvQixDQUFRO0lBQUksQ0FBQzs7Ozs7O0lBQ3BHLElBQUksQ0FBQyxPQUEyQjtRQUNuQyxPQUFPO1lBQ0gsT0FBTyxFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDaEMsWUFBWSxFQUFFLElBQUksQ0FBQyxvQkFBb0I7U0FDMUMsQ0FBQztJQUNOLENBQUM7O0FBWEwsb0VBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gXCIuLi8uLi9hd3Mtcm91dGU1M1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBBcGlHYXRld2F5djJEb21haW5Qcm9wZXJ0aWVzIGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSByZWdpb25hbERvbWFpbk5hbWU6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSByZWdpb25hbEhvc3RlZFpvbmVJZDogc3RyaW5nKSB7IH1cbiAgICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRuc05hbWU6IHRoaXMucmVnaW9uYWxEb21haW5OYW1lLFxuICAgICAgICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLnJlZ2lvbmFsSG9zdGVkWm9uZUlkLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==