import * as route53 from "../../aws-route53";
/**
 * (experimental) Defines an API Gateway V2 domain name as the alias target.
 *
 * @experimental
 */
export declare class ApiGatewayv2DomainProperties implements route53.IAliasRecordTarget {
    private readonly regionalDomainName;
    private readonly regionalHostedZoneId;
    /**
     * @param regionalDomainName the domain name associated with the regional endpoint for this custom domain name.
     * @param regionalHostedZoneId the region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     * @experimental
     */
    constructor(regionalDomainName: string, regionalHostedZoneId: string);
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
