"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 *
 * @experimental
 */
class ApiGatewayDomain {
    /**
     * @experimental
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayDomain[_a] = { fqn: "monocdk.aws_route53_targets.ApiGatewayDomain", version: "1.106.1" };
/**
 * (experimental) Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 *
 * @experimental
 */
class ApiGateway extends ApiGatewayDomain {
    /**
     * @experimental
     */
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
_b = JSII_RTTI_SYMBOL_1;
ApiGateway[_b] = { fqn: "monocdk.aws_route53_targets.ApiGateway", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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