import * as apig from "../../aws-apigateway";
import * as route53 from "../../aws-route53";
/**
 * (experimental) Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 *
 * @experimental
 */
export declare class ApiGatewayDomain implements route53.IAliasRecordTarget {
    private readonly domainName;
    /**
     * @experimental
     */
    constructor(domainName: apig.IDomainName);
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
/**
 * (experimental) Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 *
 * @experimental
 */
export declare class ApiGateway extends ApiGatewayDomain {
    /**
     * @experimental
     */
    constructor(api: apig.RestApi);
}
