"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class RedshiftMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static percentageDiskSpaceUsedAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'PercentageDiskSpaceUsed',
            dimensions,
            statistic: 'Average',
        };
    }
    static databaseConnectionsAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'DatabaseConnections',
            dimensions,
            statistic: 'Average',
        };
    }
    static healthStatusSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'HealthStatus',
            dimensions,
            statistic: 'Sum',
        };
    }
    static maintenanceModeSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'MaintenanceMode',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkReceiveThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkReceiveThroughput',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkTransmitThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'NetworkTransmitThroughput',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queriesCompletedPerSecondSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueriesCompletedPerSecond',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryDuration',
            dimensions,
            statistic: 'Average',
        };
    }
    static queryRuntimeBreakdownSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'QueryRuntimeBreakdown',
            dimensions,
            statistic: 'Sum',
        };
    }
    static readIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadIOPS',
            dimensions,
            statistic: 'Sum',
        };
    }
    static readLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadLatency',
            dimensions,
            statistic: 'Average',
        };
    }
    static readThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'ReadThroughput',
            dimensions,
            statistic: 'Sum',
        };
    }
    static wlmQueriesCompletedPerSecondAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueriesCompletedPerSecond',
            dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueryDuration',
            dimensions,
            statistic: 'Average',
        };
    }
    static wlmQueueLengthSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WLMQueueLength',
            dimensions,
            statistic: 'Sum',
        };
    }
    static writeIopsSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteIOPS',
            dimensions,
            statistic: 'Sum',
        };
    }
    static writeLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteLatency',
            dimensions,
            statistic: 'Average',
        };
    }
    static writeThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Redshift',
            metricName: 'WriteThroughput',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.RedshiftMetrics = RedshiftMetrics;
//# sourceMappingURL=data:application/json;base64,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