import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IEngine } from './engine';
/**
 * (experimental) Options for {@link IParameterGroup.bindToCluster}. Empty for now, but can be extended later.
 *
 * @experimental
 */
export interface ParameterGroupClusterBindOptions {
}
/**
 * (experimental) The type returned from {@link IParameterGroup.bindToCluster}.
 *
 * @experimental
 */
export interface ParameterGroupClusterConfig {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
}
/**
 * (experimental) Options for {@link IParameterGroup.bindToInstance}. Empty for now, but can be extended later.
 *
 * @experimental
 */
export interface ParameterGroupInstanceBindOptions {
}
/**
 * (experimental) The type returned from {@link IParameterGroup.bindToInstance}.
 *
 * @experimental
 */
export interface ParameterGroupInstanceConfig {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
}
/**
 * (experimental) A parameter group.
 *
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @experimental
 */
export interface IParameterGroup extends IResource {
    /**
     * (experimental) Method called when this Parameter Group is used when defining a database cluster.
     *
     * @experimental
     */
    bindToCluster(options: ParameterGroupClusterBindOptions): ParameterGroupClusterConfig;
    /**
     * (experimental) Method called when this Parameter Group is used when defining a database instance.
     *
     * @experimental
     */
    bindToInstance(options: ParameterGroupInstanceBindOptions): ParameterGroupInstanceConfig;
    /**
     * (experimental) Adds a parameter to this group.
     *
     * If this is an imported parameter group,
     * this method does nothing.
     *
     * @returns true if the parameter was actually added
     * (i.e., this ParameterGroup is not imported),
     * false otherwise
     * @experimental
     */
    addParameter(key: string, value: string): boolean;
}
/**
 * (experimental) Properties for a parameter group.
 *
 * @experimental
 */
export interface ParameterGroupProps {
    /**
     * (experimental) The database engine for this parameter group.
     *
     * @experimental
     */
    readonly engine: IEngine;
    /**
     * (experimental) Description for this parameter group.
     *
     * @default a CDK generated description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The parameters in this parameter group.
     *
     * @default - None
     * @experimental
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
/**
 * (experimental) A parameter group.
 *
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @experimental
 * @resource AWS::RDS::DBParameterGroup
 */
export declare class ParameterGroup extends Resource implements IParameterGroup {
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IParameterGroup;
    private readonly parameters;
    private readonly family;
    private readonly description?;
    private clusterCfnGroup?;
    private instanceCfnGroup?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ParameterGroupProps);
    /**
     * (experimental) Method called when this Parameter Group is used when defining a database cluster.
     *
     * @experimental
     */
    bindToCluster(_options: ParameterGroupClusterBindOptions): ParameterGroupClusterConfig;
    /**
     * (experimental) Method called when this Parameter Group is used when defining a database instance.
     *
     * @experimental
     */
    bindToInstance(_options: ParameterGroupInstanceBindOptions): ParameterGroupInstanceConfig;
    /**
     * (experimental) Add a parameter to this parameter group.
     *
     * @param key The key of the parameter to be added.
     * @param value The value of the parameter to be added.
     * @experimental
     */
    addParameter(key: string, value: string): boolean;
}
