import * as ec2 from "../../aws-ec2";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import * as logs from "../../aws-logs";
import * as s3 from "../../aws-s3";
import * as secretsmanager from "../../aws-secretsmanager";
import { Duration, IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { Endpoint } from './endpoint';
import { IInstanceEngine } from './instance-engine';
import { IOptionGroup } from './option-group';
import { IParameterGroup } from './parameter-group';
import { Credentials, PerformanceInsightRetention, RotationMultiUserOptions, RotationSingleUserOptions, SnapshotCredentials } from './props';
import { DatabaseProxy, DatabaseProxyOptions } from './proxy';
import { CfnDBInstanceProps } from './rds.generated';
import { ISubnetGroup } from './subnet-group';
/**
 * (experimental) A database instance.
 *
 * @experimental
 */
export interface IDatabaseInstance extends IResource, ec2.IConnectable, secretsmanager.ISecretAttachmentTarget {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance arn.
     *
     * @experimental
     */
    readonly instanceArn: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     * @attribute EndpointAddress
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     * @attribute EndpointPort
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The engine of this database Instance.
     *
     * May be not known for imported Instances if it wasn't provided explicitly,
     * or for read replicas.
     *
     * @experimental
     */
    readonly engine?: IInstanceEngine;
    /**
     * (experimental) Add a new db proxy to this instance.
     *
     * @experimental
     */
    addProxy(id: string, options: DatabaseProxyOptions): DatabaseProxy;
    /**
     * (experimental) Grant the given identity connection access to the database.
     *
     * @experimental
     */
    grantConnect(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for instance events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * (experimental) Properties that describe an existing instance.
 *
 * @experimental
 */
export interface DatabaseInstanceAttributes {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The endpoint address.
     *
     * @experimental
     */
    readonly instanceEndpointAddress: string;
    /**
     * (experimental) The database port.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) The security groups of the instance.
     *
     * @experimental
     */
    readonly securityGroups: ec2.ISecurityGroup[];
    /**
     * (experimental) The engine of the existing database Instance.
     *
     * @default - the imported Instance's engine is unknown
     * @experimental
     */
    readonly engine?: IInstanceEngine;
}
/**
 * (experimental) A new or imported database instance.
 *
 * @experimental
 */
export declare abstract class DatabaseInstanceBase extends Resource implements IDatabaseInstance {
    /**
     * (experimental) Import an existing database instance.
     *
     * @experimental
     */
    static fromDatabaseInstanceAttributes(scope: Construct, id: string, attrs: DatabaseInstanceAttributes): IDatabaseInstance;
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    abstract readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     */
    abstract readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     */
    abstract readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    abstract readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The engine of this database Instance.
     *
     * May be not known for imported Instances if it wasn't provided explicitly,
     * or for read replicas.
     *
     * @experimental
     */
    abstract readonly engine?: IInstanceEngine;
    /**
     * @experimental
     */
    protected abstract enableIamAuthentication?: boolean;
    /**
     * (experimental) Access to network connections.
     *
     * @experimental
     */
    abstract readonly connections: ec2.Connections;
    /**
     * (experimental) Add a new db proxy to this instance.
     *
     * @experimental
     */
    addProxy(id: string, options: DatabaseProxyOptions): DatabaseProxy;
    /**
     * (experimental) Grant the given identity connection access to the database.
     *
     * @experimental
     */
    grantConnect(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for instance events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) The instance arn.
     *
     * @experimental
     */
    get instanceArn(): string;
    /**
     * (experimental) Renders the secret attachment target specifications.
     *
     * @experimental
     */
    asSecretAttachmentTarget(): secretsmanager.SecretAttachmentTargetProps;
}
/**
 * (experimental) The license model.
 *
 * @experimental
 */
export declare enum LicenseModel {
    /**
     * (experimental) License included.
     *
     * @experimental
     */
    LICENSE_INCLUDED = "license-included",
    /**
     * (experimental) Bring your own licencse.
     *
     * @experimental
     */
    BRING_YOUR_OWN_LICENSE = "bring-your-own-license",
    /**
     * (experimental) General public license.
     *
     * @experimental
     */
    GENERAL_PUBLIC_LICENSE = "general-public-license"
}
/**
 * (experimental) The processor features.
 *
 * @experimental
 */
export interface ProcessorFeatures {
    /**
     * (experimental) The number of CPU core.
     *
     * @default - the default number of CPU cores for the chosen instance class.
     * @experimental
     */
    readonly coreCount?: number;
    /**
     * (experimental) The number of threads per core.
     *
     * @default - the default number of threads per core for the chosen instance class.
     * @experimental
     */
    readonly threadsPerCore?: number;
}
/**
 * (experimental) The type of storage.
 *
 * @experimental
 */
export declare enum StorageType {
    /**
     * (experimental) Standard.
     *
     * @experimental
     */
    STANDARD = "standard",
    /**
     * (experimental) General purpose (SSD).
     *
     * @experimental
     */
    GP2 = "gp2",
    /**
     * (experimental) Provisioned IOPS (SSD).
     *
     * @experimental
     */
    IO1 = "io1"
}
/**
 * (experimental) Construction properties for a DatabaseInstanceNew.
 *
 * @experimental
 */
export interface DatabaseInstanceNewProps {
    /**
     * (experimental) Specifies if the database instance is a multiple Availability Zone deployment.
     *
     * @default false
     * @experimental
     */
    readonly multiAz?: boolean;
    /**
     * (experimental) The name of the Availability Zone where the DB instance will be located.
     *
     * @default - no preference
     * @experimental
     */
    readonly availabilityZone?: string;
    /**
     * (experimental) The storage type.
     *
     * Storage types supported are gp2, io1, standard.
     *
     * @default GP2
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#Concepts.Storage.GeneralSSD
     * @experimental
     */
    readonly storageType?: StorageType;
    /**
     * (experimental) The number of I/O operations per second (IOPS) that the database provisions.
     *
     * The value must be equal to or greater than 1000.
     *
     * @default - no provisioned iops
     * @experimental
     */
    readonly iops?: number;
    /**
     * (experimental) The number of CPU cores and the number of threads per core.
     *
     * @default - the default number of CPU cores and threads per core for the
     * chosen instance class.
     *
     * See https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor
     * @experimental
     */
    readonly processorFeatures?: ProcessorFeatures;
    /**
     * (experimental) A name for the DB instance.
     *
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly instanceIdentifier?: string;
    /**
     * (experimental) The VPC network where the DB subnet group should be created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (deprecated) The type of subnets to add to the created DB subnet group.
     *
     * @default - private subnets
     * @deprecated use `vpcSubnets`
     */
    readonly vpcPlacement?: ec2.SubnetSelection;
    /**
     * (experimental) The type of subnets to add to the created DB subnet group.
     *
     * @default - private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The security groups to assign to the DB instance.
     *
     * @default - a new security group is created
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The port for the instance.
     *
     * @default - the default port for the chosen engine.
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The option group to associate with the instance.
     *
     * @default - no option group
     * @experimental
     */
    readonly optionGroup?: IOptionGroup;
    /**
     * (experimental) Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     *
     * @default false
     * @experimental
     */
    readonly iamAuthentication?: boolean;
    /**
     * (experimental) The number of days during which automatic DB snapshots are retained.
     *
     * Set to zero to disable backups.
     * When creating a read replica, you must enable automatic backups on the source
     * database instance by setting the backup retention to a value other than zero.
     *
     * @default Duration.days(1)
     * @experimental
     */
    readonly backupRetention?: Duration;
    /**
     * (experimental) The daily time range during which automated backups are performed.
     *
     * Constraints:
     * - Must be in the format `hh24:mi-hh24:mi`.
     * - Must be in Universal Coordinated Time (UTC).
     * - Must not conflict with the preferred maintenance window.
     * - Must be at least 30 minutes.
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
     * @experimental
     */
    readonly preferredBackupWindow?: string;
    /**
     * (experimental) Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance.
     *
     * @default true
     * @experimental
     */
    readonly copyTagsToSnapshot?: boolean;
    /**
     * (experimental) Indicates whether automated backups should be deleted or retained when you delete a DB instance.
     *
     * @default false
     * @experimental
     */
    readonly deleteAutomatedBackups?: boolean;
    /**
     * (experimental) The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance.
     *
     * @default - no enhanced monitoring
     * @experimental
     */
    readonly monitoringInterval?: Duration;
    /**
     * (experimental) Role that will be used to manage DB instance monitoring.
     *
     * @default - A role is automatically created for you
     * @experimental
     */
    readonly monitoringRole?: iam.IRole;
    /**
     * (experimental) Whether to enable Performance Insights for the DB instance.
     *
     * @default - false, unless ``performanceInsightRentention`` or ``performanceInsightEncryptionKey`` is set.
     * @experimental
     */
    readonly enablePerformanceInsights?: boolean;
    /**
     * (experimental) The amount of time, in days, to retain Performance Insights data.
     *
     * @default 7
     * @experimental
     */
    readonly performanceInsightRetention?: PerformanceInsightRetention;
    /**
     * (experimental) The AWS KMS key for encryption of Performance Insights data.
     *
     * @default - default master key
     * @experimental
     */
    readonly performanceInsightEncryptionKey?: kms.IKey;
    /**
     * (experimental) The list of log types that need to be enabled for exporting to CloudWatch Logs.
     *
     * @default - no log exports
     * @experimental
     */
    readonly cloudwatchLogsExports?: string[];
    /**
     * (experimental) The number of days log events are kept in CloudWatch Logs.
     *
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to `Infinity`.
     *
     * @default - logs never expire
     * @experimental
     */
    readonly cloudwatchLogsRetention?: logs.RetentionDays;
    /**
     * (experimental) The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     *
     * @default - a new role is created.
     * @experimental
     */
    readonly cloudwatchLogsRetentionRole?: iam.IRole;
    /**
     * (experimental) Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     *
     * @default true
     * @experimental
     */
    readonly autoMinorVersionUpgrade?: boolean;
    /**
     * (experimental) The weekly time range (in UTC) during which system maintenance can occur.
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     * Constraint: Minimum 30-minute window
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region, occurring on a random day of the week. To see
     * the time blocks available, see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
     * @experimental
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * (experimental) Indicates whether the DB instance should have deletion protection enabled.
     *
     * @default - true if ``removalPolicy`` is RETAIN, false otherwise
     * @experimental
     */
    readonly deletionProtection?: boolean;
    /**
     * (experimental) The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     *
     * @default - RemovalPolicy.SNAPSHOT (remove the resource, but retain a snapshot of the data)
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Upper limit to which RDS can scale the storage in GiB(Gibibyte).
     *
     * @default - No autoscaling of RDS instance
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling
     * @experimental
     */
    readonly maxAllocatedStorage?: number;
    /**
     * (experimental) The Active Directory directory ID to create the DB instance in.
     *
     * @default - Do not join domain
     * @experimental
     */
    readonly domain?: string;
    /**
     * (experimental) The IAM role to be used when making API calls to the Directory Service.
     *
     * The role needs the AWS-managed policy
     * AmazonRDSDirectoryServiceAccess or equivalent.
     *
     * @default - The role will be created for you if {@link DatabaseInstanceNewProps#domain} is specified
     * @experimental
     */
    readonly domainRole?: iam.IRole;
    /**
     * (experimental) Existing subnet group for the instance.
     *
     * @default - a new subnet group will be created.
     * @experimental
     */
    readonly subnetGroup?: ISubnetGroup;
    /**
     * (experimental) Role that will be associated with this DB instance to enable S3 import.
     *
     * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
     *
     * This property must not be used if `s3ImportBuckets` is used.
     *
     * For Microsoft SQL Server:
     *
     * @default - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html
     * @experimental
     */
    readonly s3ImportRole?: iam.IRole;
    /**
     * (experimental) S3 buckets that you want to load data from.
     *
     * This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
     *
     * This property must not be used if `s3ImportRole` is used.
     *
     * For Microsoft SQL Server:
     *
     * @default - None
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/PostgreSQL.Procedural.Importing.html
     * @experimental
     */
    readonly s3ImportBuckets?: s3.IBucket[];
    /**
     * (experimental) Role that will be associated with this DB instance to enable S3 export.
     *
     * This feature is only supported by the Microsoft SQL Server and Oracle engines.
     *
     * This property must not be used if `s3ExportBuckets` is used.
     *
     * For Microsoft SQL Server:
     *
     * @default - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html
     * @experimental
     */
    readonly s3ExportRole?: iam.IRole;
    /**
     * (experimental) S3 buckets that you want to load data into.
     *
     * This feature is only supported by the Microsoft SQL Server and Oracle engines.
     *
     * This property must not be used if `s3ExportRole` is used.
     *
     * For Microsoft SQL Server:
     *
     * @default - None
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html
     * @experimental
     */
    readonly s3ExportBuckets?: s3.IBucket[];
    /**
     * (experimental) Indicates whether the DB instance is an internet-facing instance.
     *
     * @default - `true` if `vpcSubnets` is `subnetType: SubnetType.PUBLIC`, `false` otherwise
     * @experimental
     */
    readonly publiclyAccessible?: boolean;
}
/**
 * A new database instance.
 */
declare abstract class DatabaseInstanceNew extends DatabaseInstanceBase implements IDatabaseInstance {
    /**
     * (experimental) The VPC where this database instance is deployed.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Access to network connections.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    protected abstract readonly instanceType: ec2.InstanceType;
    /**
     * @experimental
     */
    protected readonly vpcPlacement?: ec2.SubnetSelection;
    /**
     * @experimental
     */
    protected readonly newCfnProps: CfnDBInstanceProps;
    private readonly cloudwatchLogsExports?;
    private readonly cloudwatchLogsRetention?;
    private readonly cloudwatchLogsRetentionRole?;
    private readonly domainId?;
    private readonly domainRole?;
    /**
     * @experimental
     */
    protected enableIamAuthentication?: boolean;
    constructor(scope: Construct, id: string, props: DatabaseInstanceNewProps);
    /**
     * @experimental
     */
    protected setLogRetention(): void;
}
/**
 * (experimental) Construction properties for a DatabaseInstanceSource.
 *
 * @experimental
 */
export interface DatabaseInstanceSourceProps extends DatabaseInstanceNewProps {
    /**
     * (experimental) The database engine.
     *
     * @experimental
     */
    readonly engine: IInstanceEngine;
    /**
     * (experimental) The name of the compute and memory capacity for the instance.
     *
     * @default - m5.large (or, more specifically, db.m5.large)
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) The license model.
     *
     * @default - RDS default license model
     * @experimental
     */
    readonly licenseModel?: LicenseModel;
    /**
     * (experimental) Whether to allow major version upgrades.
     *
     * @default false
     * @experimental
     */
    readonly allowMajorVersionUpgrade?: boolean;
    /**
     * (experimental) The time zone of the instance.
     *
     * This is currently supported only by Microsoft Sql Server.
     *
     * @default - RDS default timezone
     * @experimental
     */
    readonly timezone?: string;
    /**
     * (experimental) The allocated storage size, specified in gigabytes (GB).
     *
     * @default 100
     * @experimental
     */
    readonly allocatedStorage?: number;
    /**
     * (experimental) The name of the database.
     *
     * @default - no name
     * @experimental
     */
    readonly databaseName?: string;
    /**
     * (experimental) The DB parameter group to associate with the instance.
     *
     * @default - no parameter group
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
}
/**
 * A new source database instance (not a read replica)
 */
declare abstract class DatabaseInstanceSource extends DatabaseInstanceNew implements IDatabaseInstance {
    /**
     * (experimental) The engine of this database Instance.
     *
     * May be not known for imported Instances if it wasn't provided explicitly,
     * or for read replicas.
     *
     * @experimental
     */
    readonly engine?: IInstanceEngine;
    /**
     * The AWS Secrets Manager secret attached to the instance.
     */
    abstract readonly secret?: secretsmanager.ISecret;
    /**
     * @experimental
     */
    protected readonly sourceCfnProps: CfnDBInstanceProps;
    /**
     * @experimental
     */
    protected readonly instanceType: ec2.InstanceType;
    private readonly singleUserRotationApplication;
    private readonly multiUserRotationApplication;
    constructor(scope: Construct, id: string, props: DatabaseInstanceSourceProps);
    /**
     * (experimental) Adds the single user rotation of the master password to this instance.
     *
     * @param options the options for the rotation, if you want to override the defaults.
     * @experimental
     */
    addRotationSingleUser(options?: RotationSingleUserOptions): secretsmanager.SecretRotation;
    /**
     * (experimental) Adds the multi user rotation to this instance.
     *
     * @experimental
     */
    addRotationMultiUser(id: string, options: RotationMultiUserOptions): secretsmanager.SecretRotation;
}
/**
 * (experimental) Construction properties for a DatabaseInstance.
 *
 * @experimental
 */
export interface DatabaseInstanceProps extends DatabaseInstanceSourceProps {
    /**
     * (experimental) Credentials for the administrative user.
     *
     * @default - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
     * @experimental
     */
    readonly credentials?: Credentials;
    /**
     * (experimental) For supported engines, specifies the character set to associate with the DB instance.
     *
     * @default - RDS default character set name
     * @experimental
     */
    readonly characterSetName?: string;
    /**
     * (experimental) Indicates whether the DB instance is encrypted.
     *
     * @default - true if storageEncryptionKey has been provided, false otherwise
     * @experimental
     */
    readonly storageEncrypted?: boolean;
    /**
     * (experimental) The KMS key that's used to encrypt the DB instance.
     *
     * @default - default master key if storageEncrypted is true, no key otherwise
     * @experimental
     */
    readonly storageEncryptionKey?: kms.IKey;
}
/**
 * (experimental) A database instance.
 *
 * @experimental
 * @resource AWS::RDS::DBInstance
 */
export declare class DatabaseInstance extends DatabaseInstanceSource implements IDatabaseInstance {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The AWS Secrets Manager secret attached to the instance.
     *
     * @experimental
     */
    readonly secret?: secretsmanager.ISecret;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseInstanceProps);
}
/**
 * (experimental) Construction properties for a DatabaseInstanceFromSnapshot.
 *
 * @experimental
 */
export interface DatabaseInstanceFromSnapshotProps extends DatabaseInstanceSourceProps {
    /**
     * (experimental) The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     *
     * If you're restoring from a shared manual DB
     * snapshot, you must specify the ARN of the snapshot.
     *
     * @experimental
     */
    readonly snapshotIdentifier: string;
    /**
     * (experimental) Master user credentials.
     *
     * Note - It is not possible to change the master username for a snapshot;
     * however, it is possible to provide (or generate) a new password.
     *
     * @default - The existing username and password from the snapshot will be used.
     * @experimental
     */
    readonly credentials?: SnapshotCredentials;
}
/**
 * (experimental) A database instance restored from a snapshot.
 *
 * @experimental
 * @resource AWS::RDS::DBInstance
 */
export declare class DatabaseInstanceFromSnapshot extends DatabaseInstanceSource implements IDatabaseInstance {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The AWS Secrets Manager secret attached to the instance.
     *
     * @experimental
     */
    readonly secret?: secretsmanager.ISecret;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseInstanceFromSnapshotProps);
}
/**
 * (experimental) Construction properties for a DatabaseInstanceReadReplica.
 *
 * @experimental
 */
export interface DatabaseInstanceReadReplicaProps extends DatabaseInstanceNewProps {
    /**
     * (experimental) The name of the compute and memory capacity classes.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) The source database instance.
     *
     * Each DB instance can have a limited number of read replicas. For more
     * information, see https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html.
     *
     * @experimental
     */
    readonly sourceDatabaseInstance: IDatabaseInstance;
    /**
     * (experimental) Indicates whether the DB instance is encrypted.
     *
     * @default - true if storageEncryptionKey has been provided, false otherwise
     * @experimental
     */
    readonly storageEncrypted?: boolean;
    /**
     * (experimental) The KMS key that's used to encrypt the DB instance.
     *
     * @default - default master key if storageEncrypted is true, no key otherwise
     * @experimental
     */
    readonly storageEncryptionKey?: kms.IKey;
}
/**
 * (experimental) A read replica database instance.
 *
 * @experimental
 * @resource AWS::RDS::DBInstance
 */
export declare class DatabaseInstanceReadReplica extends DatabaseInstanceNew implements IDatabaseInstance {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The engine of this database Instance.
     *
     * May be not known for imported Instances if it wasn't provided explicitly,
     * or for read replicas.
     *
     * @experimental
     */
    readonly engine?: IInstanceEngine;
    /**
     * @experimental
     */
    protected readonly instanceType: ec2.InstanceType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseInstanceReadReplicaProps);
}
export {};
