import * as iam from "../../aws-iam";
import * as secretsmanager from "../../aws-secretsmanager";
import { IEngine } from './engine';
import { IOptionGroup } from './option-group';
import { Construct } from "../../core";
/**
 * (experimental) The options passed to {@link IInstanceEngine.bind}.
 *
 * @experimental
 */
export interface InstanceEngineBindOptions {
    /**
     * (experimental) The Active Directory directory ID to create the DB instance in.
     *
     * @default - none (it's an optional field)
     * @experimental
     */
    readonly domain?: string;
    /**
     * (experimental) The timezone of the database, set by the customer.
     *
     * @default - none (it's an optional field)
     * @experimental
     */
    readonly timezone?: string;
    /**
     * (experimental) The role used for S3 importing.
     *
     * @default - none
     * @experimental
     */
    readonly s3ImportRole?: iam.IRole;
    /**
     * (experimental) The role used for S3 exporting.
     *
     * @default - none
     * @experimental
     */
    readonly s3ExportRole?: iam.IRole;
    /**
     * (experimental) The option group of the database.
     *
     * @default - none
     * @experimental
     */
    readonly optionGroup?: IOptionGroup;
}
/**
 * (experimental) The type returned from the {@link IInstanceEngine.bind} method.
 *
 * @experimental
 */
export interface InstanceEngineConfig {
    /**
     * (experimental) Features supported by the database engine.
     *
     * @default - no features
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html
     * @experimental
     */
    readonly features?: InstanceEngineFeatures;
    /**
     * (experimental) Option group of the database.
     *
     * @default - none
     * @experimental
     */
    readonly optionGroup?: IOptionGroup;
}
/**
 * (experimental) Represents Database Engine features.
 *
 * @experimental
 */
export interface InstanceEngineFeatures {
    /**
     * (experimental) Feature name for the DB instance that the IAM role to access the S3 bucket for import is to be associated with.
     *
     * @default - no s3Import feature name
     * @experimental
     */
    readonly s3Import?: string;
    /**
     * (experimental) Feature name for the DB instance that the IAM role to export to S3 bucket is to be associated with.
     *
     * @default - no s3Export feature name
     * @experimental
     */
    readonly s3Export?: string;
}
/**
 * (experimental) Interface representing a database instance (as opposed to cluster) engine.
 *
 * @experimental
 */
export interface IInstanceEngine extends IEngine {
    /**
     * (experimental) The application used by this engine to perform rotation for a single-user scenario.
     *
     * @experimental
     */
    readonly singleUserRotationApplication: secretsmanager.SecretRotationApplication;
    /**
     * (experimental) The application used by this engine to perform rotation for a multi-user scenario.
     *
     * @experimental
     */
    readonly multiUserRotationApplication: secretsmanager.SecretRotationApplication;
    /**
     * (experimental) Method called when the engine is used to create a new instance.
     *
     * @experimental
     */
    bindToInstance(scope: Construct, options: InstanceEngineBindOptions): InstanceEngineConfig;
}
/**
 * (experimental) The versions for the MariaDB instance engines (those returned by {@link DatabaseInstanceEngine.mariaDb}).
 *
 * @experimental
 */
export declare class MariaDbEngineVersion {
    /**
     * (deprecated) Version "10.0" (only a major version, without a specific minor version).
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.17".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_17: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.24".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_24: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.28".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_28: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.31".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_31: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.32".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_32: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.34".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_34: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.0.35".
     *
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    static readonly VER_10_0_35: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1" (only a major version, without a specific minor version).
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.14".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_14: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.19".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_19: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.23".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_23: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.26".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_26: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.31".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_31: MariaDbEngineVersion;
    /**
     * (deprecated) Version "10.1.34".
     *
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    static readonly VER_10_1_34: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_10_2: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2.11".
     *
     * @experimental
     */
    static readonly VER_10_2_11: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2.12".
     *
     * @experimental
     */
    static readonly VER_10_2_12: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2.15".
     *
     * @experimental
     */
    static readonly VER_10_2_15: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2.21".
     *
     * @experimental
     */
    static readonly VER_10_2_21: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.2.32".
     *
     * @experimental
     */
    static readonly VER_10_2_32: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.3" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_10_3: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.3.8".
     *
     * @experimental
     */
    static readonly VER_10_3_8: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.3.13".
     *
     * @experimental
     */
    static readonly VER_10_3_13: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.3.20".
     *
     * @experimental
     */
    static readonly VER_10_3_20: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.3.23".
     *
     * @experimental
     */
    static readonly VER_10_3_23: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.4" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_10_4: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.4.8".
     *
     * @experimental
     */
    static readonly VER_10_4_8: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.4.13".
     *
     * @experimental
     */
    static readonly VER_10_4_13: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.5" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_10_5: MariaDbEngineVersion;
    /**
     * (experimental) Version "10.5.8".
     *
     * @experimental
     */
    static readonly VER_10_5_8: MariaDbEngineVersion;
    /**
     * (experimental) Create a new MariaDbEngineVersion with an arbitrary version.
     *
     * @param mariaDbFullVersion the full version string, for example "10.5.28".
     * @param mariaDbMajorVersion the major version of the engine, for example "10.5".
     * @experimental
     */
    static of(mariaDbFullVersion: string, mariaDbMajorVersion: string): MariaDbEngineVersion;
    /**
     * (experimental) The full version string, for example, "10.5.28".
     *
     * @experimental
     */
    readonly mariaDbFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "10.5".
     *
     * @experimental
     */
    readonly mariaDbMajorVersion: string;
    private constructor();
}
/**
 * (experimental) Properties for MariaDB instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.mariaDb}.
 *
 * @experimental
 */
export interface MariaDbInstanceEngineProps {
    /**
     * (experimental) The exact version of the engine to use.
     *
     * @experimental
     */
    readonly version: MariaDbEngineVersion;
}
/**
 * (experimental) The versions for the MySQL instance engines (those returned by {@link DatabaseInstanceEngine.mysql}).
 *
 * @experimental
 */
export declare class MysqlEngineVersion {
    /**
     * (deprecated) Version "5.5" (only a major version, without a specific minor version).
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.5.46".
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5_46: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.5.53".
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5_53: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.5.57".
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5_57: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.5.59".
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5_59: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.5.61".
     *
     * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
     */
    static readonly VER_5_5_61: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6" (only a major version, without a specific minor version).
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.34".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_34: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.35".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_35: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.37".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_37: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.39".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_39: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.40".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_40: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.41".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_41: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.43".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_43: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.44".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_44: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.46".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_46: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.48".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_48: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.49".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_49: MysqlEngineVersion;
    /**
     * (deprecated) Version "5.6.51".
     *
     * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
     */
    static readonly VER_5_6_51: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_5_7: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.16".
     *
     * @experimental
     */
    static readonly VER_5_7_16: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.17".
     *
     * @experimental
     */
    static readonly VER_5_7_17: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.19".
     *
     * @experimental
     */
    static readonly VER_5_7_19: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.21".
     *
     * @experimental
     */
    static readonly VER_5_7_21: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.22".
     *
     * @experimental
     */
    static readonly VER_5_7_22: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.23".
     *
     * @experimental
     */
    static readonly VER_5_7_23: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.24".
     *
     * @experimental
     */
    static readonly VER_5_7_24: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.25".
     *
     * @experimental
     */
    static readonly VER_5_7_25: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.26".
     *
     * @experimental
     */
    static readonly VER_5_7_26: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.28".
     *
     * @experimental
     */
    static readonly VER_5_7_28: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.30".
     *
     * @experimental
     */
    static readonly VER_5_7_30: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.31".
     *
     * @experimental
     */
    static readonly VER_5_7_31: MysqlEngineVersion;
    /**
     * (experimental) Version "5.7.33".
     *
     * @experimental
     */
    static readonly VER_5_7_33: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_8_0: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.11".
     *
     * @experimental
     */
    static readonly VER_8_0_11: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.13".
     *
     * @experimental
     */
    static readonly VER_8_0_13: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.15".
     *
     * @experimental
     */
    static readonly VER_8_0_15: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.16".
     *
     * @experimental
     */
    static readonly VER_8_0_16: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.17".
     *
     * @experimental
     */
    static readonly VER_8_0_17: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.19".
     *
     * @experimental
     */
    static readonly VER_8_0_19: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.20 ".
     *
     * @experimental
     */
    static readonly VER_8_0_20: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.21 ".
     *
     * @experimental
     */
    static readonly VER_8_0_21: MysqlEngineVersion;
    /**
     * (experimental) Version "8.0.23".
     *
     * @experimental
     */
    static readonly VER_8_0_23: MysqlEngineVersion;
    /**
     * (experimental) Create a new MysqlEngineVersion with an arbitrary version.
     *
     * @param mysqlFullVersion the full version string, for example "8.1.43".
     * @param mysqlMajorVersion the major version of the engine, for example "8.1".
     * @experimental
     */
    static of(mysqlFullVersion: string, mysqlMajorVersion: string): MysqlEngineVersion;
    /**
     * (experimental) The full version string, for example, "10.5.28".
     *
     * @experimental
     */
    readonly mysqlFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "10.5".
     *
     * @experimental
     */
    readonly mysqlMajorVersion: string;
    private constructor();
}
/**
 * (experimental) Properties for MySQL instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.mysql}.
 *
 * @experimental
 */
export interface MySqlInstanceEngineProps {
    /**
     * (experimental) The exact version of the engine to use.
     *
     * @experimental
     */
    readonly version: MysqlEngineVersion;
}
/**
 * (experimental) Features supported by the Postgres database engine.
 *
 * @experimental
 */
export interface PostgresEngineFeatures {
    /**
     * (experimental) Whether this version of the Postgres engine supports the S3 data import feature.
     *
     * @default false
     * @experimental
     */
    readonly s3Import?: boolean;
}
/**
 * (experimental) The versions for the PostgreSQL instance engines (those returned by {@link DatabaseInstanceEngine.postgres}).
 *
 * @experimental
 */
export declare class PostgresEngineVersion {
    /**
     * (deprecated) Version "9.5" (only a major version, without a specific minor version).
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.2".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_2: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.4".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_4: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.6".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_6: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.7".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_7: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.9".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_9: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.10".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_10: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.12".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_12: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.13".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_13: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.14".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_14: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.15".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_15: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.16".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_16: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.18".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_18: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.19".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_19: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.20".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_20: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.21".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_21: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.22".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_22: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.5.23".
     *
     * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
     */
    static readonly VER_9_5_23: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6" (only a major version, without a specific minor version).
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.1".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_1: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.2".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_2: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.3".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_3: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.5".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_5: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.6".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_6: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.8".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_8: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.9".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_9: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.10".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_10: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.11".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_11: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.12".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_12: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.14".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_14: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.15".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_15: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.16".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_16: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.17".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_17: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.18".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_18: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.19".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_19: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.20".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_20: PostgresEngineVersion;
    /**
     * (deprecated) Version "9.6.21".
     *
     * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
     */
    static readonly VER_9_6_21: PostgresEngineVersion;
    /**
     * (experimental) Version "10" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_10: PostgresEngineVersion;
    /**
     * (experimental) Version "10.1".
     *
     * @experimental
     */
    static readonly VER_10_1: PostgresEngineVersion;
    /**
     * (experimental) Version "10.3".
     *
     * @experimental
     */
    static readonly VER_10_3: PostgresEngineVersion;
    /**
     * (experimental) Version "10.4".
     *
     * @experimental
     */
    static readonly VER_10_4: PostgresEngineVersion;
    /**
     * (experimental) Version "10.5".
     *
     * @experimental
     */
    static readonly VER_10_5: PostgresEngineVersion;
    /**
     * (experimental) Version "10.6".
     *
     * @experimental
     */
    static readonly VER_10_6: PostgresEngineVersion;
    /**
     * (experimental) Version "10.7".
     *
     * @experimental
     */
    static readonly VER_10_7: PostgresEngineVersion;
    /**
     * (experimental) Version "10.9".
     *
     * @experimental
     */
    static readonly VER_10_9: PostgresEngineVersion;
    /**
     * (experimental) Version "10.10".
     *
     * @experimental
     */
    static readonly VER_10_10: PostgresEngineVersion;
    /**
     * (experimental) Version "10.11".
     *
     * @experimental
     */
    static readonly VER_10_11: PostgresEngineVersion;
    /**
     * (experimental) Version "10.12".
     *
     * @experimental
     */
    static readonly VER_10_12: PostgresEngineVersion;
    /**
     * (experimental) Version "10.13".
     *
     * @experimental
     */
    static readonly VER_10_13: PostgresEngineVersion;
    /**
     * (experimental) Version "10.14".
     *
     * @experimental
     */
    static readonly VER_10_14: PostgresEngineVersion;
    /**
     * (experimental) Version "10.15".
     *
     * @experimental
     */
    static readonly VER_10_15: PostgresEngineVersion;
    /**
     * (experimental) Version "10.16".
     *
     * @experimental
     */
    static readonly VER_10_16: PostgresEngineVersion;
    /**
     * (experimental) Version "11" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_11: PostgresEngineVersion;
    /**
     * (experimental) Version "11.1".
     *
     * @experimental
     */
    static readonly VER_11_1: PostgresEngineVersion;
    /**
     * (experimental) Version "11.2".
     *
     * @experimental
     */
    static readonly VER_11_2: PostgresEngineVersion;
    /**
     * (experimental) Version "11.4".
     *
     * @experimental
     */
    static readonly VER_11_4: PostgresEngineVersion;
    /**
     * (experimental) Version "11.5".
     *
     * @experimental
     */
    static readonly VER_11_5: PostgresEngineVersion;
    /**
     * (experimental) Version "11.6".
     *
     * @experimental
     */
    static readonly VER_11_6: PostgresEngineVersion;
    /**
     * (experimental) Version "11.7".
     *
     * @experimental
     */
    static readonly VER_11_7: PostgresEngineVersion;
    /**
     * (experimental) Version "11.8".
     *
     * @experimental
     */
    static readonly VER_11_8: PostgresEngineVersion;
    /**
     * (experimental) Version "11.9".
     *
     * @experimental
     */
    static readonly VER_11_9: PostgresEngineVersion;
    /**
     * (experimental) Version "11.10".
     *
     * @experimental
     */
    static readonly VER_11_10: PostgresEngineVersion;
    /**
     * (experimental) Version "11.11".
     *
     * @experimental
     */
    static readonly VER_11_11: PostgresEngineVersion;
    /**
     * (experimental) Version "12" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_12: PostgresEngineVersion;
    /**
     * (experimental) Version "12.2".
     *
     * @experimental
     */
    static readonly VER_12_2: PostgresEngineVersion;
    /**
     * (experimental) Version "12.3".
     *
     * @experimental
     */
    static readonly VER_12_3: PostgresEngineVersion;
    /**
     * (experimental) Version "12.4".
     *
     * @experimental
     */
    static readonly VER_12_4: PostgresEngineVersion;
    /**
     * (experimental) Version "12.5".
     *
     * @experimental
     */
    static readonly VER_12_5: PostgresEngineVersion;
    /**
     * (experimental) Version "12.6".
     *
     * @experimental
     */
    static readonly VER_12_6: PostgresEngineVersion;
    /**
     * (experimental) Version "13" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_13: PostgresEngineVersion;
    /**
     * (experimental) Version "13.1".
     *
     * @experimental
     */
    static readonly VER_13_1: PostgresEngineVersion;
    /**
     * (experimental) Version "13.2".
     *
     * @experimental
     */
    static readonly VER_13_2: PostgresEngineVersion;
    /**
     * (experimental) Create a new PostgresEngineVersion with an arbitrary version.
     *
     * @param postgresFullVersion the full version string, for example "13.11".
     * @param postgresMajorVersion the major version of the engine, for example "13".
     * @experimental
     */
    static of(postgresFullVersion: string, postgresMajorVersion: string, postgresFeatures?: PostgresEngineFeatures): PostgresEngineVersion;
    /**
     * (experimental) The full version string, for example, "13.11".
     *
     * @experimental
     */
    readonly postgresFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "13".
     *
     * @experimental
     */
    readonly postgresMajorVersion: string;
    /**
     * The supported features for the DB engine
     * @internal
     */
    readonly _features: InstanceEngineFeatures;
    private constructor();
}
/**
 * (experimental) Properties for PostgreSQL instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.postgres}.
 *
 * @experimental
 */
export interface PostgresInstanceEngineProps {
    /**
     * (experimental) The exact version of the engine to use.
     *
     * @experimental
     */
    readonly version: PostgresEngineVersion;
}
/**
 * (deprecated) The versions for the legacy Oracle instance engines (those returned by {@link DatabaseInstanceEngine.oracleSe} and {@link DatabaseInstanceEngine.oracleSe1}). Note: RDS will stop allowing creating new databases with this version in August 2020.
 *
 * @deprecated instances can no longer be created with these engine versions. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
export declare class OracleLegacyEngineVersion {
    /**
     * (deprecated) Version "11.2" (only a major version, without a specific minor version).
     *
     * @deprecated
     */
    static readonly VER_11_2: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.2.v2".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_2_V2: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v1".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V1: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v3".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V3: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v4".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V4: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v5".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V5: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v6".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V6: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v7".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V7: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v8".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V8: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v9".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V9: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v10".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V10: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v11".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V11: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v12".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V12: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v13".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V13: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v14".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V14: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v15".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V15: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v16".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V16: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v17".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V17: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v18".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V18: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v19".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V19: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v20".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V20: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v21".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V21: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v22".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V22: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v23".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V23: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v24".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V24: OracleLegacyEngineVersion;
    /**
     * (deprecated) Version "11.2.0.4.v25".
     *
     * @deprecated
     */
    static readonly VER_11_2_0_4_V25: OracleLegacyEngineVersion;
    private static of;
    /**
     * (deprecated) The full version string, for example, "11.2.0.4.v24".
     *
     * @deprecated
     */
    readonly oracleLegacyFullVersion: string;
    /**
     * (deprecated) The major version of the engine, for example, "11.2".
     *
     * @deprecated
     */
    readonly oracleLegacyMajorVersion: string;
    private constructor();
}
/**
 * (experimental) The versions for the Oracle instance engines (those returned by {@link DatabaseInstanceEngine.oracleSe2} and {@link DatabaseInstanceEngine.oracleEe}).
 *
 * @experimental
 */
export declare class OracleEngineVersion {
    /**
     * (experimental) Version "12.1" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_12_1: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v1".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V1: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v2".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V2: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v3".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V3: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v4".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V4: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v5".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V5: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v6".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V6: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v7".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V7: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v8".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V8: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v9".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V9: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v10".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V10: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v11".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V11: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v12".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V12: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v13".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V13: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v14".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V14: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v15".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V15: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v16".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V16: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v17".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V17: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v18".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V18: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v19".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V19: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v20".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V20: OracleEngineVersion;
    /**
     * (experimental) Version "12.1.0.2.v21".
     *
     * @experimental
     */
    static readonly VER_12_1_0_2_V21: OracleEngineVersion;
    /**
     * (experimental) Version "12.2" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_12_2: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2018-10.rur-2018-10.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2018_10_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2019-01.rur-2019-01.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2019_01_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2019-04.rur-2019-04.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2019_04_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2019-07.rur-2019-07.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2019_07_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2019-10.rur-2019-10.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2019_10_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2020-01.rur-2020-01.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2020_01_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2020-04.rur-2020-04.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2020_04_R1: OracleEngineVersion;
    /**
     * (experimental) Version "12.2.0.1.ru-2020-07.rur-2020-07.r1".
     *
     * @experimental
     */
    static readonly VER_12_2_0_1_2020_07_R1: OracleEngineVersion;
    /**
     * (experimental) Version "18" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_18: OracleEngineVersion;
    /**
     * (experimental) Version "18.0.0.0.ru-2019-07.rur-2019-07.r1".
     *
     * @experimental
     */
    static readonly VER_18_0_0_0_2019_07_R1: OracleEngineVersion;
    /**
     * (experimental) Version "18.0.0.0.ru-2019-10.rur-2019-10.r1".
     *
     * @experimental
     */
    static readonly VER_18_0_0_0_2019_10_R1: OracleEngineVersion;
    /**
     * (experimental) Version "18.0.0.0.ru-2020-01.rur-2020-01.r1".
     *
     * @experimental
     */
    static readonly VER_18_0_0_0_2020_01_R1: OracleEngineVersion;
    /**
     * (experimental) Version "18.0.0.0.ru-2020-04.rur-2020-04.r1".
     *
     * @experimental
     */
    static readonly VER_18_0_0_0_2020_04_R1: OracleEngineVersion;
    /**
     * (experimental) Version "18.0.0.0.ru-2020-07.rur-2020-07.r1".
     *
     * @experimental
     */
    static readonly VER_18_0_0_0_2020_07_R1: OracleEngineVersion;
    /**
     * (experimental) Version "19" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_19: OracleEngineVersion;
    /**
     * (experimental) Version "19.0.0.0.ru-2019-07.rur-2019-07.r1".
     *
     * @experimental
     */
    static readonly VER_19_0_0_0_2019_07_R1: OracleEngineVersion;
    /**
     * (experimental) Version "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     *
     * @experimental
     */
    static readonly VER_19_0_0_0_2019_10_R1: OracleEngineVersion;
    /**
     * (experimental) Version "19.0.0.0.ru-2020-01.rur-2020-01.r1".
     *
     * @experimental
     */
    static readonly VER_19_0_0_0_2020_01_R1: OracleEngineVersion;
    /**
     * (experimental) Version "19.0.0.0.ru-2020-04.rur-2020-04.r1".
     *
     * @experimental
     */
    static readonly VER_19_0_0_0_2020_04_R1: OracleEngineVersion;
    /**
     * (experimental) Version "19.0.0.0.ru-2020-07.rur-2020-07.r1".
     *
     * @experimental
     */
    static readonly VER_19_0_0_0_2020_07_R1: OracleEngineVersion;
    /**
     * (experimental) Creates a new OracleEngineVersion with an arbitrary version.
     *
     * @param oracleFullVersion the full version string, for example "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     * @param oracleMajorVersion the major version of the engine, for example "19".
     * @experimental
     */
    static of(oracleFullVersion: string, oracleMajorVersion: string): OracleEngineVersion;
    /**
     * (experimental) The full version string, for example, "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     *
     * @experimental
     */
    readonly oracleFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "19".
     *
     * @experimental
     */
    readonly oracleMajorVersion: string;
    private constructor();
}
interface OracleInstanceEngineProps {
    /**
     * (experimental) The exact version of the engine to use.
     *
     * @experimental
     */
    readonly version: OracleEngineVersion;
}
/**
 * (deprecated) Properties for Oracle Standard Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.oracleSe}.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
export interface OracleSeInstanceEngineProps {
    /**
     * (deprecated) The exact version of the engine to use.
     *
     * @deprecated
     */
    readonly version: OracleLegacyEngineVersion;
}
/**
 * (deprecated) Properties for Oracle Standard Edition 1 instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.oracleSe1}.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
export interface OracleSe1InstanceEngineProps {
    /**
     * (deprecated) The exact version of the engine to use.
     *
     * @deprecated
     */
    readonly version: OracleLegacyEngineVersion;
}
/**
 * (experimental) Properties for Oracle Standard Edition 2 instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.oracleSe2}.
 *
 * @experimental
 */
export interface OracleSe2InstanceEngineProps extends OracleInstanceEngineProps {
}
/**
 * (experimental) Properties for Oracle Enterprise Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.oracleEe}.
 *
 * @experimental
 */
export interface OracleEeInstanceEngineProps extends OracleInstanceEngineProps {
}
/**
 * (experimental) The versions for the SQL Server instance engines (those returned by {@link DatabaseInstanceEngine.sqlServerSe}, {@link DatabaseInstanceEngine.sqlServerEx}, {@link DatabaseInstanceEngine.sqlServerWeb} and {@link DatabaseInstanceEngine.sqlServerEe}).
 *
 * @experimental
 */
export declare class SqlServerEngineVersion {
    /**
     * (experimental) Version "11.00" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_11: SqlServerEngineVersion;
    /**
     * (experimental) Version "11.00.5058.0.v1".
     *
     * @experimental
     */
    static readonly VER_11_00_5058_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "11.00.6020.0.v1".
     *
     * @experimental
     */
    static readonly VER_11_00_6020_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "11.00.6594.0.v1".
     *
     * @experimental
     */
    static readonly VER_11_00_6594_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "11.00.7462.6.v1".
     *
     * @experimental
     */
    static readonly VER_11_00_7462_6_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "11.00.7493.4.v1".
     *
     * @experimental
     */
    static readonly VER_11_00_7493_4_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_12: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00.5000.0.v1".
     *
     * @experimental
     */
    static readonly VER_12_00_5000_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00.5546.0.v1".
     *
     * @experimental
     */
    static readonly VER_12_00_5546_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00.5571.0.v1".
     *
     * @experimental
     */
    static readonly VER_12_00_5571_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00.6293.0.v1".
     *
     * @experimental
     */
    static readonly VER_12_00_6293_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "12.00.6329.1.v1".
     *
     * @experimental
     */
    static readonly VER_12_00_6329_1_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_13: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.2164.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_2164_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.4422.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_4422_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.4451.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_4451_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.4466.4.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_4466_4_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.4522.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_4522_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5216.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5216_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5292.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5292_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5366.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5366_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5426.0.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5426_0_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5598.27.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5598_27_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "13.00.5820.21.v1".
     *
     * @experimental
     */
    static readonly VER_13_00_5820_21_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_14: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.1000.169.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_1000_169_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3015.40.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3015_40_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3035.2.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3035_2_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3049.1.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3049_1_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3192.2.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3192_2_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3223.3.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3223_3_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3281.6.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3281_6_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "14.00.3294.2.v1".
     *
     * @experimental
     */
    static readonly VER_14_00_3294_2_V1: SqlServerEngineVersion;
    /**
     * (experimental) Version "15.00" (only a major version, without a specific minor version).
     *
     * @experimental
     */
    static readonly VER_15: SqlServerEngineVersion;
    /**
     * (experimental) Version "15.00.4043.16.v1".
     *
     * @experimental
     */
    static readonly VER_15_00_4043_16_V1: SqlServerEngineVersion;
    /**
     * (experimental) Create a new SqlServerEngineVersion with an arbitrary version.
     *
     * @param sqlServerFullVersion the full version string, for example "15.00.3049.1.v1".
     * @param sqlServerMajorVersion the major version of the engine, for example "15.00".
     * @experimental
     */
    static of(sqlServerFullVersion: string, sqlServerMajorVersion: string): SqlServerEngineVersion;
    /**
     * (experimental) The full version string, for example, "15.00.3049.1.v1".
     *
     * @experimental
     */
    readonly sqlServerFullVersion: string;
    /**
     * (experimental) The major version of the engine, for example, "15.00".
     *
     * @experimental
     */
    readonly sqlServerMajorVersion: string;
    private constructor();
}
interface SqlServerInstanceEngineProps {
    /**
     * (experimental) The exact version of the engine to use.
     *
     * @experimental
     */
    readonly version: SqlServerEngineVersion;
}
/**
 * (experimental) Properties for SQL Server Standard Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.sqlServerSe}.
 *
 * @experimental
 */
export interface SqlServerSeInstanceEngineProps extends SqlServerInstanceEngineProps {
}
/**
 * (experimental) Properties for SQL Server Express Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.sqlServerEx}.
 *
 * @experimental
 */
export interface SqlServerExInstanceEngineProps extends SqlServerInstanceEngineProps {
}
/**
 * (experimental) Properties for SQL Server Web Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.sqlServerWeb}.
 *
 * @experimental
 */
export interface SqlServerWebInstanceEngineProps extends SqlServerInstanceEngineProps {
}
/**
 * (experimental) Properties for SQL Server Enterprise Edition instance engines.
 *
 * Used in {@link DatabaseInstanceEngine.sqlServerEe}.
 *
 * @experimental
 */
export interface SqlServerEeInstanceEngineProps extends SqlServerInstanceEngineProps {
}
/**
 * (experimental) A database instance engine.
 *
 * Provides mapping to DatabaseEngine used for
 * secret rotation.
 *
 * @experimental
 */
export declare class DatabaseInstanceEngine {
    /**
     * (deprecated) The unversioned 'mariadb' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link mariaDb()} method
     */
    static readonly MARIADB: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'mysql' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link mysql()} method
     */
    static readonly MYSQL: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'oracle-ee' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link oracleEe()} method
     */
    static readonly ORACLE_EE: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'oracle-se2' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link oracleSe2()} method
     */
    static readonly ORACLE_SE2: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'oracle-se1' instance engine.
     *
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static readonly ORACLE_SE1: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'oracle-se' instance engine.
     *
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static readonly ORACLE_SE: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'postgres' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link postgres()} method
     */
    static readonly POSTGRES: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'sqlserver-ee' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link sqlServerEe()} method
     */
    static readonly SQL_SERVER_EE: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'sqlserver-se' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link sqlServerSe()} method
     */
    static readonly SQL_SERVER_SE: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'sqlserver-ex' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link sqlServerEx()} method
     */
    static readonly SQL_SERVER_EX: IInstanceEngine;
    /**
     * (deprecated) The unversioned 'sqlserver-web' instance engine.
     *
     * @deprecated using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {@link sqlServerWeb()} method
     */
    static readonly SQL_SERVER_WEB: IInstanceEngine;
    /**
     * (experimental) Creates a new MariaDB instance engine.
     *
     * @experimental
     */
    static mariaDb(props: MariaDbInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new MySQL instance engine.
     *
     * @experimental
     */
    static mysql(props: MySqlInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new PostgreSQL instance engine.
     *
     * @experimental
     */
    static postgres(props: PostgresInstanceEngineProps): IInstanceEngine;
    /**
     * (deprecated) Creates a new Oracle Standard Edition instance engine.
     *
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe(props: OracleSeInstanceEngineProps): IInstanceEngine;
    /**
     * (deprecated) Creates a new Oracle Standard Edition 1 instance engine.
     *
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe1(props: OracleSe1InstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new Oracle Standard Edition 1 instance engine.
     *
     * @experimental
     */
    static oracleSe2(props: OracleSe2InstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new Oracle Enterprise Edition instance engine.
     *
     * @experimental
     */
    static oracleEe(props: OracleEeInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new SQL Server Standard Edition instance engine.
     *
     * @experimental
     */
    static sqlServerSe(props: SqlServerSeInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new SQL Server Express Edition instance engine.
     *
     * @experimental
     */
    static sqlServerEx(props: SqlServerExInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new SQL Server Web Edition instance engine.
     *
     * @experimental
     */
    static sqlServerWeb(props: SqlServerWebInstanceEngineProps): IInstanceEngine;
    /**
     * (experimental) Creates a new SQL Server Enterprise Edition instance engine.
     *
     * @experimental
     */
    static sqlServerEe(props: SqlServerEeInstanceEngineProps): IInstanceEngine;
}
export {};
