import * as kms from "../../aws-kms";
import * as secretsmanager from "../../aws-secretsmanager";
import { Construct } from 'constructs';
/**
 * (experimental) Construction properties for a DatabaseSecret.
 *
 * @experimental
 */
export interface DatabaseSecretProps {
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) A name for the secret.
     *
     * @default - A name is generated by CloudFormation.
     * @experimental
     */
    readonly secretName?: string;
    /**
     * (experimental) The KMS key to use to encrypt the secret.
     *
     * @default default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     * @experimental
     */
    readonly masterSecret?: secretsmanager.ISecret;
    /**
     * (experimental) Characters to not include in the generated password.
     *
     * @default " %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\"
     */
    readonly excludeCharacters?: string;
    /**
     * (experimental) Whether to replace this secret when the criteria for the password change.
     *
     * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
     * with a hash of the options that influence the password generation. This
     * way a new secret will be created when the password is regenerated and the
     * cluster or instance consuming this secret will have its credentials updated.
     *
     * @default false
     * @experimental
     */
    readonly replaceOnPasswordCriteriaChanges?: boolean;
}
/**
 * (experimental) A database secret.
 *
 * @experimental
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
