"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QLDBMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class QLDBMetrics {
    static commandLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'CommandLatency',
            dimensions,
            statistic: 'Average',
        };
    }
    static journalStorageSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'JournalStorage',
            dimensions,
            statistic: 'Sum',
        };
    }
    static indexedStorageSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'IndexedStorage',
            dimensions,
            statistic: 'Sum',
        };
    }
    static isImpairedSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'IsImpaired',
            dimensions,
            statistic: 'Sum',
        };
    }
    static occConflictExceptionsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'OccConflictExceptions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static readIOsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'ReadIOs',
            dimensions,
            statistic: 'Sum',
        };
    }
    static session4XxExceptionsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'Session4xxExceptions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static session5XxExceptionsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'Session5xxExceptions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static sessionRateExceededExceptionsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'SessionRateExceededExceptions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static writeIOsSum(dimensions) {
        return {
            namespace: 'AWS/QLDB',
            metricName: 'WriteIOs',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.QLDBMetrics = QLDBMetrics;
//# sourceMappingURL=data:application/json;base64,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