"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsWorksMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class OpsWorksMetrics {
    static procsAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'procs',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryUsedAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_used',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuIdleAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_idle',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuNiceAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_nice',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuStealAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_steal',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuSystemAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_system',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuUserAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_user',
            dimensions,
            statistic: 'Average',
        };
    }
    static cpuWaitioAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'cpu_waitio',
            dimensions,
            statistic: 'Average',
        };
    }
    static load1Average(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'load_1',
            dimensions,
            statistic: 'Average',
        };
    }
    static load15Average(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'load_15',
            dimensions,
            statistic: 'Average',
        };
    }
    static load5Average(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'load_5',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryBuffersAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_buffers',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryCachedAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_cached',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryFreeAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_free',
            dimensions,
            statistic: 'Average',
        };
    }
    static memorySwapAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_swap',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryTotalAverage(dimensions) {
        return {
            namespace: 'AWS/OpsWorks',
            metricName: 'memory_total',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.OpsWorksMetrics = OpsWorksMetrics;
//# sourceMappingURL=data:application/json;base64,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