import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::NimbleStudio::LaunchProfile`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html
 */
export interface CfnLaunchProfileProps {
    /**
     * `AWS::NimbleStudio::LaunchProfile.Ec2SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids
     */
    readonly ec2SubnetIds: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.LaunchProfileProtocolVersions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions
     */
    readonly launchProfileProtocolVersions: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name
     */
    readonly name: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.StreamConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration
     */
    readonly streamConfiguration: CfnLaunchProfile.StreamConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::LaunchProfile.StudioComponentIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids
     */
    readonly studioComponentIds: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid
     */
    readonly studioId: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description
     */
    readonly description?: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::LaunchProfile`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::LaunchProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html
 */
export declare class CfnLaunchProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NimbleStudio::LaunchProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchProfile;
    /**
     * @external
     * @cloudformationAttribute LaunchProfileId
     */
    readonly attrLaunchProfileId: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.Ec2SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids
     */
    ec2SubnetIds: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.LaunchProfileProtocolVersions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions
     */
    launchProfileProtocolVersions: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name
     */
    name: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.StreamConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration
     */
    streamConfiguration: CfnLaunchProfile.StreamConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::LaunchProfile.StudioComponentIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids
     */
    studioComponentIds: string[];
    /**
     * `AWS::NimbleStudio::LaunchProfile.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid
     */
    studioId: string;
    /**
     * `AWS::NimbleStudio::LaunchProfile.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description
     */
    description: string | undefined;
    /**
     * `AWS::NimbleStudio::LaunchProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NimbleStudio::LaunchProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::LaunchProfile`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::LaunchProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html
 */
export declare namespace CfnLaunchProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html
     */
    interface StreamConfigurationProperty {
        /**
         * `CfnLaunchProfile.StreamConfigurationProperty.ClipboardMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-clipboardmode
         */
        readonly clipboardMode: string;
        /**
         * `CfnLaunchProfile.StreamConfigurationProperty.Ec2InstanceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-ec2instancetypes
         */
        readonly ec2InstanceTypes: string[];
        /**
         * `CfnLaunchProfile.StreamConfigurationProperty.MaxSessionLengthInMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-maxsessionlengthinminutes
         */
        readonly maxSessionLengthInMinutes?: number;
        /**
         * `CfnLaunchProfile.StreamConfigurationProperty.StreamingImageIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-streamingimageids
         */
        readonly streamingImageIds: string[];
    }
}
/**
 * Properties for defining a `AWS::NimbleStudio::StreamingImage`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html
 */
export interface CfnStreamingImageProps {
    /**
     * `AWS::NimbleStudio::StreamingImage.Ec2ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-ec2imageid
     */
    readonly ec2ImageId: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-name
     */
    readonly name: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-studioid
     */
    readonly studioId: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-description
     */
    readonly description?: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::StreamingImage`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StreamingImage
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html
 */
export declare class CfnStreamingImage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NimbleStudio::StreamingImage";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStreamingImage;
    /**
     * @external
     * @cloudformationAttribute EulaIds
     */
    readonly attrEulaIds: string[];
    /**
     * @external
     * @cloudformationAttribute Owner
     */
    readonly attrOwner: string;
    /**
     * @external
     * @cloudformationAttribute Platform
     */
    readonly attrPlatform: string;
    /**
     * @external
     * @cloudformationAttribute StreamingImageId
     */
    readonly attrStreamingImageId: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Ec2ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-ec2imageid
     */
    ec2ImageId: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-name
     */
    name: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-studioid
     */
    studioId: string;
    /**
     * `AWS::NimbleStudio::StreamingImage.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-description
     */
    description: string | undefined;
    /**
     * `AWS::NimbleStudio::StreamingImage.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-streamingimage.html#cfn-nimblestudio-streamingimage-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NimbleStudio::StreamingImage`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStreamingImageProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::NimbleStudio::Studio`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html
 */
export interface CfnStudioProps {
    /**
     * `AWS::NimbleStudio::Studio.AdminRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-adminrolearn
     */
    readonly adminRoleArn: string;
    /**
     * `AWS::NimbleStudio::Studio.DisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-displayname
     */
    readonly displayName: string;
    /**
     * `AWS::NimbleStudio::Studio.StudioName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioname
     */
    readonly studioName: string;
    /**
     * `AWS::NimbleStudio::Studio.UserRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-userrolearn
     */
    readonly userRoleArn: string;
    /**
     * `AWS::NimbleStudio::Studio.StudioEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioencryptionconfiguration
     */
    readonly studioEncryptionConfiguration?: CfnStudio.StudioEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::Studio.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::Studio`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::Studio
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html
 */
export declare class CfnStudio extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NimbleStudio::Studio";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStudio;
    /**
     * @external
     * @cloudformationAttribute HomeRegion
     */
    readonly attrHomeRegion: string;
    /**
     * @external
     * @cloudformationAttribute SsoClientId
     */
    readonly attrSsoClientId: string;
    /**
     * @external
     * @cloudformationAttribute StudioId
     */
    readonly attrStudioId: string;
    /**
     * @external
     * @cloudformationAttribute StudioUrl
     */
    readonly attrStudioUrl: string;
    /**
     * `AWS::NimbleStudio::Studio.AdminRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-adminrolearn
     */
    adminRoleArn: string;
    /**
     * `AWS::NimbleStudio::Studio.DisplayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-displayname
     */
    displayName: string;
    /**
     * `AWS::NimbleStudio::Studio.StudioName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioname
     */
    studioName: string;
    /**
     * `AWS::NimbleStudio::Studio.UserRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-userrolearn
     */
    userRoleArn: string;
    /**
     * `AWS::NimbleStudio::Studio.StudioEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioencryptionconfiguration
     */
    studioEncryptionConfiguration: CfnStudio.StudioEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::NimbleStudio::Studio.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NimbleStudio::Studio`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStudioProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::Studio`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::Studio
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html
 */
export declare namespace CfnStudio {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studio-studioencryptionconfiguration.html
     */
    interface StudioEncryptionConfigurationProperty {
        /**
         * `CfnStudio.StudioEncryptionConfigurationProperty.KeyArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studio-studioencryptionconfiguration.html#cfn-nimblestudio-studio-studioencryptionconfiguration-keyarn
         */
        readonly keyArn?: string;
        /**
         * `CfnStudio.StudioEncryptionConfigurationProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studio-studioencryptionconfiguration.html#cfn-nimblestudio-studio-studioencryptionconfiguration-keytype
         */
        readonly keyType: string;
    }
}
/**
 * Properties for defining a `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export interface CfnStudioComponentProps {
    /**
     * `AWS::NimbleStudio::StudioComponent.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-name
     */
    readonly name: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-studioid
     */
    readonly studioId: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-type
     */
    readonly type: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-configuration
     */
    readonly configuration?: CfnStudioComponent.StudioComponentConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::StudioComponent.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-description
     */
    readonly description?: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Ec2SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-ec2securitygroupids
     */
    readonly ec2SecurityGroupIds?: string[];
    /**
     * `AWS::NimbleStudio::StudioComponent.InitializationScripts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-initializationscripts
     */
    readonly initializationScripts?: Array<CfnStudioComponent.StudioComponentInitializationScriptProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::StudioComponent.ScriptParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-scriptparameters
     */
    readonly scriptParameters?: Array<CfnStudioComponent.ScriptParameterKeyValueProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NimbleStudio::StudioComponent.Subtype`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-subtype
     */
    readonly subtype?: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare class CfnStudioComponent extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NimbleStudio::StudioComponent";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStudioComponent;
    /**
     * @external
     * @cloudformationAttribute StudioComponentId
     */
    readonly attrStudioComponentId: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-name
     */
    name: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.StudioId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-studioid
     */
    studioId: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-type
     */
    type: string;
    /**
     * `AWS::NimbleStudio::StudioComponent.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-configuration
     */
    configuration: CfnStudioComponent.StudioComponentConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-description
     */
    description: string | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.Ec2SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-ec2securitygroupids
     */
    ec2SecurityGroupIds: string[] | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.InitializationScripts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-initializationscripts
     */
    initializationScripts: Array<CfnStudioComponent.StudioComponentInitializationScriptProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.ScriptParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-scriptparameters
     */
    scriptParameters: Array<CfnStudioComponent.ScriptParameterKeyValueProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.Subtype`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-subtype
     */
    subtype: string | undefined;
    /**
     * `AWS::NimbleStudio::StudioComponent.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NimbleStudio::StudioComponent`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStudioComponentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectorycomputerattribute.html
     */
    interface ActiveDirectoryComputerAttributeProperty {
        /**
         * `CfnStudioComponent.ActiveDirectoryComputerAttributeProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectorycomputerattribute.html#cfn-nimblestudio-studiocomponent-activedirectorycomputerattribute-name
         */
        readonly name?: string;
        /**
         * `CfnStudioComponent.ActiveDirectoryComputerAttributeProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectorycomputerattribute.html#cfn-nimblestudio-studiocomponent-activedirectorycomputerattribute-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectoryconfiguration.html
     */
    interface ActiveDirectoryConfigurationProperty {
        /**
         * `CfnStudioComponent.ActiveDirectoryConfigurationProperty.ComputerAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectoryconfiguration.html#cfn-nimblestudio-studiocomponent-activedirectoryconfiguration-computerattributes
         */
        readonly computerAttributes?: Array<CfnStudioComponent.ActiveDirectoryComputerAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnStudioComponent.ActiveDirectoryConfigurationProperty.DirectoryId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectoryconfiguration.html#cfn-nimblestudio-studiocomponent-activedirectoryconfiguration-directoryid
         */
        readonly directoryId?: string;
        /**
         * `CfnStudioComponent.ActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-activedirectoryconfiguration.html#cfn-nimblestudio-studiocomponent-activedirectoryconfiguration-organizationalunitdistinguishedname
         */
        readonly organizationalUnitDistinguishedName?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-computefarmconfiguration.html
     */
    interface ComputeFarmConfigurationProperty {
        /**
         * `CfnStudioComponent.ComputeFarmConfigurationProperty.ActiveDirectoryUser`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-computefarmconfiguration.html#cfn-nimblestudio-studiocomponent-computefarmconfiguration-activedirectoryuser
         */
        readonly activeDirectoryUser?: string;
        /**
         * `CfnStudioComponent.ComputeFarmConfigurationProperty.Endpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-computefarmconfiguration.html#cfn-nimblestudio-studiocomponent-computefarmconfiguration-endpoint
         */
        readonly endpoint?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-licenseserviceconfiguration.html
     */
    interface LicenseServiceConfigurationProperty {
        /**
         * `CfnStudioComponent.LicenseServiceConfigurationProperty.Endpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-licenseserviceconfiguration.html#cfn-nimblestudio-studiocomponent-licenseserviceconfiguration-endpoint
         */
        readonly endpoint?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-scriptparameterkeyvalue.html
     */
    interface ScriptParameterKeyValueProperty {
        /**
         * `CfnStudioComponent.ScriptParameterKeyValueProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-scriptparameterkeyvalue.html#cfn-nimblestudio-studiocomponent-scriptparameterkeyvalue-key
         */
        readonly key?: string;
        /**
         * `CfnStudioComponent.ScriptParameterKeyValueProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-scriptparameterkeyvalue.html#cfn-nimblestudio-studiocomponent-scriptparameterkeyvalue-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html
     */
    interface SharedFileSystemConfigurationProperty {
        /**
         * `CfnStudioComponent.SharedFileSystemConfigurationProperty.Endpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html#cfn-nimblestudio-studiocomponent-sharedfilesystemconfiguration-endpoint
         */
        readonly endpoint?: string;
        /**
         * `CfnStudioComponent.SharedFileSystemConfigurationProperty.FileSystemId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html#cfn-nimblestudio-studiocomponent-sharedfilesystemconfiguration-filesystemid
         */
        readonly fileSystemId?: string;
        /**
         * `CfnStudioComponent.SharedFileSystemConfigurationProperty.LinuxMountPoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html#cfn-nimblestudio-studiocomponent-sharedfilesystemconfiguration-linuxmountpoint
         */
        readonly linuxMountPoint?: string;
        /**
         * `CfnStudioComponent.SharedFileSystemConfigurationProperty.ShareName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html#cfn-nimblestudio-studiocomponent-sharedfilesystemconfiguration-sharename
         */
        readonly shareName?: string;
        /**
         * `CfnStudioComponent.SharedFileSystemConfigurationProperty.WindowsMountDrive`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-sharedfilesystemconfiguration.html#cfn-nimblestudio-studiocomponent-sharedfilesystemconfiguration-windowsmountdrive
         */
        readonly windowsMountDrive?: string;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentconfiguration.html
     */
    interface StudioComponentConfigurationProperty {
        /**
         * `CfnStudioComponent.StudioComponentConfigurationProperty.ActiveDirectoryConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentconfiguration.html#cfn-nimblestudio-studiocomponent-studiocomponentconfiguration-activedirectoryconfiguration
         */
        readonly activeDirectoryConfiguration?: CfnStudioComponent.ActiveDirectoryConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnStudioComponent.StudioComponentConfigurationProperty.ComputeFarmConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentconfiguration.html#cfn-nimblestudio-studiocomponent-studiocomponentconfiguration-computefarmconfiguration
         */
        readonly computeFarmConfiguration?: CfnStudioComponent.ComputeFarmConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnStudioComponent.StudioComponentConfigurationProperty.LicenseServiceConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentconfiguration.html#cfn-nimblestudio-studiocomponent-studiocomponentconfiguration-licenseserviceconfiguration
         */
        readonly licenseServiceConfiguration?: CfnStudioComponent.LicenseServiceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnStudioComponent.StudioComponentConfigurationProperty.SharedFileSystemConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentconfiguration.html#cfn-nimblestudio-studiocomponent-studiocomponentconfiguration-sharedfilesystemconfiguration
         */
        readonly sharedFileSystemConfiguration?: CfnStudioComponent.SharedFileSystemConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NimbleStudio::StudioComponent`.
 *
 * @external
 * @cloudformationResource AWS::NimbleStudio::StudioComponent
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html
 */
export declare namespace CfnStudioComponent {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentinitializationscript.html
     */
    interface StudioComponentInitializationScriptProperty {
        /**
         * `CfnStudioComponent.StudioComponentInitializationScriptProperty.LaunchProfileProtocolVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentinitializationscript.html#cfn-nimblestudio-studiocomponent-studiocomponentinitializationscript-launchprofileprotocolversion
         */
        readonly launchProfileProtocolVersion?: string;
        /**
         * `CfnStudioComponent.StudioComponentInitializationScriptProperty.Platform`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentinitializationscript.html#cfn-nimblestudio-studiocomponent-studiocomponentinitializationscript-platform
         */
        readonly platform?: string;
        /**
         * `CfnStudioComponent.StudioComponentInitializationScriptProperty.RunContext`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentinitializationscript.html#cfn-nimblestudio-studiocomponent-studiocomponentinitializationscript-runcontext
         */
        readonly runContext?: string;
        /**
         * `CfnStudioComponent.StudioComponentInitializationScriptProperty.Script`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-studiocomponent-studiocomponentinitializationscript.html#cfn-nimblestudio-studiocomponent-studiocomponentinitializationscript-script
         */
        readonly script?: string;
    }
}
