"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeptuneMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class NeptuneMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static freeLocalStorageMinimum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'FreeLocalStorage',
            dimensions,
            statistic: 'Minimum',
        };
    }
    static freeableMemoryMinimum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'FreeableMemory',
            dimensions,
            statistic: 'Minimum',
        };
    }
    static gremlinErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinErrors',
            dimensions,
            statistic: 'Sum',
        };
    }
    static gremlinRequestsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinRequests',
            dimensions,
            statistic: 'Sum',
        };
    }
    static gremlinRequestsPerSecAverage(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinRequestsPerSec',
            dimensions,
            statistic: 'Average',
        };
    }
    static http413Sum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'Http413',
            dimensions,
            statistic: 'Sum',
        };
    }
    static http500Sum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'Http500',
            dimensions,
            statistic: 'Sum',
        };
    }
    static loaderRequestsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'LoaderRequests',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkReceiveThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'NetworkReceiveThroughput',
            dimensions,
            statistic: 'Sum',
        };
    }
    static sparqlErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'SparqlErrors',
            dimensions,
            statistic: 'Sum',
        };
    }
    static sparqlRequestsPerSecSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'SparqlRequestsPerSec',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeBytesUsedSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeBytesUsed',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeReadIoPsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeReadIOPs',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeWriteIoPsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeWriteIOPs',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NeptuneMetrics = NeptuneMetrics;
//# sourceMappingURL=data:application/json;base64,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