import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IDatabaseCluster } from './cluster';
import { Endpoint } from './endpoint';
import { IParameterGroup } from './parameter-group';
/**
 * (experimental) Possible Instances Types to use in Neptune cluster used for defining {@link DatabaseInstanceProps.instanceType}.
 *
 * @experimental
 */
export declare class InstanceType {
    /**
     * (experimental) db.r5.large.
     *
     * @experimental
     */
    static readonly R5_LARGE: InstanceType;
    /**
     * (experimental) db.r5.xlarge.
     *
     * @experimental
     */
    static readonly R5_XLARGE: InstanceType;
    /**
     * (experimental) db.r5.2xlarge.
     *
     * @experimental
     */
    static readonly R5_2XLARGE: InstanceType;
    /**
     * (experimental) db.r5.4xlarge.
     *
     * @experimental
     */
    static readonly R5_4XLARGE: InstanceType;
    /**
     * (experimental) db.r5.8xlarge.
     *
     * @experimental
     */
    static readonly R5_8XLARGE: InstanceType;
    /**
     * (experimental) db.r5.12xlarge.
     *
     * @experimental
     */
    static readonly R5_12XLARGE: InstanceType;
    /**
     * (experimental) db.r5.24xlarge.
     *
     * @experimental
     */
    static readonly R5_24XLARGE: InstanceType;
    /**
     * (experimental) db.r4.large.
     *
     * @experimental
     */
    static readonly R4_LARGE: InstanceType;
    /**
     * (experimental) db.r4.xlarge.
     *
     * @experimental
     */
    static readonly R4_XLARGE: InstanceType;
    /**
     * (experimental) db.r4.2xlarge.
     *
     * @experimental
     */
    static readonly R4_2XLARGE: InstanceType;
    /**
     * (experimental) db.r4.4xlarge.
     *
     * @experimental
     */
    static readonly R4_4XLARGE: InstanceType;
    /**
     * (experimental) db.r4.8xlarge.
     *
     * @experimental
     */
    static readonly R4_8XLARGE: InstanceType;
    /**
     * (experimental) db.t3.medium.
     *
     * @experimental
     */
    static readonly T3_MEDIUM: InstanceType;
    /**
     * (experimental) Build an InstanceType from given string or token, such as CfnParameter.
     *
     * @experimental
     */
    static of(instanceType: string): InstanceType;
    /**
     * @internal
     */
    readonly _instanceType: string;
    private constructor();
}
/**
 * (experimental) A database instance.
 *
 * @experimental
 */
export interface IDatabaseInstance extends cdk.IResource {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     * @attribute Endpoint
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     * @attribute Port
     */
    readonly dbInstanceEndpointPort: string;
}
/**
 * (experimental) Properties that describe an existing instance.
 *
 * @experimental
 */
export interface DatabaseInstanceAttributes {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The endpoint address.
     *
     * @experimental
     */
    readonly instanceEndpointAddress: string;
    /**
     * (experimental) The database port.
     *
     * @experimental
     */
    readonly port: number;
}
/**
 * (experimental) Construction properties for a DatabaseInstanceNew.
 *
 * @experimental
 */
export interface DatabaseInstanceProps {
    /**
     * (experimental) The Neptune database cluster the instance should launch into.
     *
     * @experimental
     */
    readonly cluster: IDatabaseCluster;
    /**
     * (experimental) What type of instance to start for the replicas.
     *
     * @experimental
     */
    readonly instanceType: InstanceType;
    /**
     * (experimental) The name of the Availability Zone where the DB instance will be located.
     *
     * @default - no preference
     * @experimental
     */
    readonly availabilityZone?: string;
    /**
     * (experimental) A name for the DB instance.
     *
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly dbInstanceName?: string;
    /**
     * (experimental) The DB parameter group to associate with the instance.
     *
     * @default no parameter group
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * (experimental) The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * (experimental) A database instance.
 *
 * @experimental
 * @resource AWS::Neptune::DBInstance
 */
export declare class DatabaseInstance extends cdk.Resource implements IDatabaseInstance {
    /**
     * (experimental) Import an existing database instance.
     *
     * @experimental
     */
    static fromDatabaseInstanceAttributes(scope: Construct, id: string, attrs: DatabaseInstanceAttributes): IDatabaseInstance;
    /**
     * (experimental) The instance's database cluster.
     *
     * @experimental
     */
    readonly cluster: IDatabaseCluster;
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseInstanceProps);
}
