import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::MSK::Cluster`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export interface CfnClusterProps {
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     */
    readonly brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     */
    readonly clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     */
    readonly kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     */
    readonly numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     */
    readonly clientAuthentication?: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     */
    readonly configurationInfo?: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     */
    readonly encryptionInfo?: CfnCluster.EncryptionInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     */
    readonly enhancedMonitoring?: string;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     */
    readonly loggingInfo?: CfnCluster.LoggingInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     */
    readonly openMonitoring?: CfnCluster.OpenMonitoringProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MSK::Cluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCluster;
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     */
    brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     */
    clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     */
    kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     */
    numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     */
    clientAuthentication: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     */
    configurationInfo: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     */
    encryptionInfo: CfnCluster.EncryptionInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     */
    enhancedMonitoring: string | undefined;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     */
    loggingInfo: CfnCluster.LoggingInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     */
    openMonitoring: CfnCluster.OpenMonitoringProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MSK::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html
     */
    interface BrokerLogsProperty {
        /**
         * `CfnCluster.BrokerLogsProperty.CloudWatchLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-cloudwatchlogs
         */
        readonly cloudWatchLogs?: CfnCluster.CloudWatchLogsProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.Firehose`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-firehose
         */
        readonly firehose?: CfnCluster.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.S3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-s3
         */
        readonly s3?: CfnCluster.S3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html
     */
    interface BrokerNodeGroupInfoProperty {
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.BrokerAZDistribution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-brokerazdistribution
         */
        readonly brokerAzDistribution?: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.ClientSubnets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-clientsubnets
         */
        readonly clientSubnets: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.StorageInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-storageinfo
         */
        readonly storageInfo?: CfnCluster.StorageInfoProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html
     */
    interface ClientAuthenticationProperty {
        /**
         * `CfnCluster.ClientAuthenticationProperty.Sasl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html#cfn-msk-cluster-clientauthentication-sasl
         */
        readonly sasl?: CfnCluster.SaslProperty | cdk.IResolvable;
        /**
         * `CfnCluster.ClientAuthenticationProperty.Tls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html#cfn-msk-cluster-clientauthentication-tls
         */
        readonly tls?: CfnCluster.TlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html
     */
    interface CloudWatchLogsProperty {
        /**
         * `CfnCluster.CloudWatchLogsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.CloudWatchLogsProperty.LogGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-loggroup
         */
        readonly logGroup?: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html
     */
    interface ConfigurationInfoProperty {
        /**
         * `CfnCluster.ConfigurationInfoProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-arn
         */
        readonly arn: string;
        /**
         * `CfnCluster.ConfigurationInfoProperty.Revision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-revision
         */
        readonly revision: number;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html
     */
    interface EBSStorageInfoProperty {
        /**
         * `CfnCluster.EBSStorageInfoProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html#cfn-msk-cluster-ebsstorageinfo-volumesize
         */
        readonly volumeSize?: number;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html
     */
    interface EncryptionAtRestProperty {
        /**
         * `CfnCluster.EncryptionAtRestProperty.DataVolumeKMSKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html#cfn-msk-cluster-encryptionatrest-datavolumekmskeyid
         */
        readonly dataVolumeKmsKeyId: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html
     */
    interface EncryptionInTransitProperty {
        /**
         * `CfnCluster.EncryptionInTransitProperty.ClientBroker`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-clientbroker
         */
        readonly clientBroker?: string;
        /**
         * `CfnCluster.EncryptionInTransitProperty.InCluster`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-incluster
         */
        readonly inCluster?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html
     */
    interface EncryptionInfoProperty {
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionAtRest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionatrest
         */
        readonly encryptionAtRest?: CfnCluster.EncryptionAtRestProperty | cdk.IResolvable;
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionInTransit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionintransit
         */
        readonly encryptionInTransit?: CfnCluster.EncryptionInTransitProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html
     */
    interface FirehoseProperty {
        /**
         * `CfnCluster.FirehoseProperty.DeliveryStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-deliverystream
         */
        readonly deliveryStream?: string;
        /**
         * `CfnCluster.FirehoseProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-iam.html
     */
    interface IamProperty {
        /**
         * `CfnCluster.IamProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-iam.html#cfn-msk-cluster-iam-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html
     */
    interface JmxExporterProperty {
        /**
         * `CfnCluster.JmxExporterProperty.EnabledInBroker`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html#cfn-msk-cluster-jmxexporter-enabledinbroker
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html
     */
    interface LoggingInfoProperty {
        /**
         * `CfnCluster.LoggingInfoProperty.BrokerLogs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html#cfn-msk-cluster-logginginfo-brokerlogs
         */
        readonly brokerLogs: CfnCluster.BrokerLogsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html
     */
    interface NodeExporterProperty {
        /**
         * `CfnCluster.NodeExporterProperty.EnabledInBroker`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html#cfn-msk-cluster-nodeexporter-enabledinbroker
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html
     */
    interface OpenMonitoringProperty {
        /**
         * `CfnCluster.OpenMonitoringProperty.Prometheus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html#cfn-msk-cluster-openmonitoring-prometheus
         */
        readonly prometheus: CfnCluster.PrometheusProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html
     */
    interface PrometheusProperty {
        /**
         * `CfnCluster.PrometheusProperty.JmxExporter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-jmxexporter
         */
        readonly jmxExporter?: CfnCluster.JmxExporterProperty | cdk.IResolvable;
        /**
         * `CfnCluster.PrometheusProperty.NodeExporter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-nodeexporter
         */
        readonly nodeExporter?: CfnCluster.NodeExporterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html
     */
    interface S3Property {
        /**
         * `CfnCluster.S3Property.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-bucket
         */
        readonly bucket?: string;
        /**
         * `CfnCluster.S3Property.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.S3Property.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-prefix
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-sasl.html
     */
    interface SaslProperty {
        /**
         * `CfnCluster.SaslProperty.Iam`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-sasl.html#cfn-msk-cluster-sasl-iam
         */
        readonly iam?: CfnCluster.IamProperty | cdk.IResolvable;
        /**
         * `CfnCluster.SaslProperty.Scram`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-sasl.html#cfn-msk-cluster-sasl-scram
         */
        readonly scram?: CfnCluster.ScramProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-scram.html
     */
    interface ScramProperty {
        /**
         * `CfnCluster.ScramProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-scram.html#cfn-msk-cluster-scram-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html
     */
    interface StorageInfoProperty {
        /**
         * `CfnCluster.StorageInfoProperty.EBSStorageInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html#cfn-msk-cluster-storageinfo-ebsstorageinfo
         */
        readonly ebsStorageInfo?: CfnCluster.EBSStorageInfoProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html
     */
    interface TlsProperty {
        /**
         * `CfnCluster.TlsProperty.CertificateAuthorityArnList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html#cfn-msk-cluster-tls-certificateauthorityarnlist
         */
        readonly certificateAuthorityArnList?: string[];
    }
}
