"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClientAuthentication = exports.ClientBrokerEncryption = exports.ClusterMonitoringLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const kms = require("../../aws-kms"); // Automatically re-written from '@aws-cdk/aws-kms'
const secretsmanager = require("../../aws-secretsmanager"); // Automatically re-written from '@aws-cdk/aws-secretsmanager'
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cr = require("../../custom-resources"); // Automatically re-written from '@aws-cdk/custom-resources'
const uniqueid_1 = require("constructs/lib/private/uniqueid");
const _1 = require("./");
/**
 * A new or imported MSK Cluster.
 */
class ClusterBase extends core.Resource {
    /**
     * (experimental) Manages connections for the cluster.
     *
     * @experimental
     */
    get connections() {
        if (!this._connections) {
            throw new Error('An imported Cluster cannot manage its security groups');
        }
        return this._connections;
    }
}
/**
 * (experimental) The level of monitoring for the MSK cluster.
 *
 * @see https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html#metrics-details
 * @experimental
 */
var ClusterMonitoringLevel;
(function (ClusterMonitoringLevel) {
    ClusterMonitoringLevel["DEFAULT"] = "DEFAULT";
    ClusterMonitoringLevel["PER_BROKER"] = "PER_BROKER";
    ClusterMonitoringLevel["PER_TOPIC_PER_BROKER"] = "PER_TOPIC_PER_BROKER";
    ClusterMonitoringLevel["PER_TOPIC_PER_PARTITION"] = "PER_TOPIC_PER_PARTITION";
})(ClusterMonitoringLevel = exports.ClusterMonitoringLevel || (exports.ClusterMonitoringLevel = {}));
/**
 * (experimental) Indicates the encryption setting for data in transit between clients and brokers.
 *
 * @experimental
 */
var ClientBrokerEncryption;
(function (ClientBrokerEncryption) {
    ClientBrokerEncryption["TLS"] = "TLS";
    ClientBrokerEncryption["TLS_PLAINTEXT"] = "TLS_PLAINTEXT";
    ClientBrokerEncryption["PLAINTEXT"] = "PLAINTEXT";
})(ClientBrokerEncryption = exports.ClientBrokerEncryption || (exports.ClientBrokerEncryption = {}));
/**
 * (experimental) Configuration properties for client authentication.
 *
 * @experimental
 */
class ClientAuthentication {
    /**
     * @param saslProps - properties for SASL authentication
     * @param tlsProps - properties for TLS authentication
     */
    constructor(saslProps, tlsProps) {
        this.saslProps = saslProps;
        this.tlsProps = tlsProps;
    }
    /**
     * (experimental) SASL authentication.
     *
     * @experimental
     */
    static sasl(props) {
        return new ClientAuthentication(props, undefined);
    }
    /**
     * (experimental) TLS authentication.
     *
     * @experimental
     */
    static tls(props) {
        return new ClientAuthentication(undefined, props);
    }
}
exports.ClientAuthentication = ClientAuthentication;
_a = JSII_RTTI_SYMBOL_1;
ClientAuthentication[_a] = { fqn: "monocdk.aws_msk.ClientAuthentication", version: "1.106.1" };
/**
 * (experimental) Create a MSK Cluster.
 *
 * @experimental
 * @resource AWS::MSK::Cluster
 */
class Cluster extends ClusterBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17;
        super(scope, id, {
            physicalName: props.clusterName,
        });
        const subnetSelection = props.vpc.selectSubnets(props.vpcSubnets);
        this._connections = new ec2.Connections({
            securityGroups: (_c = props.securityGroups) !== null && _c !== void 0 ? _c : [
                new ec2.SecurityGroup(this, 'SecurityGroup', {
                    description: 'MSK security group',
                    vpc: props.vpc,
                }),
            ],
        });
        if (subnetSelection.subnets.length < 2) {
            throw Error(`Cluster requires at least 2 subnets, got ${subnetSelection.subnets.length}`);
        }
        if (!core.Token.isUnresolved(props.clusterName) &&
            !/^[a-zA-Z0-9]+$/.test(props.clusterName) &&
            props.clusterName.length > 64) {
            throw Error('The cluster name must only contain alphanumeric characters and have a maximum length of 64 characters.' +
                `got: '${props.clusterName}. length: ${props.clusterName.length}'`);
        }
        if (((_d = props.encryptionInTransit) === null || _d === void 0 ? void 0 : _d.clientBroker) ===
            ClientBrokerEncryption.PLAINTEXT &&
            props.clientAuthentication) {
            throw Error('To enable client authentication, you must enabled TLS-encrypted traffic between clients and brokers.');
        }
        else if (((_e = props.encryptionInTransit) === null || _e === void 0 ? void 0 : _e.clientBroker) ===
            ClientBrokerEncryption.TLS_PLAINTEXT && ((_g = (_f = props.clientAuthentication) === null || _f === void 0 ? void 0 : _f.saslProps) === null || _g === void 0 ? void 0 : _g.scram)) {
            throw Error('To enable SASL/SCRAM authentication, you must only allow TLS-encrypted traffic between clients and brokers.');
        }
        const volumeSize = (_j = (_h = props.ebsStorageInfo) === null || _h === void 0 ? void 0 : _h.volumeSize) !== null && _j !== void 0 ? _j : 1000;
        // Minimum: 1 GiB, maximum: 16384 GiB
        if (volumeSize < 1 || volumeSize > 16384) {
            throw Error('EBS volume size should be in the range 1-16384');
        }
        const instanceType = props.instanceType
            ? this.mskInstanceType(props.instanceType)
            : this.mskInstanceType(ec2.InstanceType.of(ec2.InstanceClass.M5, ec2.InstanceSize.LARGE));
        const encryptionAtRest = ((_k = props.ebsStorageInfo) === null || _k === void 0 ? void 0 : _k.encryptionKey) ? {
            dataVolumeKmsKeyId: props.ebsStorageInfo.encryptionKey.keyId,
        }
            : undefined; // MSK will create the managed key
        const encryptionInTransit = {
            clientBroker: (_m = (_l = props.encryptionInTransit) === null || _l === void 0 ? void 0 : _l.clientBroker) !== null && _m !== void 0 ? _m : ClientBrokerEncryption.TLS,
            inCluster: (_p = (_o = props.encryptionInTransit) === null || _o === void 0 ? void 0 : _o.enableInCluster) !== null && _p !== void 0 ? _p : true,
        };
        const openMonitoring = ((_q = props.monitoring) === null || _q === void 0 ? void 0 : _q.enablePrometheusJmxExporter) || ((_r = props.monitoring) === null || _r === void 0 ? void 0 : _r.enablePrometheusNodeExporter)
            ? {
                prometheus: {
                    jmxExporter: ((_s = props.monitoring) === null || _s === void 0 ? void 0 : _s.enablePrometheusJmxExporter) ? { enabledInBroker: true }
                        : undefined,
                    nodeExporter: ((_t = props.monitoring) === null || _t === void 0 ? void 0 : _t.enablePrometheusNodeExporter) ? { enabledInBroker: true }
                        : undefined,
                },
            }
            : undefined;
        const loggingInfo = {
            brokerLogs: {
                cloudWatchLogs: {
                    enabled: ((_u = props.logging) === null || _u === void 0 ? void 0 : _u.cloudwatchLogGroup) !== undefined,
                    logGroup: (_w = (_v = props.logging) === null || _v === void 0 ? void 0 : _v.cloudwatchLogGroup) === null || _w === void 0 ? void 0 : _w.logGroupName,
                },
                firehose: {
                    enabled: ((_x = props.logging) === null || _x === void 0 ? void 0 : _x.firehoseDeliveryStreamName) !==
                        undefined,
                    deliveryStream: (_y = props.logging) === null || _y === void 0 ? void 0 : _y.firehoseDeliveryStreamName,
                },
                s3: {
                    enabled: ((_0 = (_z = props.logging) === null || _z === void 0 ? void 0 : _z.s3) === null || _0 === void 0 ? void 0 : _0.bucket) !== undefined,
                    bucket: (_3 = (_2 = props.logging) === null || _2 === void 0 ? void 0 : _2.s3) === null || _3 === void 0 ? void 0 : _3.bucket.bucketName,
                    prefix: (_5 = (_4 = props.logging) === null || _4 === void 0 ? void 0 : _4.s3) === null || _5 === void 0 ? void 0 : _5.prefix,
                },
            },
        };
        if (((_7 = (_6 = props.clientAuthentication) === null || _6 === void 0 ? void 0 : _6.saslProps) === null || _7 === void 0 ? void 0 : _7.scram) &&
            ((_9 = (_8 = props.clientAuthentication) === null || _8 === void 0 ? void 0 : _8.saslProps) === null || _9 === void 0 ? void 0 : _9.key) === undefined) {
            this.saslScramAuthenticationKey = new kms.Key(this, 'SASLKey', {
                description: 'Used for encrypting MSK secrets for SASL/SCRAM authentication.',
                alias: `msk/${props.clusterName}/sasl/scram`,
            });
            // https://docs.aws.amazon.com/kms/latest/developerguide/services-secrets-manager.html#asm-policies
            this.saslScramAuthenticationKey.addToResourcePolicy(new iam.PolicyStatement({
                sid: 'Allow access through AWS Secrets Manager for all principals in the account that are authorized to use AWS Secrets Manager',
                principals: [new iam.Anyone()],
                actions: [
                    'kms:Encrypt',
                    'kms:Decrypt',
                    'kms:ReEncrypt*',
                    'kms:GenerateDataKey*',
                    'kms:CreateGrant',
                    'kms:DescribeKey',
                ],
                resources: ['*'],
                conditions: {
                    StringEquals: {
                        'kms:ViaService': `secretsmanager.${core.Stack.of(this).region}.amazonaws.com`,
                        'kms:CallerAccount': core.Stack.of(this).account,
                    },
                },
            }));
        }
        const clientAuthentication = props.clientAuthentication
            ? {
                sasl: ((_11 = (_10 = props.clientAuthentication) === null || _10 === void 0 ? void 0 : _10.saslProps) === null || _11 === void 0 ? void 0 : _11.scram) ? {
                    scram: {
                        enabled: (_12 = props.clientAuthentication) === null || _12 === void 0 ? void 0 : _12.saslProps.scram,
                    },
                }
                    : undefined,
                tls: ((_14 = (_13 = props.clientAuthentication) === null || _13 === void 0 ? void 0 : _13.tlsProps) === null || _14 === void 0 ? void 0 : _14.certificateAuthorityArns) ? {
                    certificateAuthorityArnList: (_16 = (_15 = props.clientAuthentication) === null || _15 === void 0 ? void 0 : _15.tlsProps) === null || _16 === void 0 ? void 0 : _16.certificateAuthorityArns,
                }
                    : undefined,
            }
            : undefined;
        const resource = new _1.CfnCluster(this, 'Resource', {
            clusterName: props.clusterName,
            kafkaVersion: props.kafkaVersion.version,
            numberOfBrokerNodes: props.numberOfBrokerNodes !== undefined ?
                subnetSelection.availabilityZones.length * props.numberOfBrokerNodes : subnetSelection.availabilityZones.length,
            brokerNodeGroupInfo: {
                instanceType,
                clientSubnets: subnetSelection.subnetIds,
                securityGroups: this.connections.securityGroups.map((group) => group.securityGroupId),
                storageInfo: {
                    ebsStorageInfo: {
                        volumeSize: volumeSize,
                    },
                },
            },
            encryptionInfo: {
                encryptionAtRest,
                encryptionInTransit,
            },
            configurationInfo: props.configurationInfo,
            enhancedMonitoring: (_17 = props.monitoring) === null || _17 === void 0 ? void 0 : _17.clusterMonitoringLevel,
            openMonitoring: openMonitoring,
            loggingInfo: loggingInfo,
            clientAuthentication: clientAuthentication,
        });
        this.clusterName = this.getResourceNameAttribute(core.Fn.select(1, core.Fn.split('/', resource.ref)));
        this.clusterArn = resource.ref;
        resource.applyRemovalPolicy(props.removalPolicy, {
            default: core.RemovalPolicy.RETAIN,
        });
    }
    /**
     * (experimental) Reference an existing cluster, defined outside of the CDK code, by name.
     *
     * @experimental
     */
    static fromClusterArn(scope, id, clusterArn) {
        class Import extends ClusterBase {
            constructor() {
                super(...arguments);
                this.clusterArn = clusterArn;
                this.clusterName = core.Fn.select(1, core.Fn.split('/', clusterArn)); // ['arn:partition:kafka:region:account-id', clusterName, clusterId]
            }
        }
        return new Import(scope, id);
    }
    mskInstanceType(instanceType) {
        return `kafka.${instanceType.toString()}`;
    }
    /**
     * Get the ZooKeeper Connection string
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @param responseField Field to return from API call. eg. ZookeeperConnectString, ZookeeperConnectStringTls
     * @returns - The connection string to use to connect to the Apache ZooKeeper cluster.
     */
    _zookeeperConnectionString(responseField) {
        if (!this._clusterDescription) {
            this._clusterDescription = new cr.AwsCustomResource(this, 'ZookeeperConnect', {
                onUpdate: {
                    service: 'Kafka',
                    action: 'describeCluster',
                    parameters: {
                        ClusterArn: this.clusterArn,
                    },
                    physicalResourceId: cr.PhysicalResourceId.of('ZooKeeperConnectionString'),
                },
                policy: cr.AwsCustomResourcePolicy.fromSdkCalls({
                    resources: [this.clusterArn],
                }),
            });
        }
        return this._clusterDescription.getResponseField(`ClusterInfo.${responseField}`);
    }
    /**
     * (experimental) Get the ZooKeeper Connection string.
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @returns - The connection string to use to connect to the Apache ZooKeeper cluster.
     * @experimental
     */
    get zookeeperConnectionString() {
        return this._zookeeperConnectionString('ZookeeperConnectString');
    }
    /**
     * (experimental) Get the ZooKeeper Connection string for a TLS enabled cluster.
     *
     * Uses a Custom Resource to make an API call to `describeCluster` using the Javascript SDK
     *
     * @returns - The connection string to use to connect to zookeeper cluster on TLS port.
     * @experimental
     */
    get zookeeperConnectionStringTls() {
        return this._zookeeperConnectionString('ZookeeperConnectStringTls');
    }
    /**
     * Get the list of brokers that a client application can use to bootstrap
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @param responseField Field to return from API call. eg. BootstrapBrokerStringSaslScram, BootstrapBrokerString
     * @returns - A string containing one or more hostname:port pairs.
     */
    _bootstrapBrokers(responseField) {
        if (!this._clusterBootstrapBrokers) {
            this._clusterBootstrapBrokers = new cr.AwsCustomResource(this, `BootstrapBrokers${responseField}`, {
                onUpdate: {
                    service: 'Kafka',
                    action: 'getBootstrapBrokers',
                    parameters: {
                        ClusterArn: this.clusterArn,
                    },
                    physicalResourceId: cr.PhysicalResourceId.of('BootstrapBrokers'),
                },
                policy: cr.AwsCustomResourcePolicy.fromSdkCalls({
                    resources: [this.clusterArn],
                }),
            });
        }
        return this._clusterBootstrapBrokers.getResponseField(responseField);
    }
    /**
     * (experimental) Get the list of brokers that a client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more hostname:port pairs.
     * @experimental
     */
    get bootstrapBrokers() {
        return this._bootstrapBrokers('BootstrapBrokerString');
    }
    /**
     * (experimental) Get the list of brokers that a TLS authenticated client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more DNS names (or IP) and TLS port pairs.
     * @experimental
     */
    get bootstrapBrokersTls() {
        return this._bootstrapBrokers('BootstrapBrokerStringTls');
    }
    /**
     * (experimental) Get the list of brokers that a SASL/SCRAM authenticated client application can use to bootstrap.
     *
     * Uses a Custom Resource to make an API call to `getBootstrapBrokers` using the Javascript SDK
     *
     * @returns - A string containing one or more dns name (or IP) and SASL SCRAM port pairs.
     * @experimental
     */
    get bootstrapBrokersSaslScram() {
        return this._bootstrapBrokers('BootstrapBrokerStringSaslScram');
    }
    /**
     * (experimental) A list of usersnames to register with the cluster.
     *
     * The password will automatically be generated using Secrets
     * Manager and the { username, password } JSON object stored in Secrets Manager as `AmazonMSK_username`.
     *
     * Must be using the SASL/SCRAM authentication mechanism.
     *
     * @param usernames - username(s) to register with the cluster.
     * @experimental
     */
    addUser(...usernames) {
        var _c;
        if (this.saslScramAuthenticationKey) {
            const MSK_SECRET_PREFIX = 'AmazonMSK_'; // Required
            const secrets = usernames.map((username) => new secretsmanager.Secret(this, `KafkaUser${username}`, {
                secretName: `${MSK_SECRET_PREFIX}${this.clusterName}_${username}`,
                generateSecretString: {
                    secretStringTemplate: JSON.stringify({ username }),
                    generateStringKey: 'password',
                },
                encryptionKey: this.saslScramAuthenticationKey,
            }));
            new cr.AwsCustomResource(this, `BatchAssociateScramSecrets${uniqueid_1.addressOf(usernames)}`, {
                onUpdate: {
                    service: 'Kafka',
                    action: 'batchAssociateScramSecret',
                    parameters: {
                        ClusterArn: this.clusterArn,
                        SecretArnList: secrets.map((secret) => secret.secretArn),
                    },
                    physicalResourceId: cr.PhysicalResourceId.of('CreateUsers'),
                },
                policy: cr.AwsCustomResourcePolicy.fromStatements([
                    new iam.PolicyStatement({
                        actions: ['kms:CreateGrant'],
                        resources: [(_c = this.saslScramAuthenticationKey) === null || _c === void 0 ? void 0 : _c.keyArn],
                    }),
                    new iam.PolicyStatement({
                        actions: ['kafka:BatchAssociateScramSecret'],
                        resources: [this.clusterArn],
                    }),
                ]),
            });
        }
        else {
            throw Error('Cannot create users if an authentication KMS key has not been created/provided.');
        }
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "monocdk.aws_msk.Cluster", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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