import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::MediaLive::Channel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export interface CfnChannelProps {
    /**
     * `AWS::MediaLive::Channel.CdiInputSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification
     */
    readonly cdiInputSpecification?: CfnChannel.CdiInputSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.ChannelClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     */
    readonly channelClass?: string;
    /**
     * `AWS::MediaLive::Channel.Destinations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     */
    readonly destinations?: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     */
    readonly encoderSettings?: CfnChannel.EncoderSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     */
    readonly inputAttachments?: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     */
    readonly inputSpecification?: CfnChannel.InputSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.LogLevel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     */
    readonly logLevel?: string;
    /**
     * `AWS::MediaLive::Channel.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Channel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::Channel.Vpc`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-vpc
     */
    readonly vpc?: CfnChannel.VpcOutputSettingsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Channel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnChannel;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Inputs
     */
    readonly attrInputs: string[];
    /**
     * `AWS::MediaLive::Channel.CdiInputSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification
     */
    cdiInputSpecification: CfnChannel.CdiInputSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.ChannelClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     */
    channelClass: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Destinations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     */
    destinations: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     */
    encoderSettings: CfnChannel.EncoderSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     */
    inputAttachments: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     */
    inputSpecification: CfnChannel.InputSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.LogLevel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     */
    logLevel: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Channel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::Channel.Vpc`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-vpc
     */
    vpc: CfnChannel.VpcOutputSettingsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::Channel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html
     */
    interface AacSettingsProperty {
        /**
         * `CfnChannel.AacSettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.AacSettingsProperty.CodingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-codingmode
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.AacSettingsProperty.InputType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-inputtype
         */
        readonly inputType?: string;
        /**
         * `CfnChannel.AacSettingsProperty.Profile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-profile
         */
        readonly profile?: string;
        /**
         * `CfnChannel.AacSettingsProperty.RateControlMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-ratecontrolmode
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.AacSettingsProperty.RawFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-rawformat
         */
        readonly rawFormat?: string;
        /**
         * `CfnChannel.AacSettingsProperty.SampleRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-samplerate
         */
        readonly sampleRate?: number;
        /**
         * `CfnChannel.AacSettingsProperty.Spec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-spec
         */
        readonly spec?: string;
        /**
         * `CfnChannel.AacSettingsProperty.VbrQuality`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-vbrquality
         */
        readonly vbrQuality?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html
     */
    interface Ac3SettingsProperty {
        /**
         * `CfnChannel.Ac3SettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Ac3SettingsProperty.BitstreamMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitstreammode
         */
        readonly bitstreamMode?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.CodingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-codingmode
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.Dialnorm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-dialnorm
         */
        readonly dialnorm?: number;
        /**
         * `CfnChannel.Ac3SettingsProperty.DrcProfile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-drcprofile
         */
        readonly drcProfile?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.LfeFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-lfefilter
         */
        readonly lfeFilter?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.MetadataControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-metadatacontrol
         */
        readonly metadataControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html
     */
    interface AncillarySourceSettingsProperty {
        /**
         * `CfnChannel.AncillarySourceSettingsProperty.SourceAncillaryChannelNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html#cfn-medialive-channel-ancillarysourcesettings-sourceancillarychannelnumber
         */
        readonly sourceAncillaryChannelNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html
     */
    interface ArchiveCdnSettingsProperty {
        /**
         * `CfnChannel.ArchiveCdnSettingsProperty.ArchiveS3Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html#cfn-medialive-channel-archivecdnsettings-archives3settings
         */
        readonly archiveS3Settings?: CfnChannel.ArchiveS3SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html
     */
    interface ArchiveContainerSettingsProperty {
        /**
         * `CfnChannel.ArchiveContainerSettingsProperty.M2tsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-m2tssettings
         */
        readonly m2TsSettings?: CfnChannel.M2tsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveContainerSettingsProperty.RawSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-rawsettings
         */
        readonly rawSettings?: CfnChannel.RawSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html
     */
    interface ArchiveGroupSettingsProperty {
        /**
         * `CfnChannel.ArchiveGroupSettingsProperty.ArchiveCdnSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-archivecdnsettings
         */
        readonly archiveCdnSettings?: CfnChannel.ArchiveCdnSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveGroupSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveGroupSettingsProperty.RolloverInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-rolloverinterval
         */
        readonly rolloverInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html
     */
    interface ArchiveOutputSettingsProperty {
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.ContainerSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-containersettings
         */
        readonly containerSettings?: CfnChannel.ArchiveContainerSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.Extension`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-extension
         */
        readonly extension?: string;
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.NameModifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-namemodifier
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html
     */
    interface ArchiveS3SettingsProperty {
        /**
         * `CfnChannel.ArchiveS3SettingsProperty.CannedAcl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html#cfn-medialive-channel-archives3settings-cannedacl
         */
        readonly cannedAcl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribdestinationsettings.html
     */
    interface AribDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html
     */
    interface AribSourceSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html
     */
    interface AudioChannelMappingProperty {
        /**
         * `CfnChannel.AudioChannelMappingProperty.InputChannelLevels`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-inputchannellevels
         */
        readonly inputChannelLevels?: Array<CfnChannel.InputChannelLevelProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.AudioChannelMappingProperty.OutputChannel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-outputchannel
         */
        readonly outputChannel?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html
     */
    interface AudioCodecSettingsProperty {
        /**
         * `CfnChannel.AudioCodecSettingsProperty.AacSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-aacsettings
         */
        readonly aacSettings?: CfnChannel.AacSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Ac3Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-ac3settings
         */
        readonly ac3Settings?: CfnChannel.Ac3SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Eac3Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3settings
         */
        readonly eac3Settings?: CfnChannel.Eac3SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Mp2Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-mp2settings
         */
        readonly mp2Settings?: CfnChannel.Mp2SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.PassThroughSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-passthroughsettings
         */
        readonly passThroughSettings?: CfnChannel.PassThroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.WavSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-wavsettings
         */
        readonly wavSettings?: CfnChannel.WavSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html
     */
    interface AudioDescriptionProperty {
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioNormalizationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audionormalizationsettings
         */
        readonly audioNormalizationSettings?: CfnChannel.AudioNormalizationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioSelectorName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audioselectorname
         */
        readonly audioSelectorName?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotype
         */
        readonly audioType?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioTypeControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotypecontrol
         */
        readonly audioTypeControl?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.CodecSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-codecsettings
         */
        readonly codecSettings?: CfnChannel.AudioCodecSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.LanguageCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.LanguageCodeControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecodecontrol
         */
        readonly languageCodeControl?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.RemixSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-remixsettings
         */
        readonly remixSettings?: CfnChannel.RemixSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.StreamName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-streamname
         */
        readonly streamName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html
     */
    interface AudioLanguageSelectionProperty {
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageSelectionPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy
         */
        readonly languageSelectionPolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html
     */
    interface AudioNormalizationSettingsProperty {
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.Algorithm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithm
         */
        readonly algorithm?: string;
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.AlgorithmControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithmcontrol
         */
        readonly algorithmControl?: string;
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.TargetLkfs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-targetlkfs
         */
        readonly targetLkfs?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html
     */
    interface AudioOnlyHlsSettingsProperty {
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioGroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiogroupid
         */
        readonly audioGroupId?: string;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioOnlyImage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audioonlyimage
         */
        readonly audioOnlyImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioTrackType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiotracktype
         */
        readonly audioTrackType?: string;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.SegmentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-segmenttype
         */
        readonly segmentType?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html
     */
    interface AudioPidSelectionProperty {
        /**
         * `CfnChannel.AudioPidSelectionProperty.Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html
     */
    interface AudioSelectorProperty {
        /**
         * `CfnChannel.AudioSelectorProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.AudioSelectorProperty.SelectorSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.AudioSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html
     */
    interface AudioSelectorSettingsProperty {
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioLanguageSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection
         */
        readonly audioLanguageSelection?: CfnChannel.AudioLanguageSelectionProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioPidSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection
         */
        readonly audioPidSelection?: CfnChannel.AudioPidSelectionProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioTrackSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiotrackselection
         */
        readonly audioTrackSelection?: CfnChannel.AudioTrackSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html
     */
    interface AudioSilenceFailoverSettingsProperty {
        /**
         * `CfnChannel.AudioSilenceFailoverSettingsProperty.AudioSelectorName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audioselectorname
         */
        readonly audioSelectorName?: string;
        /**
         * `CfnChannel.AudioSilenceFailoverSettingsProperty.AudioSilenceThresholdMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audiosilencethresholdmsec
         */
        readonly audioSilenceThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html
     */
    interface AudioTrackProperty {
        /**
         * `CfnChannel.AudioTrackProperty.Track`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html#cfn-medialive-channel-audiotrack-track
         */
        readonly track?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html
     */
    interface AudioTrackSelectionProperty {
        /**
         * `CfnChannel.AudioTrackSelectionProperty.Tracks`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-tracks
         */
        readonly tracks?: Array<CfnChannel.AudioTrackProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html
     */
    interface AutomaticInputFailoverSettingsProperty {
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.ErrorClearTimeMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-errorcleartimemsec
         */
        readonly errorClearTimeMsec?: number;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.FailoverConditions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-failoverconditions
         */
        readonly failoverConditions?: Array<CfnChannel.FailoverConditionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.InputPreference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-inputpreference
         */
        readonly inputPreference?: string;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.SecondaryInputId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-secondaryinputid
         */
        readonly secondaryInputId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html
     */
    interface AvailBlankingProperty {
        /**
         * `CfnChannel.AvailBlankingProperty.AvailBlankingImage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-availblankingimage
         */
        readonly availBlankingImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AvailBlankingProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-state
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html
     */
    interface AvailConfigurationProperty {
        /**
         * `CfnChannel.AvailConfigurationProperty.AvailSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-availsettings
         */
        readonly availSettings?: CfnChannel.AvailSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html
     */
    interface AvailSettingsProperty {
        /**
         * `CfnChannel.AvailSettingsProperty.Scte35SpliceInsert`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35spliceinsert
         */
        readonly scte35SpliceInsert?: CfnChannel.Scte35SpliceInsertProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AvailSettingsProperty.Scte35TimeSignalApos`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35timesignalapos
         */
        readonly scte35TimeSignalApos?: CfnChannel.Scte35TimeSignalAposProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html
     */
    interface BlackoutSlateProperty {
        /**
         * `CfnChannel.BlackoutSlateProperty.BlackoutSlateImage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-blackoutslateimage
         */
        readonly blackoutSlateImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkEndBlackout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackout
         */
        readonly networkEndBlackout?: string;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkEndBlackoutImage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackoutimage
         */
        readonly networkEndBlackoutImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkid
         */
        readonly networkId?: string;
        /**
         * `CfnChannel.BlackoutSlateProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-state
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html
     */
    interface BurnInDestinationSettingsProperty {
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.BackgroundOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundopacity
         */
        readonly backgroundOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.Font`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-font
         */
        readonly font?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontcolor
         */
        readonly fontColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontopacity
         */
        readonly fontOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontResolution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontresolution
         */
        readonly fontResolution?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontsize
         */
        readonly fontSize?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.OutlineColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinecolor
         */
        readonly outlineColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.OutlineSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinesize
         */
        readonly outlineSize?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowcolor
         */
        readonly shadowColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowopacity
         */
        readonly shadowOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowXOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowxoffset
         */
        readonly shadowXOffset?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowYOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowyoffset
         */
        readonly shadowYOffset?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.TeletextGridControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-teletextgridcontrol
         */
        readonly teletextGridControl?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.XPosition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-xposition
         */
        readonly xPosition?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.YPosition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-yposition
         */
        readonly yPosition?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html
     */
    interface CaptionDescriptionProperty {
        /**
         * `CfnChannel.CaptionDescriptionProperty.CaptionSelectorName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captionselectorname
         */
        readonly captionSelectorName?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.DestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-destinationsettings
         */
        readonly destinationSettings?: CfnChannel.CaptionDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDescriptionProperty.LanguageCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.LanguageDescription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagedescription
         */
        readonly languageDescription?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html
     */
    interface CaptionDestinationSettingsProperty {
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.AribDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-aribdestinationsettings
         */
        readonly aribDestinationSettings?: CfnChannel.AribDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.BurnInDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-burnindestinationsettings
         */
        readonly burnInDestinationSettings?: CfnChannel.BurnInDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.DvbSubDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-dvbsubdestinationsettings
         */
        readonly dvbSubDestinationSettings?: CfnChannel.DvbSubDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EbuTtDDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ebuttddestinationsettings
         */
        readonly ebuTtDDestinationSettings?: CfnChannel.EbuTtDDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EmbeddedDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddeddestinationsettings
         */
        readonly embeddedDestinationSettings?: CfnChannel.EmbeddedDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EmbeddedPlusScte20DestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddedplusscte20destinationsettings
         */
        readonly embeddedPlusScte20DestinationSettings?: CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.RtmpCaptionInfoDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-rtmpcaptioninfodestinationsettings
         */
        readonly rtmpCaptionInfoDestinationSettings?: CfnChannel.RtmpCaptionInfoDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.Scte20PlusEmbeddedDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte20plusembeddeddestinationsettings
         */
        readonly scte20PlusEmbeddedDestinationSettings?: CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.Scte27DestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte27destinationsettings
         */
        readonly scte27DestinationSettings?: CfnChannel.Scte27DestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.SmpteTtDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-smptettdestinationsettings
         */
        readonly smpteTtDestinationSettings?: CfnChannel.SmpteTtDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.TeletextDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-teletextdestinationsettings
         */
        readonly teletextDestinationSettings?: CfnChannel.TeletextDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.TtmlDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ttmldestinationsettings
         */
        readonly ttmlDestinationSettings?: CfnChannel.TtmlDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.WebvttDestinationSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-webvttdestinationsettings
         */
        readonly webvttDestinationSettings?: CfnChannel.WebvttDestinationSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html
     */
    interface CaptionLanguageMappingProperty {
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.CaptionChannel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-captionchannel
         */
        readonly captionChannel?: number;
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.LanguageCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.LanguageDescription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagedescription
         */
        readonly languageDescription?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html
     */
    interface CaptionRectangleProperty {
        /**
         * `CfnChannel.CaptionRectangleProperty.Height`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-height
         */
        readonly height?: number;
        /**
         * `CfnChannel.CaptionRectangleProperty.LeftOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-leftoffset
         */
        readonly leftOffset?: number;
        /**
         * `CfnChannel.CaptionRectangleProperty.TopOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-topoffset
         */
        readonly topOffset?: number;
        /**
         * `CfnChannel.CaptionRectangleProperty.Width`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-width
         */
        readonly width?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html
     */
    interface CaptionSelectorProperty {
        /**
         * `CfnChannel.CaptionSelectorProperty.LanguageCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.SelectorSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.CaptionSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html
     */
    interface CaptionSelectorSettingsProperty {
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.AncillarySourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-ancillarysourcesettings
         */
        readonly ancillarySourceSettings?: CfnChannel.AncillarySourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.AribSourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings
         */
        readonly aribSourceSettings?: CfnChannel.AribSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.DvbSubSourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings
         */
        readonly dvbSubSourceSettings?: CfnChannel.DvbSubSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.EmbeddedSourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings
         */
        readonly embeddedSourceSettings?: CfnChannel.EmbeddedSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte20SourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings
         */
        readonly scte20SourceSettings?: CfnChannel.Scte20SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte27SourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings
         */
        readonly scte27SourceSettings?: CfnChannel.Scte27SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.TeletextSourceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings
         */
        readonly teletextSourceSettings?: CfnChannel.TeletextSourceSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html
     */
    interface CdiInputSpecificationProperty {
        /**
         * `CfnChannel.CdiInputSpecificationProperty.Resolution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html#cfn-medialive-channel-cdiinputspecification-resolution
         */
        readonly resolution?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorspacepassthroughsettings.html
     */
    interface ColorSpacePassthroughSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html
     */
    interface DvbNitSettingsProperty {
        /**
         * `CfnChannel.DvbNitSettingsProperty.NetworkId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkid
         */
        readonly networkId?: number;
        /**
         * `CfnChannel.DvbNitSettingsProperty.NetworkName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkname
         */
        readonly networkName?: string;
        /**
         * `CfnChannel.DvbNitSettingsProperty.RepInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-repinterval
         */
        readonly repInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html
     */
    interface DvbSdtSettingsProperty {
        /**
         * `CfnChannel.DvbSdtSettingsProperty.OutputSdt`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-outputsdt
         */
        readonly outputSdt?: string;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.RepInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-repinterval
         */
        readonly repInterval?: number;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-servicename
         */
        readonly serviceName?: string;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.ServiceProviderName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-serviceprovidername
         */
        readonly serviceProviderName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html
     */
    interface DvbSubDestinationSettingsProperty {
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.BackgroundOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundopacity
         */
        readonly backgroundOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.Font`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-font
         */
        readonly font?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontcolor
         */
        readonly fontColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontopacity
         */
        readonly fontOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontResolution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontresolution
         */
        readonly fontResolution?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontsize
         */
        readonly fontSize?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.OutlineColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinecolor
         */
        readonly outlineColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.OutlineSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinesize
         */
        readonly outlineSize?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowcolor
         */
        readonly shadowColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowOpacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowopacity
         */
        readonly shadowOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowXOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowxoffset
         */
        readonly shadowXOffset?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowYOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowyoffset
         */
        readonly shadowYOffset?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.TeletextGridControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-teletextgridcontrol
         */
        readonly teletextGridControl?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.XPosition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-xposition
         */
        readonly xPosition?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.YPosition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-yposition
         */
        readonly yPosition?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html
     */
    interface DvbSubSourceSettingsProperty {
        /**
         * `CfnChannel.DvbSubSourceSettingsProperty.Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html
     */
    interface DvbTdtSettingsProperty {
        /**
         * `CfnChannel.DvbTdtSettingsProperty.RepInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html#cfn-medialive-channel-dvbtdtsettings-repinterval
         */
        readonly repInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html
     */
    interface Eac3SettingsProperty {
        /**
         * `CfnChannel.Eac3SettingsProperty.AttenuationControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-attenuationcontrol
         */
        readonly attenuationControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.BitstreamMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitstreammode
         */
        readonly bitstreamMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.CodingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-codingmode
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.DcFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dcfilter
         */
        readonly dcFilter?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.Dialnorm`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dialnorm
         */
        readonly dialnorm?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.DrcLine`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcline
         */
        readonly drcLine?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.DrcRf`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcrf
         */
        readonly drcRf?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LfeControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfecontrol
         */
        readonly lfeControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LfeFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfefilter
         */
        readonly lfeFilter?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LoRoCenterMixLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorocentermixlevel
         */
        readonly loRoCenterMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LoRoSurroundMixLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorosurroundmixlevel
         */
        readonly loRoSurroundMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LtRtCenterMixLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtcentermixlevel
         */
        readonly ltRtCenterMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LtRtSurroundMixLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtsurroundmixlevel
         */
        readonly ltRtSurroundMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.MetadataControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-metadatacontrol
         */
        readonly metadataControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.PassthroughControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-passthroughcontrol
         */
        readonly passthroughControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.PhaseControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-phasecontrol
         */
        readonly phaseControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.StereoDownmix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-stereodownmix
         */
        readonly stereoDownmix?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.SurroundExMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundexmode
         */
        readonly surroundExMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.SurroundMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundmode
         */
        readonly surroundMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html
     */
    interface EbuTtDDestinationSettingsProperty {
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.CopyrightHolder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-copyrightholder
         */
        readonly copyrightHolder?: string;
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.FillLineGap`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-filllinegap
         */
        readonly fillLineGap?: string;
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.FontFamily`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-fontfamily
         */
        readonly fontFamily?: string;
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.StyleControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-stylecontrol
         */
        readonly styleControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddeddestinationsettings.html
     */
    interface EmbeddedDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedplusscte20destinationsettings.html
     */
    interface EmbeddedPlusScte20DestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html
     */
    interface EmbeddedSourceSettingsProperty {
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Convert608To708`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-convert608to708
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Scte20Detection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-scte20detection
         */
        readonly scte20Detection?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608ChannelNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608channelnumber
         */
        readonly source608ChannelNumber?: number;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608TrackNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608tracknumber
         */
        readonly source608TrackNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html
     */
    interface EncoderSettingsProperty {
        /**
         * `CfnChannel.EncoderSettingsProperty.AudioDescriptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-audiodescriptions
         */
        readonly audioDescriptions?: Array<CfnChannel.AudioDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.AvailBlanking`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availblanking
         */
        readonly availBlanking?: CfnChannel.AvailBlankingProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.AvailConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availconfiguration
         */
        readonly availConfiguration?: CfnChannel.AvailConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.BlackoutSlate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-blackoutslate
         */
        readonly blackoutSlate?: CfnChannel.BlackoutSlateProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.CaptionDescriptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-captiondescriptions
         */
        readonly captionDescriptions?: Array<CfnChannel.CaptionDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.FeatureActivations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-featureactivations
         */
        readonly featureActivations?: CfnChannel.FeatureActivationsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.GlobalConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-globalconfiguration
         */
        readonly globalConfiguration?: CfnChannel.GlobalConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.MotionGraphicsConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-motiongraphicsconfiguration
         */
        readonly motionGraphicsConfiguration?: CfnChannel.MotionGraphicsConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.NielsenConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-nielsenconfiguration
         */
        readonly nielsenConfiguration?: CfnChannel.NielsenConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.OutputGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-outputgroups
         */
        readonly outputGroups?: Array<CfnChannel.OutputGroupProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.TimecodeConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-timecodeconfig
         */
        readonly timecodeConfig?: CfnChannel.TimecodeConfigProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.VideoDescriptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-videodescriptions
         */
        readonly videoDescriptions?: Array<CfnChannel.VideoDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html
     */
    interface FailoverConditionProperty {
        /**
         * `CfnChannel.FailoverConditionProperty.FailoverConditionSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html#cfn-medialive-channel-failovercondition-failoverconditionsettings
         */
        readonly failoverConditionSettings?: CfnChannel.FailoverConditionSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html
     */
    interface FailoverConditionSettingsProperty {
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.AudioSilenceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-audiosilencesettings
         */
        readonly audioSilenceSettings?: CfnChannel.AudioSilenceFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.InputLossSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-inputlosssettings
         */
        readonly inputLossSettings?: CfnChannel.InputLossFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.VideoBlackSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-videoblacksettings
         */
        readonly videoBlackSettings?: CfnChannel.VideoBlackFailoverSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html
     */
    interface FeatureActivationsProperty {
        /**
         * `CfnChannel.FeatureActivationsProperty.InputPrepareScheduleActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html#cfn-medialive-channel-featureactivations-inputpreparescheduleactions
         */
        readonly inputPrepareScheduleActions?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html
     */
    interface FecOutputSettingsProperty {
        /**
         * `CfnChannel.FecOutputSettingsProperty.ColumnDepth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-columndepth
         */
        readonly columnDepth?: number;
        /**
         * `CfnChannel.FecOutputSettingsProperty.IncludeFec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-includefec
         */
        readonly includeFec?: string;
        /**
         * `CfnChannel.FecOutputSettingsProperty.RowLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-rowlength
         */
        readonly rowLength?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html
     */
    interface Fmp4HlsSettingsProperty {
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.AudioRenditionSets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-audiorenditionsets
         */
        readonly audioRenditionSets?: string;
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.NielsenId3Behavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-nielsenid3behavior
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.TimedMetadataBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-timedmetadatabehavior
         */
        readonly timedMetadataBehavior?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturecdnsettings.html
     */
    interface FrameCaptureCdnSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureCdnSettingsProperty.FrameCaptureS3Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturecdnsettings.html#cfn-medialive-channel-framecapturecdnsettings-framecaptures3settings
         */
        readonly frameCaptureS3Settings?: CfnChannel.FrameCaptureS3SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html
     */
    interface FrameCaptureGroupSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureGroupSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html#cfn-medialive-channel-framecapturegroupsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.FrameCaptureGroupSettingsProperty.FrameCaptureCdnSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html#cfn-medialive-channel-framecapturegroupsettings-framecapturecdnsettings
         */
        readonly frameCaptureCdnSettings?: CfnChannel.FrameCaptureCdnSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturehlssettings.html
     */
    interface FrameCaptureHlsSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html
     */
    interface FrameCaptureOutputSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureOutputSettingsProperty.NameModifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html#cfn-medialive-channel-framecaptureoutputsettings-namemodifier
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptures3settings.html
     */
    interface FrameCaptureS3SettingsProperty {
        /**
         * `CfnChannel.FrameCaptureS3SettingsProperty.CannedAcl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptures3settings.html#cfn-medialive-channel-framecaptures3settings-cannedacl
         */
        readonly cannedAcl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html
     */
    interface FrameCaptureSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureSettingsProperty.CaptureInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureinterval
         */
        readonly captureInterval?: number;
        /**
         * `CfnChannel.FrameCaptureSettingsProperty.CaptureIntervalUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureintervalunits
         */
        readonly captureIntervalUnits?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html
     */
    interface GlobalConfigurationProperty {
        /**
         * `CfnChannel.GlobalConfigurationProperty.InitialAudioGain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-initialaudiogain
         */
        readonly initialAudioGain?: number;
        /**
         * `CfnChannel.GlobalConfigurationProperty.InputEndAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputendaction
         */
        readonly inputEndAction?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.InputLossBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputlossbehavior
         */
        readonly inputLossBehavior?: CfnChannel.InputLossBehaviorProperty | cdk.IResolvable;
        /**
         * `CfnChannel.GlobalConfigurationProperty.OutputLockingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputlockingmode
         */
        readonly outputLockingMode?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.OutputTimingSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputtimingsource
         */
        readonly outputTimingSource?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.SupportLowFramerateInputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-supportlowframerateinputs
         */
        readonly supportLowFramerateInputs?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html
     */
    interface H264ColorSpaceSettingsProperty {
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.ColorSpacePassthroughSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-colorspacepassthroughsettings
         */
        readonly colorSpacePassthroughSettings?: CfnChannel.ColorSpacePassthroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.Rec601Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec601settings
         */
        readonly rec601Settings?: CfnChannel.Rec601SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.Rec709Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec709settings
         */
        readonly rec709Settings?: CfnChannel.Rec709SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html
     */
    interface H264FilterSettingsProperty {
        /**
         * `CfnChannel.H264FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html#cfn-medialive-channel-h264filtersettings-temporalfiltersettings
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html
     */
    interface H264SettingsProperty {
        /**
         * `CfnChannel.H264SettingsProperty.AdaptiveQuantization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-adaptivequantization
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.H264SettingsProperty.AfdSignaling`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-afdsignaling
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.H264SettingsProperty.BufFillPct`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-buffillpct
         */
        readonly bufFillPct?: number;
        /**
         * `CfnChannel.H264SettingsProperty.BufSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bufsize
         */
        readonly bufSize?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ColorMetadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colormetadata
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ColorSpaceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colorspacesettings
         */
        readonly colorSpaceSettings?: CfnChannel.H264ColorSpaceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264SettingsProperty.EntropyEncoding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-entropyencoding
         */
        readonly entropyEncoding?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-filtersettings
         */
        readonly filterSettings?: CfnChannel.H264FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264SettingsProperty.FixedAfd`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-fixedafd
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FlickerAq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-flickeraq
         */
        readonly flickerAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ForceFieldPictures`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-forcefieldpictures
         */
        readonly forceFieldPictures?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratecontrol
         */
        readonly framerateControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateDenominator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratedenominator
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateNumerator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratenumerator
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopBReference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopbreference
         */
        readonly gopBReference?: string;
        /**
         * `CfnChannel.H264SettingsProperty.GopClosedCadence`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopclosedcadence
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopNumBFrames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopnumbframes
         */
        readonly gopNumBFrames?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsize
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopSizeUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsizeunits
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Level`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-level
         */
        readonly level?: string;
        /**
         * `CfnChannel.H264SettingsProperty.LookAheadRateControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-lookaheadratecontrol
         */
        readonly lookAheadRateControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.MaxBitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-maxbitrate
         */
        readonly maxBitrate?: number;
        /**
         * `CfnChannel.H264SettingsProperty.MinIInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-miniinterval
         */
        readonly minIInterval?: number;
        /**
         * `CfnChannel.H264SettingsProperty.NumRefFrames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-numrefframes
         */
        readonly numRefFrames?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ParControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parcontrol
         */
        readonly parControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ParDenominator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-pardenominator
         */
        readonly parDenominator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ParNumerator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parnumerator
         */
        readonly parNumerator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.Profile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-profile
         */
        readonly profile?: string;
        /**
         * `CfnChannel.H264SettingsProperty.QualityLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qualitylevel
         */
        readonly qualityLevel?: string;
        /**
         * `CfnChannel.H264SettingsProperty.QvbrQualityLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qvbrqualitylevel
         */
        readonly qvbrQualityLevel?: number;
        /**
         * `CfnChannel.H264SettingsProperty.RateControlMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-ratecontrolmode
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ScanType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scantype
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.H264SettingsProperty.SceneChangeDetect`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scenechangedetect
         */
        readonly sceneChangeDetect?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Slices`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-slices
         */
        readonly slices?: number;
        /**
         * `CfnChannel.H264SettingsProperty.Softness`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-softness
         */
        readonly softness?: number;
        /**
         * `CfnChannel.H264SettingsProperty.SpatialAq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-spatialaq
         */
        readonly spatialAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.SubgopLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-subgoplength
         */
        readonly subgopLength?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Syntax`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-syntax
         */
        readonly syntax?: string;
        /**
         * `CfnChannel.H264SettingsProperty.TemporalAq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-temporalaq
         */
        readonly temporalAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.TimecodeInsertion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-timecodeinsertion
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html
     */
    interface H265ColorSpaceSettingsProperty {
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.ColorSpacePassthroughSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-colorspacepassthroughsettings
         */
        readonly colorSpacePassthroughSettings?: CfnChannel.ColorSpacePassthroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Hdr10Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-hdr10settings
         */
        readonly hdr10Settings?: CfnChannel.Hdr10SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Rec601Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec601settings
         */
        readonly rec601Settings?: CfnChannel.Rec601SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Rec709Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec709settings
         */
        readonly rec709Settings?: CfnChannel.Rec709SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html
     */
    interface H265FilterSettingsProperty {
        /**
         * `CfnChannel.H265FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html#cfn-medialive-channel-h265filtersettings-temporalfiltersettings
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html
     */
    interface H265SettingsProperty {
        /**
         * `CfnChannel.H265SettingsProperty.AdaptiveQuantization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-adaptivequantization
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.H265SettingsProperty.AfdSignaling`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-afdsignaling
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.H265SettingsProperty.AlternativeTransferFunction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-alternativetransferfunction
         */
        readonly alternativeTransferFunction?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.H265SettingsProperty.BufSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bufsize
         */
        readonly bufSize?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ColorMetadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colormetadata
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.H265SettingsProperty.ColorSpaceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colorspacesettings
         */
        readonly colorSpaceSettings?: CfnChannel.H265ColorSpaceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265SettingsProperty.FilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-filtersettings
         */
        readonly filterSettings?: CfnChannel.H265FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265SettingsProperty.FixedAfd`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-fixedafd
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.H265SettingsProperty.FlickerAq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-flickeraq
         */
        readonly flickerAq?: string;
        /**
         * `CfnChannel.H265SettingsProperty.FramerateDenominator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratedenominator
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.FramerateNumerator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratenumerator
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopClosedCadence`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopclosedcadence
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsize
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopSizeUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsizeunits
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Level`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-level
         */
        readonly level?: string;
        /**
         * `CfnChannel.H265SettingsProperty.LookAheadRateControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-lookaheadratecontrol
         */
        readonly lookAheadRateControl?: string;
        /**
         * `CfnChannel.H265SettingsProperty.MaxBitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-maxbitrate
         */
        readonly maxBitrate?: number;
        /**
         * `CfnChannel.H265SettingsProperty.MinIInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-miniinterval
         */
        readonly minIInterval?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ParDenominator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-pardenominator
         */
        readonly parDenominator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ParNumerator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-parnumerator
         */
        readonly parNumerator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.Profile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-profile
         */
        readonly profile?: string;
        /**
         * `CfnChannel.H265SettingsProperty.QvbrQualityLevel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-qvbrqualitylevel
         */
        readonly qvbrQualityLevel?: number;
        /**
         * `CfnChannel.H265SettingsProperty.RateControlMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-ratecontrolmode
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.H265SettingsProperty.ScanType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scantype
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.H265SettingsProperty.SceneChangeDetect`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scenechangedetect
         */
        readonly sceneChangeDetect?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Slices`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-slices
         */
        readonly slices?: number;
        /**
         * `CfnChannel.H265SettingsProperty.Tier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-tier
         */
        readonly tier?: string;
        /**
         * `CfnChannel.H265SettingsProperty.TimecodeInsertion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-timecodeinsertion
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html
     */
    interface Hdr10SettingsProperty {
        /**
         * `CfnChannel.Hdr10SettingsProperty.MaxCll`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxcll
         */
        readonly maxCll?: number;
        /**
         * `CfnChannel.Hdr10SettingsProperty.MaxFall`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxfall
         */
        readonly maxFall?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html
     */
    interface HlsAkamaiSettingsProperty {
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.FilecacheDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-filecacheduration
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.HttpTransferMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-httptransfermode
         */
        readonly httpTransferMode?: string;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-numretries
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-restartdelay
         */
        readonly restartDelay?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.Salt`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-salt
         */
        readonly salt?: string;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.Token`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-token
         */
        readonly token?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html
     */
    interface HlsBasicPutSettingsProperty {
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.FilecacheDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-filecacheduration
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-numretries
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-restartdelay
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html
     */
    interface HlsCdnSettingsProperty {
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsAkamaiSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsakamaisettings
         */
        readonly hlsAkamaiSettings?: CfnChannel.HlsAkamaiSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsBasicPutSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsbasicputsettings
         */
        readonly hlsBasicPutSettings?: CfnChannel.HlsBasicPutSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsMediaStoreSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsmediastoresettings
         */
        readonly hlsMediaStoreSettings?: CfnChannel.HlsMediaStoreSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsS3Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlss3settings
         */
        readonly hlsS3Settings?: CfnChannel.HlsS3SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsWebdavSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlswebdavsettings
         */
        readonly hlsWebdavSettings?: CfnChannel.HlsWebdavSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html
     */
    interface HlsGroupSettingsProperty {
        /**
         * `CfnChannel.HlsGroupSettingsProperty.AdMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-admarkers
         */
        readonly adMarkers?: string[];
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlContent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent
         */
        readonly baseUrlContent?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlContent1`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent1
         */
        readonly baseUrlContent1?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlManifest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest
         */
        readonly baseUrlManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlManifest1`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest1
         */
        readonly baseUrlManifest1?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CaptionLanguageMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagemappings
         */
        readonly captionLanguageMappings?: Array<CfnChannel.CaptionLanguageMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CaptionLanguageSetting`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagesetting
         */
        readonly captionLanguageSetting?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ClientCache`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-clientcache
         */
        readonly clientCache?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CodecSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-codecspecification
         */
        readonly codecSpecification?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ConstantIv`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-constantiv
         */
        readonly constantIv?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.DirectoryStructure`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-directorystructure
         */
        readonly directoryStructure?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.DiscontinuityTags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-discontinuitytags
         */
        readonly discontinuityTags?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.EncryptionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-encryptiontype
         */
        readonly encryptionType?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.HlsCdnSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlscdnsettings
         */
        readonly hlsCdnSettings?: CfnChannel.HlsCdnSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.HlsId3SegmentTagging`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlsid3segmenttagging
         */
        readonly hlsId3SegmentTagging?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IFrameOnlyPlaylists`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-iframeonlyplaylists
         */
        readonly iFrameOnlyPlaylists?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IncompleteSegmentBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-incompletesegmentbehavior
         */
        readonly incompleteSegmentBehavior?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IndexNSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-indexnsegments
         */
        readonly indexNSegments?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.InputLossAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-inputlossaction
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IvInManifest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivinmanifest
         */
        readonly ivInManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IvSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivsource
         */
        readonly ivSource?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeepSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keepsegments
         */
        readonly keepSegments?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformat
         */
        readonly keyFormat?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyFormatVersions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformatversions
         */
        readonly keyFormatVersions?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyProviderSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyprovidersettings
         */
        readonly keyProviderSettings?: CfnChannel.KeyProviderSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ManifestCompression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestcompression
         */
        readonly manifestCompression?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ManifestDurationFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestdurationformat
         */
        readonly manifestDurationFormat?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.MinSegmentLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-minsegmentlength
         */
        readonly minSegmentLength?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-mode
         */
        readonly mode?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.OutputSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-outputselection
         */
        readonly outputSelection?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ProgramDateTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetime
         */
        readonly programDateTime?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ProgramDateTimePeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetimeperiod
         */
        readonly programDateTimePeriod?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.RedundantManifest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-redundantmanifest
         */
        readonly redundantManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentlength
         */
        readonly segmentLength?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentationMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentationmode
         */
        readonly segmentationMode?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentsPerSubdirectory`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentspersubdirectory
         */
        readonly segmentsPerSubdirectory?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.StreamInfResolution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-streaminfresolution
         */
        readonly streamInfResolution?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimedMetadataId3Frame`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3frame
         */
        readonly timedMetadataId3Frame?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimedMetadataId3Period`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3period
         */
        readonly timedMetadataId3Period?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimestampDeltaMilliseconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timestampdeltamilliseconds
         */
        readonly timestampDeltaMilliseconds?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TsFileMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-tsfilemode
         */
        readonly tsFileMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html
     */
    interface HlsInputSettingsProperty {
        /**
         * `CfnChannel.HlsInputSettingsProperty.Bandwidth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-bandwidth
         */
        readonly bandwidth?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.BufferSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-buffersegments
         */
        readonly bufferSegments?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.Retries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retries
         */
        readonly retries?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.RetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retryinterval
         */
        readonly retryInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html
     */
    interface HlsMediaStoreSettingsProperty {
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.FilecacheDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-filecacheduration
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.MediaStoreStorageClass`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-mediastorestorageclass
         */
        readonly mediaStoreStorageClass?: string;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-numretries
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-restartdelay
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html
     */
    interface HlsOutputSettingsProperty {
        /**
         * `CfnChannel.HlsOutputSettingsProperty.H265PackagingType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-h265packagingtype
         */
        readonly h265PackagingType?: string;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.HlsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-hlssettings
         */
        readonly hlsSettings?: CfnChannel.HlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.NameModifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-namemodifier
         */
        readonly nameModifier?: string;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.SegmentModifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-segmentmodifier
         */
        readonly segmentModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlss3settings.html
     */
    interface HlsS3SettingsProperty {
        /**
         * `CfnChannel.HlsS3SettingsProperty.CannedAcl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlss3settings.html#cfn-medialive-channel-hlss3settings-cannedacl
         */
        readonly cannedAcl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html
     */
    interface HlsSettingsProperty {
        /**
         * `CfnChannel.HlsSettingsProperty.AudioOnlyHlsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-audioonlyhlssettings
         */
        readonly audioOnlyHlsSettings?: CfnChannel.AudioOnlyHlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsSettingsProperty.Fmp4HlsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-fmp4hlssettings
         */
        readonly fmp4HlsSettings?: CfnChannel.Fmp4HlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsSettingsProperty.FrameCaptureHlsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-framecapturehlssettings
         */
        readonly frameCaptureHlsSettings?: CfnChannel.FrameCaptureHlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsSettingsProperty.StandardHlsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-standardhlssettings
         */
        readonly standardHlsSettings?: CfnChannel.StandardHlsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html
     */
    interface HlsWebdavSettingsProperty {
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.FilecacheDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-filecacheduration
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.HttpTransferMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-httptransfermode
         */
        readonly httpTransferMode?: string;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-numretries
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-restartdelay
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-htmlmotiongraphicssettings.html
     */
    interface HtmlMotionGraphicsSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html
     */
    interface InputAttachmentProperty {
        /**
         * `CfnChannel.InputAttachmentProperty.AutomaticInputFailoverSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-automaticinputfailoversettings
         */
        readonly automaticInputFailoverSettings?: CfnChannel.AutomaticInputFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputAttachmentProperty.InputAttachmentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputattachmentname
         */
        readonly inputAttachmentName?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputid
         */
        readonly inputId?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputsettings
         */
        readonly inputSettings?: CfnChannel.InputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html
     */
    interface InputChannelLevelProperty {
        /**
         * `CfnChannel.InputChannelLevelProperty.Gain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-gain
         */
        readonly gain?: number;
        /**
         * `CfnChannel.InputChannelLevelProperty.InputChannel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-inputchannel
         */
        readonly inputChannel?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html
     */
    interface InputLocationProperty {
        /**
         * `CfnChannel.InputLocationProperty.PasswordParam`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-passwordparam
         */
        readonly passwordParam?: string;
        /**
         * `CfnChannel.InputLocationProperty.Uri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-uri
         */
        readonly uri?: string;
        /**
         * `CfnChannel.InputLocationProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-username
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html
     */
    interface InputLossBehaviorProperty {
        /**
         * `CfnChannel.InputLossBehaviorProperty.BlackFrameMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-blackframemsec
         */
        readonly blackFrameMsec?: number;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagecolor
         */
        readonly inputLossImageColor?: string;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageSlate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimageslate
         */
        readonly inputLossImageSlate?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagetype
         */
        readonly inputLossImageType?: string;
        /**
         * `CfnChannel.InputLossBehaviorProperty.RepeatFrameMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-repeatframemsec
         */
        readonly repeatFrameMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html
     */
    interface InputLossFailoverSettingsProperty {
        /**
         * `CfnChannel.InputLossFailoverSettingsProperty.InputLossThresholdMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html#cfn-medialive-channel-inputlossfailoversettings-inputlossthresholdmsec
         */
        readonly inputLossThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html
     */
    interface InputSettingsProperty {
        /**
         * `CfnChannel.InputSettingsProperty.AudioSelectors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-audioselectors
         */
        readonly audioSelectors?: Array<CfnChannel.AudioSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.CaptionSelectors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-captionselectors
         */
        readonly captionSelectors?: Array<CfnChannel.CaptionSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.DeblockFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-deblockfilter
         */
        readonly deblockFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.DenoiseFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-denoisefilter
         */
        readonly denoiseFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.FilterStrength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-filterstrength
         */
        readonly filterStrength?: number;
        /**
         * `CfnChannel.InputSettingsProperty.InputFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-inputfilter
         */
        readonly inputFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.NetworkInputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-networkinputsettings
         */
        readonly networkInputSettings?: CfnChannel.NetworkInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.Smpte2038DataPreference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-smpte2038datapreference
         */
        readonly smpte2038DataPreference?: string;
        /**
         * `CfnChannel.InputSettingsProperty.SourceEndBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-sourceendbehavior
         */
        readonly sourceEndBehavior?: string;
        /**
         * `CfnChannel.InputSettingsProperty.VideoSelector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-videoselector
         */
        readonly videoSelector?: CfnChannel.VideoSelectorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html
     */
    interface InputSpecificationProperty {
        /**
         * `CfnChannel.InputSpecificationProperty.Codec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-codec
         */
        readonly codec?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.MaximumBitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-maximumbitrate
         */
        readonly maximumBitrate?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.Resolution`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-resolution
         */
        readonly resolution?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html
     */
    interface KeyProviderSettingsProperty {
        /**
         * `CfnChannel.KeyProviderSettingsProperty.StaticKeySettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html#cfn-medialive-channel-keyprovidersettings-statickeysettings
         */
        readonly staticKeySettings?: CfnChannel.StaticKeySettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html
     */
    interface M2tsSettingsProperty {
        /**
         * `CfnChannel.M2tsSettingsProperty.AbsentInputAudioBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-absentinputaudiobehavior
         */
        readonly absentInputAudioBehavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Arib`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-arib
         */
        readonly arib?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AribCaptionsPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspid
         */
        readonly aribCaptionsPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AribCaptionsPidControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspidcontrol
         */
        readonly aribCaptionsPidControl?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioBufferModel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiobuffermodel
         */
        readonly audioBufferModel?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioFramesPerPes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audioframesperpes
         */
        readonly audioFramesPerPes?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioPids`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiopids
         */
        readonly audioPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioStreamType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiostreamtype
         */
        readonly audioStreamType?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.BufferModel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-buffermodel
         */
        readonly bufferModel?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.CcDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ccdescriptor
         */
        readonly ccDescriptor?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbNitSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbnitsettings
         */
        readonly dvbNitSettings?: CfnChannel.DvbNitSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbSdtSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsdtsettings
         */
        readonly dvbSdtSettings?: CfnChannel.DvbSdtSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbSubPids`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsubpids
         */
        readonly dvbSubPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbTdtSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbtdtsettings
         */
        readonly dvbTdtSettings?: CfnChannel.DvbTdtSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbTeletextPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbteletextpid
         */
        readonly dvbTeletextPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Ebif`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebif
         */
        readonly ebif?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpAudioInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpaudiointerval
         */
        readonly ebpAudioInterval?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpLookaheadMs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebplookaheadms
         */
        readonly ebpLookaheadMs?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpPlacement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpplacement
         */
        readonly ebpPlacement?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EcmPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ecmpid
         */
        readonly ecmPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EsRateInPes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-esrateinpes
         */
        readonly esRateInPes?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EtvPlatformPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvplatformpid
         */
        readonly etvPlatformPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EtvSignalPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvsignalpid
         */
        readonly etvSignalPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.FragmentTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-fragmenttime
         */
        readonly fragmentTime?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.Klv`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klv
         */
        readonly klv?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.KlvDataPids`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klvdatapids
         */
        readonly klvDataPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.NielsenId3Behavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nielsenid3behavior
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.NullPacketBitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nullpacketbitrate
         */
        readonly nullPacketBitrate?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PatInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-patinterval
         */
        readonly patInterval?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrcontrol
         */
        readonly pcrControl?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrPeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrperiod
         */
        readonly pcrPeriod?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrpid
         */
        readonly pcrPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.PmtInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtinterval
         */
        readonly pmtInterval?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PmtPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtpid
         */
        readonly pmtPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.ProgramNum`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-programnum
         */
        readonly programNum?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.RateMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ratemode
         */
        readonly rateMode?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte27Pids`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte27pids
         */
        readonly scte27Pids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte35Control`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35control
         */
        readonly scte35Control?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte35Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35pid
         */
        readonly scte35Pid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationmarkers
         */
        readonly segmentationMarkers?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationStyle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationstyle
         */
        readonly segmentationStyle?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationtime
         */
        readonly segmentationTime?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.TimedMetadataBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatabehavior
         */
        readonly timedMetadataBehavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.TimedMetadataPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatapid
         */
        readonly timedMetadataPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.TransportStreamId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-transportstreamid
         */
        readonly transportStreamId?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.VideoPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-videopid
         */
        readonly videoPid?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html
     */
    interface M3u8SettingsProperty {
        /**
         * `CfnChannel.M3u8SettingsProperty.AudioFramesPerPes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audioframesperpes
         */
        readonly audioFramesPerPes?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.AudioPids`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audiopids
         */
        readonly audioPids?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.EcmPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-ecmpid
         */
        readonly ecmPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.NielsenId3Behavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-nielsenid3behavior
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PatInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-patinterval
         */
        readonly patInterval?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrcontrol
         */
        readonly pcrControl?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrPeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrperiod
         */
        readonly pcrPeriod?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrpid
         */
        readonly pcrPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PmtInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtinterval
         */
        readonly pmtInterval?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PmtPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtpid
         */
        readonly pmtPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.ProgramNum`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-programnum
         */
        readonly programNum?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.Scte35Behavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35behavior
         */
        readonly scte35Behavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.Scte35Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35pid
         */
        readonly scte35Pid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TimedMetadataBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatabehavior
         */
        readonly timedMetadataBehavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TimedMetadataPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatapid
         */
        readonly timedMetadataPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TransportStreamId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-transportstreamid
         */
        readonly transportStreamId?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.VideoPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-videopid
         */
        readonly videoPid?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html
     */
    interface MediaPackageGroupSettingsProperty {
        /**
         * `CfnChannel.MediaPackageGroupSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html#cfn-medialive-channel-mediapackagegroupsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html
     */
    interface MediaPackageOutputDestinationSettingsProperty {
        /**
         * `CfnChannel.MediaPackageOutputDestinationSettingsProperty.ChannelId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html#cfn-medialive-channel-mediapackageoutputdestinationsettings-channelid
         */
        readonly channelId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputsettings.html
     */
    interface MediaPackageOutputSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html
     */
    interface MotionGraphicsConfigurationProperty {
        /**
         * `CfnChannel.MotionGraphicsConfigurationProperty.MotionGraphicsInsertion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html#cfn-medialive-channel-motiongraphicsconfiguration-motiongraphicsinsertion
         */
        readonly motionGraphicsInsertion?: string;
        /**
         * `CfnChannel.MotionGraphicsConfigurationProperty.MotionGraphicsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html#cfn-medialive-channel-motiongraphicsconfiguration-motiongraphicssettings
         */
        readonly motionGraphicsSettings?: CfnChannel.MotionGraphicsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicssettings.html
     */
    interface MotionGraphicsSettingsProperty {
        /**
         * `CfnChannel.MotionGraphicsSettingsProperty.HtmlMotionGraphicsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicssettings.html#cfn-medialive-channel-motiongraphicssettings-htmlmotiongraphicssettings
         */
        readonly htmlMotionGraphicsSettings?: CfnChannel.HtmlMotionGraphicsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html
     */
    interface Mp2SettingsProperty {
        /**
         * `CfnChannel.Mp2SettingsProperty.Bitrate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-bitrate
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Mp2SettingsProperty.CodingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-codingmode
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Mp2SettingsProperty.SampleRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-samplerate
         */
        readonly sampleRate?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html
     */
    interface Mpeg2FilterSettingsProperty {
        /**
         * `CfnChannel.Mpeg2FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html#cfn-medialive-channel-mpeg2filtersettings-temporalfiltersettings
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html
     */
    interface Mpeg2SettingsProperty {
        /**
         * `CfnChannel.Mpeg2SettingsProperty.AdaptiveQuantization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-adaptivequantization
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.AfdSignaling`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-afdsignaling
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ColorMetadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colormetadata
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ColorSpace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colorspace
         */
        readonly colorSpace?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.DisplayAspectRatio`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-displayaspectratio
         */
        readonly displayAspectRatio?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FilterSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-filtersettings
         */
        readonly filterSettings?: CfnChannel.Mpeg2FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FixedAfd`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-fixedafd
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FramerateDenominator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratedenominator
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FramerateNumerator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratenumerator
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopClosedCadence`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopclosedcadence
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopNumBFrames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopnumbframes
         */
        readonly gopNumBFrames?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsize
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopSizeUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsizeunits
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ScanType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-scantype
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.SubgopLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-subgoplength
         */
        readonly subgopLength?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.TimecodeInsertion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-timecodeinsertion
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html
     */
    interface MsSmoothGroupSettingsProperty {
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.AcquisitionPointId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-acquisitionpointid
         */
        readonly acquisitionPointId?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.AudioOnlyTimecodeControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-audioonlytimecodecontrol
         */
        readonly audioOnlyTimecodeControl?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.CertificateMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-certificatemode
         */
        readonly certificateMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventid
         */
        readonly eventId?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventIdMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventidmode
         */
        readonly eventIdMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventStopBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventstopbehavior
         */
        readonly eventStopBehavior?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.FilecacheDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-filecacheduration
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.FragmentLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-fragmentlength
         */
        readonly fragmentLength?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.InputLossAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-inputlossaction
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-numretries
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-restartdelay
         */
        readonly restartDelay?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SegmentationMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-segmentationmode
         */
        readonly segmentationMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SendDelayMs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-senddelayms
         */
        readonly sendDelayMs?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SparseTrackType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-sparsetracktype
         */
        readonly sparseTrackType?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.StreamManifestBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-streammanifestbehavior
         */
        readonly streamManifestBehavior?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.TimestampOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffset
         */
        readonly timestampOffset?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.TimestampOffsetMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffsetmode
         */
        readonly timestampOffsetMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html
     */
    interface MsSmoothOutputSettingsProperty {
        /**
         * `CfnChannel.MsSmoothOutputSettingsProperty.H265PackagingType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-h265packagingtype
         */
        readonly h265PackagingType?: string;
        /**
         * `CfnChannel.MsSmoothOutputSettingsProperty.NameModifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-namemodifier
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexgroupsettings.html
     */
    interface MultiplexGroupSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html
     */
    interface MultiplexOutputSettingsProperty {
        /**
         * `CfnChannel.MultiplexOutputSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html#cfn-medialive-channel-multiplexoutputsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html
     */
    interface MultiplexProgramChannelDestinationSettingsProperty {
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.MultiplexId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-multiplexid
         */
        readonly multiplexId?: string;
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.ProgramName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-programname
         */
        readonly programName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html
     */
    interface NetworkInputSettingsProperty {
        /**
         * `CfnChannel.NetworkInputSettingsProperty.HlsInputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-hlsinputsettings
         */
        readonly hlsInputSettings?: CfnChannel.HlsInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.NetworkInputSettingsProperty.ServerValidation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-servervalidation
         */
        readonly serverValidation?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html
     */
    interface NielsenConfigurationProperty {
        /**
         * `CfnChannel.NielsenConfigurationProperty.DistributorId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-distributorid
         */
        readonly distributorId?: string;
        /**
         * `CfnChannel.NielsenConfigurationProperty.NielsenPcmToId3Tagging`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-nielsenpcmtoid3tagging
         */
        readonly nielsenPcmToId3Tagging?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html
     */
    interface OutputProperty {
        /**
         * `CfnChannel.OutputProperty.AudioDescriptionNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-audiodescriptionnames
         */
        readonly audioDescriptionNames?: string[];
        /**
         * `CfnChannel.OutputProperty.CaptionDescriptionNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-captiondescriptionnames
         */
        readonly captionDescriptionNames?: string[];
        /**
         * `CfnChannel.OutputProperty.OutputName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-outputname
         */
        readonly outputName?: string;
        /**
         * `CfnChannel.OutputProperty.OutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-outputsettings
         */
        readonly outputSettings?: CfnChannel.OutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputProperty.VideoDescriptionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-videodescriptionname
         */
        readonly videoDescriptionName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html
     */
    interface OutputDestinationProperty {
        /**
         * `CfnChannel.OutputDestinationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-id
         */
        readonly id?: string;
        /**
         * `CfnChannel.OutputDestinationProperty.MediaPackageSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-mediapackagesettings
         */
        readonly mediaPackageSettings?: Array<CfnChannel.MediaPackageOutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.MultiplexSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-multiplexsettings
         */
        readonly multiplexSettings?: CfnChannel.MultiplexProgramChannelDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-settings
         */
        readonly settings?: Array<CfnChannel.OutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html
     */
    interface OutputDestinationSettingsProperty {
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.PasswordParam`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-passwordparam
         */
        readonly passwordParam?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.StreamName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-streamname
         */
        readonly streamName?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-url
         */
        readonly url?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-username
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html
     */
    interface OutputGroupProperty {
        /**
         * `CfnChannel.OutputGroupProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.OutputGroupProperty.OutputGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputgroupsettings
         */
        readonly outputGroupSettings?: CfnChannel.OutputGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupProperty.Outputs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputs
         */
        readonly outputs?: Array<CfnChannel.OutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html
     */
    interface OutputGroupSettingsProperty {
        /**
         * `CfnChannel.OutputGroupSettingsProperty.ArchiveGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-archivegroupsettings
         */
        readonly archiveGroupSettings?: CfnChannel.ArchiveGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.FrameCaptureGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-framecapturegroupsettings
         */
        readonly frameCaptureGroupSettings?: CfnChannel.FrameCaptureGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.HlsGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-hlsgroupsettings
         */
        readonly hlsGroupSettings?: CfnChannel.HlsGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MediaPackageGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-mediapackagegroupsettings
         */
        readonly mediaPackageGroupSettings?: CfnChannel.MediaPackageGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MsSmoothGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-mssmoothgroupsettings
         */
        readonly msSmoothGroupSettings?: CfnChannel.MsSmoothGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MultiplexGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-multiplexgroupsettings
         */
        readonly multiplexGroupSettings?: CfnChannel.MultiplexGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.RtmpGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-rtmpgroupsettings
         */
        readonly rtmpGroupSettings?: CfnChannel.RtmpGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.UdpGroupSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-udpgroupsettings
         */
        readonly udpGroupSettings?: CfnChannel.UdpGroupSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputlocationref.html
     */
    interface OutputLocationRefProperty {
        /**
         * `CfnChannel.OutputLocationRefProperty.DestinationRefId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputlocationref.html#cfn-medialive-channel-outputlocationref-destinationrefid
         */
        readonly destinationRefId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html
     */
    interface OutputSettingsProperty {
        /**
         * `CfnChannel.OutputSettingsProperty.ArchiveOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-archiveoutputsettings
         */
        readonly archiveOutputSettings?: CfnChannel.ArchiveOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.FrameCaptureOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-framecaptureoutputsettings
         */
        readonly frameCaptureOutputSettings?: CfnChannel.FrameCaptureOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.HlsOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-hlsoutputsettings
         */
        readonly hlsOutputSettings?: CfnChannel.HlsOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MediaPackageOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-mediapackageoutputsettings
         */
        readonly mediaPackageOutputSettings?: CfnChannel.MediaPackageOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MsSmoothOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-mssmoothoutputsettings
         */
        readonly msSmoothOutputSettings?: CfnChannel.MsSmoothOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MultiplexOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-multiplexoutputsettings
         */
        readonly multiplexOutputSettings?: CfnChannel.MultiplexOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.RtmpOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-rtmpoutputsettings
         */
        readonly rtmpOutputSettings?: CfnChannel.RtmpOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.UdpOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-udpoutputsettings
         */
        readonly udpOutputSettings?: CfnChannel.UdpOutputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-passthroughsettings.html
     */
    interface PassThroughSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rawsettings.html
     */
    interface RawSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rec601settings.html
     */
    interface Rec601SettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rec709settings.html
     */
    interface Rec709SettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html
     */
    interface RemixSettingsProperty {
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelmappings
         */
        readonly channelMappings?: Array<CfnChannel.AudioChannelMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelsIn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelsin
         */
        readonly channelsIn?: number;
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelsOut`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelsout
         */
        readonly channelsOut?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpcaptioninfodestinationsettings.html
     */
    interface RtmpCaptionInfoDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html
     */
    interface RtmpGroupSettingsProperty {
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.AdMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-admarkers
         */
        readonly adMarkers?: string[];
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.AuthenticationScheme`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-authenticationscheme
         */
        readonly authenticationScheme?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CacheFullBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-cachefullbehavior
         */
        readonly cacheFullBehavior?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CacheLength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-cachelength
         */
        readonly cacheLength?: number;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CaptionData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-captiondata
         */
        readonly captionData?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.InputLossAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-inputlossaction
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.RestartDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-restartdelay
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html
     */
    interface RtmpOutputSettingsProperty {
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.CertificateMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-certificatemode
         */
        readonly certificateMode?: string;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.ConnectionRetryInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-connectionretryinterval
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.NumRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-numretries
         */
        readonly numRetries?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20plusembeddeddestinationsettings.html
     */
    interface Scte20PlusEmbeddedDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html
     */
    interface Scte20SourceSettingsProperty {
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Convert608To708`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-convert608to708
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Source608ChannelNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-source608channelnumber
         */
        readonly source608ChannelNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27destinationsettings.html
     */
    interface Scte27DestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html
     */
    interface Scte27SourceSettingsProperty {
        /**
         * `CfnChannel.Scte27SourceSettingsProperty.Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html#cfn-medialive-channel-scte27sourcesettings-pid
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html
     */
    interface Scte35SpliceInsertProperty {
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.AdAvailOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-adavailoffset
         */
        readonly adAvailOffset?: number;
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.NoRegionalBlackoutFlag`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-noregionalblackoutflag
         */
        readonly noRegionalBlackoutFlag?: string;
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.WebDeliveryAllowedFlag`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-webdeliveryallowedflag
         */
        readonly webDeliveryAllowedFlag?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html
     */
    interface Scte35TimeSignalAposProperty {
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.AdAvailOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-adavailoffset
         */
        readonly adAvailOffset?: number;
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.NoRegionalBlackoutFlag`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-noregionalblackoutflag
         */
        readonly noRegionalBlackoutFlag?: string;
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.WebDeliveryAllowedFlag`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-webdeliveryallowedflag
         */
        readonly webDeliveryAllowedFlag?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-smptettdestinationsettings.html
     */
    interface SmpteTtDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html
     */
    interface StandardHlsSettingsProperty {
        /**
         * `CfnChannel.StandardHlsSettingsProperty.AudioRenditionSets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html#cfn-medialive-channel-standardhlssettings-audiorenditionsets
         */
        readonly audioRenditionSets?: string;
        /**
         * `CfnChannel.StandardHlsSettingsProperty.M3u8Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html#cfn-medialive-channel-standardhlssettings-m3u8settings
         */
        readonly m3U8Settings?: CfnChannel.M3u8SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html
     */
    interface StaticKeySettingsProperty {
        /**
         * `CfnChannel.StaticKeySettingsProperty.KeyProviderServer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html#cfn-medialive-channel-statickeysettings-keyproviderserver
         */
        readonly keyProviderServer?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.StaticKeySettingsProperty.StaticKeyValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html#cfn-medialive-channel-statickeysettings-statickeyvalue
         */
        readonly staticKeyValue?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextdestinationsettings.html
     */
    interface TeletextDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html
     */
    interface TeletextSourceSettingsProperty {
        /**
         * `CfnChannel.TeletextSourceSettingsProperty.OutputRectangle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html#cfn-medialive-channel-teletextsourcesettings-outputrectangle
         */
        readonly outputRectangle?: CfnChannel.CaptionRectangleProperty | cdk.IResolvable;
        /**
         * `CfnChannel.TeletextSourceSettingsProperty.PageNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html#cfn-medialive-channel-teletextsourcesettings-pagenumber
         */
        readonly pageNumber?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html
     */
    interface TemporalFilterSettingsProperty {
        /**
         * `CfnChannel.TemporalFilterSettingsProperty.PostFilterSharpening`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html#cfn-medialive-channel-temporalfiltersettings-postfiltersharpening
         */
        readonly postFilterSharpening?: string;
        /**
         * `CfnChannel.TemporalFilterSettingsProperty.Strength`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html#cfn-medialive-channel-temporalfiltersettings-strength
         */
        readonly strength?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html
     */
    interface TimecodeConfigProperty {
        /**
         * `CfnChannel.TimecodeConfigProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html#cfn-medialive-channel-timecodeconfig-source
         */
        readonly source?: string;
        /**
         * `CfnChannel.TimecodeConfigProperty.SyncThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html#cfn-medialive-channel-timecodeconfig-syncthreshold
         */
        readonly syncThreshold?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ttmldestinationsettings.html
     */
    interface TtmlDestinationSettingsProperty {
        /**
         * `CfnChannel.TtmlDestinationSettingsProperty.StyleControl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ttmldestinationsettings.html#cfn-medialive-channel-ttmldestinationsettings-stylecontrol
         */
        readonly styleControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpcontainersettings.html
     */
    interface UdpContainerSettingsProperty {
        /**
         * `CfnChannel.UdpContainerSettingsProperty.M2tsSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpcontainersettings.html#cfn-medialive-channel-udpcontainersettings-m2tssettings
         */
        readonly m2TsSettings?: CfnChannel.M2tsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html
     */
    interface UdpGroupSettingsProperty {
        /**
         * `CfnChannel.UdpGroupSettingsProperty.InputLossAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-inputlossaction
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.UdpGroupSettingsProperty.TimedMetadataId3Frame`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-timedmetadataid3frame
         */
        readonly timedMetadataId3Frame?: string;
        /**
         * `CfnChannel.UdpGroupSettingsProperty.TimedMetadataId3Period`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-timedmetadataid3period
         */
        readonly timedMetadataId3Period?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html
     */
    interface UdpOutputSettingsProperty {
        /**
         * `CfnChannel.UdpOutputSettingsProperty.BufferMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-buffermsec
         */
        readonly bufferMsec?: number;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.ContainerSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-containersettings
         */
        readonly containerSettings?: CfnChannel.UdpContainerSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-destination
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.FecOutputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-fecoutputsettings
         */
        readonly fecOutputSettings?: CfnChannel.FecOutputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html
     */
    interface VideoBlackFailoverSettingsProperty {
        /**
         * `CfnChannel.VideoBlackFailoverSettingsProperty.BlackDetectThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html#cfn-medialive-channel-videoblackfailoversettings-blackdetectthreshold
         */
        readonly blackDetectThreshold?: number;
        /**
         * `CfnChannel.VideoBlackFailoverSettingsProperty.VideoBlackThresholdMsec`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html#cfn-medialive-channel-videoblackfailoversettings-videoblackthresholdmsec
         */
        readonly videoBlackThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html
     */
    interface VideoCodecSettingsProperty {
        /**
         * `CfnChannel.VideoCodecSettingsProperty.FrameCaptureSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-framecapturesettings
         */
        readonly frameCaptureSettings?: CfnChannel.FrameCaptureSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.H264Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-h264settings
         */
        readonly h264Settings?: CfnChannel.H264SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.H265Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-h265settings
         */
        readonly h265Settings?: CfnChannel.H265SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.Mpeg2Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-mpeg2settings
         */
        readonly mpeg2Settings?: CfnChannel.Mpeg2SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html
     */
    interface VideoDescriptionProperty {
        /**
         * `CfnChannel.VideoDescriptionProperty.CodecSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-codecsettings
         */
        readonly codecSettings?: CfnChannel.VideoCodecSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoDescriptionProperty.Height`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-height
         */
        readonly height?: number;
        /**
         * `CfnChannel.VideoDescriptionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.RespondToAfd`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-respondtoafd
         */
        readonly respondToAfd?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.ScalingBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-scalingbehavior
         */
        readonly scalingBehavior?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.Sharpness`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-sharpness
         */
        readonly sharpness?: number;
        /**
         * `CfnChannel.VideoDescriptionProperty.Width`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-width
         */
        readonly width?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html
     */
    interface VideoSelectorProperty {
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspace
         */
        readonly colorSpace?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpaceSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspacesettings
         */
        readonly colorSpaceSettings?: CfnChannel.VideoSelectorColorSpaceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpaceUsage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspaceusage
         */
        readonly colorSpaceUsage?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.SelectorSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.VideoSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorcolorspacesettings.html
     */
    interface VideoSelectorColorSpaceSettingsProperty {
        /**
         * `CfnChannel.VideoSelectorColorSpaceSettingsProperty.Hdr10Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorcolorspacesettings.html#cfn-medialive-channel-videoselectorcolorspacesettings-hdr10settings
         */
        readonly hdr10Settings?: CfnChannel.Hdr10SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html
     */
    interface VideoSelectorPidProperty {
        /**
         * `CfnChannel.VideoSelectorPidProperty.Pid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html#cfn-medialive-channel-videoselectorpid-pid
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html
     */
    interface VideoSelectorProgramIdProperty {
        /**
         * `CfnChannel.VideoSelectorProgramIdProperty.ProgramId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html#cfn-medialive-channel-videoselectorprogramid-programid
         */
        readonly programId?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html
     */
    interface VideoSelectorSettingsProperty {
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorPid`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorpid
         */
        readonly videoSelectorPid?: CfnChannel.VideoSelectorPidProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorProgramId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorprogramid
         */
        readonly videoSelectorProgramId?: CfnChannel.VideoSelectorProgramIdProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-vpcoutputsettings.html
     */
    interface VpcOutputSettingsProperty {
        /**
         * `CfnChannel.VpcOutputSettingsProperty.PublicAddressAllocationIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-vpcoutputsettings.html#cfn-medialive-channel-vpcoutputsettings-publicaddressallocationids
         */
        readonly publicAddressAllocationIds?: string[];
        /**
         * `CfnChannel.VpcOutputSettingsProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-vpcoutputsettings.html#cfn-medialive-channel-vpcoutputsettings-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnChannel.VpcOutputSettingsProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-vpcoutputsettings.html#cfn-medialive-channel-vpcoutputsettings-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html
     */
    interface WavSettingsProperty {
        /**
         * `CfnChannel.WavSettingsProperty.BitDepth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-bitdepth
         */
        readonly bitDepth?: number;
        /**
         * `CfnChannel.WavSettingsProperty.CodingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-codingmode
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.WavSettingsProperty.SampleRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-samplerate
         */
        readonly sampleRate?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-webvttdestinationsettings.html
     */
    interface WebvttDestinationSettingsProperty {
    }
}
/**
 * Properties for defining a `AWS::MediaLive::Input`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export interface CfnInputProps {
    /**
     * `AWS::MediaLive::Input.Destinations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     */
    readonly destinations?: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.InputDevices`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices
     */
    readonly inputDevices?: Array<CfnInput.InputDeviceSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     */
    readonly inputSecurityGroups?: string[];
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     */
    readonly mediaConnectFlows?: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Input.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Input.Sources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     */
    readonly sources?: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::Input.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     */
    readonly type?: string;
    /**
     * `AWS::MediaLive::Input.Vpc`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     */
    readonly vpc?: CfnInput.InputVpcRequestProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Input";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInput;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Destinations
     */
    readonly attrDestinations: string[];
    /**
     * @external
     * @cloudformationAttribute Sources
     */
    readonly attrSources: string[];
    /**
     * `AWS::MediaLive::Input.Destinations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     */
    destinations: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.InputDevices`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices
     */
    inputDevices: Array<CfnInput.InputDeviceSettingsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     */
    inputSecurityGroups: string[] | undefined;
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     */
    mediaConnectFlows: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Input.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Input.Sources`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     */
    sources: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::Input.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     */
    type: string | undefined;
    /**
     * `AWS::MediaLive::Input.Vpc`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     */
    vpc: CfnInput.InputVpcRequestProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::Input`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html
     */
    interface InputDestinationRequestProperty {
        /**
         * `CfnInput.InputDestinationRequestProperty.StreamName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html#cfn-medialive-input-inputdestinationrequest-streamname
         */
        readonly streamName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicerequest.html
     */
    interface InputDeviceRequestProperty {
        /**
         * `CfnInput.InputDeviceRequestProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicerequest.html#cfn-medialive-input-inputdevicerequest-id
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicesettings.html
     */
    interface InputDeviceSettingsProperty {
        /**
         * `CfnInput.InputDeviceSettingsProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicesettings.html#cfn-medialive-input-inputdevicesettings-id
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html
     */
    interface InputSourceRequestProperty {
        /**
         * `CfnInput.InputSourceRequestProperty.PasswordParam`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-passwordparam
         */
        readonly passwordParam?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-url
         */
        readonly url?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-username
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html
     */
    interface InputVpcRequestProperty {
        /**
         * `CfnInput.InputVpcRequestProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnInput.InputVpcRequestProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html
     */
    interface MediaConnectFlowRequestProperty {
        /**
         * `CfnInput.MediaConnectFlowRequestProperty.FlowArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html#cfn-medialive-input-mediaconnectflowrequest-flowarn
         */
        readonly flowArn?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaLive::InputSecurityGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
export interface CfnInputSecurityGroupProps {
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     */
    readonly whitelistRules?: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
export declare class CfnInputSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::InputSecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInputSecurityGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     */
    whitelistRules: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::InputSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputSecurityGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
export declare namespace CfnInputSecurityGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html
     */
    interface InputWhitelistRuleCidrProperty {
        /**
         * `CfnInputSecurityGroup.InputWhitelistRuleCidrProperty.Cidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html#cfn-medialive-inputsecuritygroup-inputwhitelistrulecidr-cidr
         */
        readonly cidr?: string;
    }
}
