import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export interface CfnMemberProps {
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    readonly memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    readonly invitationId?: string;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    readonly networkConfiguration?: CfnMember.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    readonly networkId?: string;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare class CfnMember extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Member";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMember;
    /**
     * @external
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    invitationId: string | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    networkConfiguration: CfnMember.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    networkId: string | undefined;
    /**
     * Create a new `AWS::ManagedBlockchain::Member`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMemberProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html
     */
    interface ApprovalThresholdPolicyProperty {
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours
         */
        readonly proposalDurationInHours?: number;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator
         */
        readonly thresholdComparator?: string;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage
         */
        readonly thresholdPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html
     */
    interface MemberConfigurationProperty {
        /**
         * `CfnMember.MemberConfigurationProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description
         */
        readonly description?: string;
        /**
         * `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration
         */
        readonly memberFrameworkConfiguration?: CfnMember.MemberFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.MemberConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html
     */
    interface MemberFabricConfigurationProperty {
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminPassword`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword
         */
        readonly adminPassword: string;
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminUsername`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername
         */
        readonly adminUsername: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html
     */
    interface MemberFrameworkConfigurationProperty {
        /**
         * `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration
         */
        readonly memberFabricConfiguration?: CfnMember.MemberFabricConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnMember.NetworkConfigurationProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description
         */
        readonly description?: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Framework`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework
         */
        readonly framework: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.FrameworkVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion
         */
        readonly frameworkVersion: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name
         */
        readonly name: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration
         */
        readonly networkFrameworkConfiguration?: CfnMember.NetworkFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.NetworkConfigurationProperty.VotingPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy
         */
        readonly votingPolicy: CfnMember.VotingPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html
     */
    interface NetworkFabricConfigurationProperty {
        /**
         * `CfnMember.NetworkFabricConfigurationProperty.Edition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition
         */
        readonly edition: string;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html
     */
    interface NetworkFrameworkConfigurationProperty {
        /**
         * `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration
         */
        readonly networkFabricConfiguration?: CfnMember.NetworkFabricConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare namespace CfnMember {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html
     */
    interface VotingPolicyProperty {
        /**
         * `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy
         */
        readonly approvalThresholdPolicy?: CfnMember.ApprovalThresholdPolicyProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ManagedBlockchain::Node`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
export interface CfnNodeProps {
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    readonly networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    readonly nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    readonly memberId?: string;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Node
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
export declare class CfnNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Node";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNode;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * @external
     * @cloudformationAttribute NodeId
     */
    readonly attrNodeId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    memberId: string | undefined;
    /**
     * Create a new `AWS::ManagedBlockchain::Node`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNodeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`.
 *
 * @external
 * @cloudformationResource AWS::ManagedBlockchain::Node
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
export declare namespace CfnNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html
     */
    interface NodeConfigurationProperty {
        /**
         * `CfnNode.NodeConfigurationProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-availabilityzone
         */
        readonly availabilityZone: string;
        /**
         * `CfnNode.NodeConfigurationProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-instancetype
         */
        readonly instanceType: string;
    }
}
