"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * (experimental) A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics.
 *
 * @experimental
 */
class MetricFilter extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.metricName = props.metricName;
        this.metricNamespace = props.metricNamespace;
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: (_b = props.metricValue) !== null && _b !== void 0 ? _b : '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
    /**
     * (experimental) Return the given named metric for this Metric Filter.
     *
     * @default avg over 5 minutes
     * @experimental
     */
    metric(props) {
        return new aws_cloudwatch_1.Metric({
            metricName: this.metricName,
            namespace: this.metricNamespace,
            statistic: 'avg',
            ...props,
        }).attachTo(this);
    }
}
exports.MetricFilter = MetricFilter;
_a = JSII_RTTI_SYMBOL_1;
MetricFilter[_a] = { fqn: "monocdk.aws_logs.MetricFilter", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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