import { Metric, MetricOptions } from "../../aws-cloudwatch";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { ILogGroup, MetricFilterOptions } from './log-group';
/**
 * (experimental) Properties for a MetricFilter.
 *
 * @experimental
 */
export interface MetricFilterProps extends MetricFilterOptions {
    /**
     * (experimental) The log group to create the filter on.
     *
     * @experimental
     */
    readonly logGroup: ILogGroup;
}
/**
 * (experimental) A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics.
 *
 * @experimental
 */
export declare class MetricFilter extends Resource {
    private readonly metricName;
    private readonly metricNamespace;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: MetricFilterProps);
    /**
     * (experimental) Return the given named metric for this Metric Filter.
     *
     * @default avg over 5 minutes
     * @experimental
     */
    metric(props?: MetricOptions): Metric;
}
