import { IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { ILogGroup } from './log-group';
/**
 * @experimental
 */
export interface ILogStream extends IResource {
    /**
     * (experimental) The name of this log stream.
     *
     * @experimental
     * @attribute true
     */
    readonly logStreamName: string;
}
/**
 * (experimental) Properties for a LogStream.
 *
 * @experimental
 */
export interface LogStreamProps {
    /**
     * (experimental) The log group to create a log stream for.
     *
     * @experimental
     */
    readonly logGroup: ILogGroup;
    /**
     * (experimental) The name of the log stream to create.
     *
     * The name must be unique within the log group.
     *
     * @default Automatically generated
     * @experimental
     */
    readonly logStreamName?: string;
    /**
     * (experimental) Determine what happens when the log stream resource is removed from the app.
     *
     * Normally you want to retain the log stream so you can diagnose issues from
     * logs even after a deployment that no longer includes the log stream.
     *
     * The date-based retention policy of your log group will age out the logs
     * after a certain time.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Define a Log Stream in a Log Group.
 *
 * @experimental
 */
export declare class LogStream extends Resource implements ILogStream {
    /**
     * (experimental) Import an existing LogGroup.
     *
     * @experimental
     */
    static fromLogStreamName(scope: Construct, id: string, logStreamName: string): ILogStream;
    /**
     * (experimental) The name of this log stream.
     *
     * @experimental
     */
    readonly logStreamName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LogStreamProps);
}
