import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { RetentionDays } from './log-group';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Construction properties for a LogRetention.
 *
 * @experimental
 */
export interface LogRetentionProps {
    /**
     * (experimental) The log group name.
     *
     * @experimental
     */
    readonly logGroupName: string;
    /**
     * (experimental) The region where the log group should be created.
     *
     * @default - same region as the stack
     * @experimental
     */
    readonly logGroupRegion?: string;
    /**
     * (experimental) The number of days log events are kept in CloudWatch Logs.
     *
     * @experimental
     */
    readonly retention: RetentionDays;
    /**
     * (experimental) The IAM role for the Lambda function associated with the custom resource.
     *
     * @default - A new role is created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Retry options for all AWS API calls.
     *
     * @default - AWS SDK default retry options
     * @experimental
     */
    readonly logRetentionRetryOptions?: LogRetentionRetryOptions;
}
/**
 * (experimental) Retry options for all AWS API calls.
 *
 * @experimental
 */
export interface LogRetentionRetryOptions {
    /**
     * (experimental) The maximum amount of retries.
     *
     * @default 3 (AWS SDK default)
     * @experimental
     */
    readonly maxRetries?: number;
    /**
     * (experimental) The base duration to use in the exponential backoff for operation retries.
     *
     * @default Duration.millis(100) (AWS SDK default)
     * @experimental
     */
    readonly base?: cdk.Duration;
}
/**
 * (experimental) Creates a custom resource to control the retention policy of a CloudWatch Logs log group.
 *
 * The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 * Log group can be created in the region that is different from stack region by
 * specifying `logGroupRegion`
 *
 * @experimental
 */
export declare class LogRetention extends CoreConstruct {
    /**
     * (experimental) The ARN of the LogGroup.
     *
     * @experimental
     */
    readonly logGroupArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LogRetentionProps);
    /**
     * Helper method to ensure that only one instance of LogRetentionFunction resources are in the stack mimicking the
     * behaviour of @aws-cdk/aws-lambda's SingletonFunction to prevent circular dependencies
     */
    private ensureSingletonLogRetentionFunction;
}
