import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { LogStream } from './log-stream';
import { MetricFilter } from './metric-filter';
import { IFilterPattern } from './pattern';
import { ILogSubscriptionDestination, SubscriptionFilter } from './subscription-filter';
/**
 * @experimental
 */
export interface ILogGroup extends IResource {
    /**
     * (experimental) The ARN of this log group, with ':*' appended.
     *
     * @experimental
     * @attribute true
     */
    readonly logGroupArn: string;
    /**
     * (experimental) The name of this log group.
     *
     * @experimental
     * @attribute true
     */
    readonly logGroupName: string;
    /**
     * (experimental) Create a new Log Stream for this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the LogStream.
     * @experimental
     */
    addStream(id: string, props?: StreamOptions): LogStream;
    /**
     * (experimental) Create a new Subscription Filter on this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the SubscriptionFilter.
     * @experimental
     */
    addSubscriptionFilter(id: string, props: SubscriptionFilterOptions): SubscriptionFilter;
    /**
     * (experimental) Create a new Metric Filter on this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the MetricFilter.
     * @experimental
     */
    addMetricFilter(id: string, props: MetricFilterOptions): MetricFilter;
    /**
     * (experimental) Extract a metric from structured log events in the LogGroup.
     *
     * Creates a MetricFilter on this LogGroup that will extract the value
     * of the indicated JSON field in all records where it occurs.
     *
     * The metric will be available in CloudWatch Metrics under the
     * indicated namespace and name.
     *
     * @param jsonField JSON field to extract (example: '$.myfield').
     * @param metricNamespace Namespace to emit the metric under.
     * @param metricName Name to emit the metric under.
     * @returns A Metric object representing the extracted metric
     * @experimental
     */
    extractMetric(jsonField: string, metricNamespace: string, metricName: string): cloudwatch.Metric;
    /**
     * (experimental) Give permissions to write to create and write to streams in this log group.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Give the indicated permissions on this log group and all streams.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * An CloudWatch Log Group
 */
declare abstract class LogGroupBase extends Resource implements ILogGroup {
    /**
     * The ARN of this log group, with ':*' appended
     */
    abstract readonly logGroupArn: string;
    /**
     * The name of this log group
     */
    abstract readonly logGroupName: string;
    /**
     * (experimental) Create a new Log Stream for this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the LogStream.
     * @experimental
     */
    addStream(id: string, props?: StreamOptions): LogStream;
    /**
     * (experimental) Create a new Subscription Filter on this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the SubscriptionFilter.
     * @experimental
     */
    addSubscriptionFilter(id: string, props: SubscriptionFilterOptions): SubscriptionFilter;
    /**
     * (experimental) Create a new Metric Filter on this Log Group.
     *
     * @param id Unique identifier for the construct in its parent.
     * @param props Properties for creating the MetricFilter.
     * @experimental
     */
    addMetricFilter(id: string, props: MetricFilterOptions): MetricFilter;
    /**
     * (experimental) Extract a metric from structured log events in the LogGroup.
     *
     * Creates a MetricFilter on this LogGroup that will extract the value
     * of the indicated JSON field in all records where it occurs.
     *
     * The metric will be available in CloudWatch Metrics under the
     * indicated namespace and name.
     *
     * @param jsonField JSON field to extract (example: '$.myfield').
     * @param metricNamespace Namespace to emit the metric under.
     * @param metricName Name to emit the metric under.
     * @returns A Metric object representing the extracted metric
     * @experimental
     */
    extractMetric(jsonField: string, metricNamespace: string, metricName: string): cloudwatch.Metric;
    /**
     * (experimental) Give permissions to create and write to streams in this log group.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Give the indicated permissions on this log group and all streams.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * (experimental) How long, in days, the log contents will be retained.
 *
 * @experimental
 */
export declare enum RetentionDays {
    /**
     * (experimental) 1 day.
     *
     * @experimental
     */
    ONE_DAY = 1,
    /**
     * (experimental) 3 days.
     *
     * @experimental
     */
    THREE_DAYS = 3,
    /**
     * (experimental) 5 days.
     *
     * @experimental
     */
    FIVE_DAYS = 5,
    /**
     * (experimental) 1 week.
     *
     * @experimental
     */
    ONE_WEEK = 7,
    /**
     * (experimental) 2 weeks.
     *
     * @experimental
     */
    TWO_WEEKS = 14,
    /**
     * (experimental) 1 month.
     *
     * @experimental
     */
    ONE_MONTH = 30,
    /**
     * (experimental) 2 months.
     *
     * @experimental
     */
    TWO_MONTHS = 60,
    /**
     * (experimental) 3 months.
     *
     * @experimental
     */
    THREE_MONTHS = 90,
    /**
     * (experimental) 4 months.
     *
     * @experimental
     */
    FOUR_MONTHS = 120,
    /**
     * (experimental) 5 months.
     *
     * @experimental
     */
    FIVE_MONTHS = 150,
    /**
     * (experimental) 6 months.
     *
     * @experimental
     */
    SIX_MONTHS = 180,
    /**
     * (experimental) 1 year.
     *
     * @experimental
     */
    ONE_YEAR = 365,
    /**
     * (experimental) 13 months.
     *
     * @experimental
     */
    THIRTEEN_MONTHS = 400,
    /**
     * (experimental) 18 months.
     *
     * @experimental
     */
    EIGHTEEN_MONTHS = 545,
    /**
     * (experimental) 2 years.
     *
     * @experimental
     */
    TWO_YEARS = 731,
    /**
     * (experimental) 5 years.
     *
     * @experimental
     */
    FIVE_YEARS = 1827,
    /**
     * (experimental) 10 years.
     *
     * @experimental
     */
    TEN_YEARS = 3653,
    /**
     * (experimental) Retain logs forever.
     *
     * @experimental
     */
    INFINITE = 9999
}
/**
 * (experimental) Properties for a LogGroup.
 *
 * @experimental
 */
export interface LogGroupProps {
    /**
     * (experimental) The KMS Key to encrypt the log group with.
     *
     * @default - log group is encrypted with the default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Name of the log group.
     *
     * @default Automatically generated
     * @experimental
     */
    readonly logGroupName?: string;
    /**
     * (experimental) How long, in days, the log contents will be retained.
     *
     * To retain all logs, set this value to RetentionDays.INFINITE.
     *
     * @default RetentionDays.TWO_YEARS
     * @experimental
     */
    readonly retention?: RetentionDays;
    /**
     * (experimental) Determine the removal policy of this log group.
     *
     * Normally you want to retain the log group so you can diagnose issues
     * from logs even after a deployment that no longer includes the log group.
     * In that case, use the normal date-based retention policy to age out your
     * logs.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Define a CloudWatch Log Group.
 *
 * @experimental
 */
export declare class LogGroup extends LogGroupBase {
    /**
     * (experimental) Import an existing LogGroup given its ARN.
     *
     * @experimental
     */
    static fromLogGroupArn(scope: Construct, id: string, logGroupArn: string): ILogGroup;
    /**
     * (experimental) Import an existing LogGroup given its name.
     *
     * @experimental
     */
    static fromLogGroupName(scope: Construct, id: string, logGroupName: string): ILogGroup;
    /**
     * (experimental) The ARN of this log group.
     *
     * @experimental
     */
    readonly logGroupArn: string;
    /**
     * (experimental) The name of this log group.
     *
     * @experimental
     */
    readonly logGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: LogGroupProps);
}
/**
 * (experimental) Properties for a new LogStream created from a LogGroup.
 *
 * @experimental
 */
export interface StreamOptions {
    /**
     * (experimental) The name of the log stream to create.
     *
     * The name must be unique within the log group.
     *
     * @default Automatically generated
     * @experimental
     */
    readonly logStreamName?: string;
}
/**
 * (experimental) Properties for a new SubscriptionFilter created from a LogGroup.
 *
 * @experimental
 */
export interface SubscriptionFilterOptions {
    /**
     * (experimental) The destination to send the filtered events to.
     *
     * For example, a Kinesis stream or a Lambda function.
     *
     * @experimental
     */
    readonly destination: ILogSubscriptionDestination;
    /**
     * (experimental) Log events matching this pattern will be sent to the destination.
     *
     * @experimental
     */
    readonly filterPattern: IFilterPattern;
}
/**
 * (experimental) Properties for a MetricFilter created from a LogGroup.
 *
 * @experimental
 */
export interface MetricFilterOptions {
    /**
     * (experimental) Pattern to search for log events.
     *
     * @experimental
     */
    readonly filterPattern: IFilterPattern;
    /**
     * (experimental) The namespace of the metric to emit.
     *
     * @experimental
     */
    readonly metricNamespace: string;
    /**
     * (experimental) The name of the metric to emit.
     *
     * @experimental
     */
    readonly metricName: string;
    /**
     * (experimental) The value to emit for the metric.
     *
     * Can either be a literal number (typically "1"), or the name of a field in the structure
     * to take the value from the matched event. If you are using a field value, the field
     * value must have been matched using the pattern.
     *
     * If you want to specify a field from a matched JSON structure, use '$.fieldName',
     * and make sure the field is in the pattern (if only as '$.fieldName = *').
     *
     * If you want to specify a field from a matched space-delimited structure,
     * use '$fieldName'.
     *
     * @default "1"
     * @experimental
     */
    readonly metricValue?: string;
    /**
     * (experimental) The value to emit if the pattern does not match a particular event.
     *
     * @default No metric emitted.
     * @experimental
     */
    readonly defaultValue?: number;
}
export {};
