"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * (experimental) Use a Lamda Function as the destination for a log subscription.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * (experimental) Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @experimental
     */
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal('logs.amazonaws.com'),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope,
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_logs_destinations.LambdaDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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