"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * (experimental) Use a Kinesis stream as the destination for a log subscription.
 *
 * @experimental
 */
class KinesisDestination {
    /**
     * @experimental
     */
    constructor(stream) {
        this.stream = stream;
    }
    /**
     * (experimental) Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @experimental
     */
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
_a = JSII_RTTI_SYMBOL_1;
KinesisDestination[_a] = { fqn: "monocdk.aws_logs_destinations.KinesisDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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