"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatten = exports.flatMap = exports.addAlias = void 0;
const alias_1 = require("./alias");
function addAlias(scope, version, aliasName, options = {}) {
    return new alias_1.Alias(scope, `Alias${aliasName}`, {
        aliasName,
        version,
        ...options,
    });
}
exports.addAlias = addAlias;
/**
 * Map a function over an array and concatenate the results
 */
function flatMap(xs, fn) {
    return flatten(xs.map(fn));
}
exports.flatMap = flatMap;
/**
 * Flatten a list of lists into a list of elements
 */
function flatten(xs) {
    return Array.prototype.concat.apply([], xs);
}
exports.flatten = flatten;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsbUNBQThDO0FBRTlDLFNBQWdCLFFBQVEsQ0FBQyxLQUFnQixFQUFFLE9BQWlCLEVBQUUsU0FBaUIsRUFBRSxVQUF3QixFQUFFO0lBQ3ZHLE9BQU8sSUFBSSxhQUFLLENBQUMsS0FBSyxFQUFFLFFBQVEsU0FBUyxFQUFFLEVBQUU7UUFDekMsU0FBUztRQUNULE9BQU87UUFDUCxHQUFHLE9BQU87S0FDYixDQUFDLENBQUM7QUFDUCxDQUFDO0FBTkQsNEJBTUM7QUFDRDs7R0FFRztBQUNILFNBQWdCLE9BQU8sQ0FBTyxFQUFPLEVBQUUsRUFBOEI7SUFDakUsT0FBTyxPQUFPLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQy9CLENBQUM7QUFGRCwwQkFFQztBQUNEOztHQUVHO0FBQ0gsU0FBZ0IsT0FBTyxDQUFJLEVBQVM7SUFDaEMsT0FBTyxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ2hELENBQUM7QUFGRCwwQkFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQWxpYXMsIEFsaWFzT3B0aW9ucyB9IGZyb20gJy4vYWxpYXMnO1xuaW1wb3J0IHsgSVZlcnNpb24gfSBmcm9tICcuL2xhbWJkYS12ZXJzaW9uJztcbmV4cG9ydCBmdW5jdGlvbiBhZGRBbGlhcyhzY29wZTogQ29uc3RydWN0LCB2ZXJzaW9uOiBJVmVyc2lvbiwgYWxpYXNOYW1lOiBzdHJpbmcsIG9wdGlvbnM6IEFsaWFzT3B0aW9ucyA9IHt9KSB7XG4gICAgcmV0dXJuIG5ldyBBbGlhcyhzY29wZSwgYEFsaWFzJHthbGlhc05hbWV9YCwge1xuICAgICAgICBhbGlhc05hbWUsXG4gICAgICAgIHZlcnNpb24sXG4gICAgICAgIC4uLm9wdGlvbnMsXG4gICAgfSk7XG59XG4vKipcbiAqIE1hcCBhIGZ1bmN0aW9uIG92ZXIgYW4gYXJyYXkgYW5kIGNvbmNhdGVuYXRlIHRoZSByZXN1bHRzXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmbGF0TWFwPFQsIFU+KHhzOiBUW10sIGZuOiAoKHg6IFQsIGk6IG51bWJlcikgPT4gVVtdKSk6IFVbXSB7XG4gICAgcmV0dXJuIGZsYXR0ZW4oeHMubWFwKGZuKSk7XG59XG4vKipcbiAqIEZsYXR0ZW4gYSBsaXN0IG9mIGxpc3RzIGludG8gYSBsaXN0IG9mIGVsZW1lbnRzXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmbGF0dGVuPFQ+KHhzOiBUW11bXSk6IFRbXSB7XG4gICAgcmV0dXJuIEFycmF5LnByb3RvdHlwZS5jb25jYXQuYXBwbHkoW10sIHhzKTtcbn1cbiJdfQ==