import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { FunctionProps } from './function';
import { FunctionBase } from './function-base';
import { Version } from './lambda-version';
import { Permission } from './permission';
/**
 * (experimental) Properties for a newly created singleton Lambda.
 *
 * @experimental
 */
export interface SingletonFunctionProps extends FunctionProps {
    /**
     * (experimental) A unique identifier to identify this lambda.
     *
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     *
     * @experimental
     */
    readonly uuid: string;
    /**
     * (experimental) A descriptive name for the purpose of this Lambda.
     *
     * If the Lambda does not have a physical name, this string will be
     * reflected its generated name. The combination of lambdaPurpose
     * and uuid must be unique.
     *
     * @default SingletonLambda
     * @experimental
     */
    readonly lambdaPurpose?: string;
}
/**
 * (experimental) A Lambda that will only ever be added to a stack once.
 *
 * This construct is a way to guarantee that the lambda function will be guaranteed to be part of the stack,
 * once and only once, irrespective of how many times the construct is declared to be part of the stack.
 * This is guaranteed as long as the `uuid` property and the optional `lambdaPurpose` property stay the same
 * whenever they're declared into the stack.
 *
 * @experimental
 * @resource AWS::Lambda::Function
 */
export declare class SingletonFunction extends FunctionBase {
    /**
     * (experimental) The principal this Lambda Function is running as.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     */
    readonly functionName: string;
    /**
     * (experimental) The ARN fo the function.
     *
     * @experimental
     */
    readonly functionArn: string;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * Undefined if the function was imported without a role.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The construct node where permissions are attached.
     *
     * @experimental
     */
    readonly permissionsNode: cdk.ConstructNode;
    /**
     * (experimental) Whether the addPermission() call adds any permissions.
     *
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     *
     * @experimental
     */
    protected readonly canCreatePermissions: boolean;
    private lambdaFunction;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SingletonFunctionProps);
    /**
     * (experimental) Whether or not this Lambda function was bound to a VPC.
     *
     * If this is is `false`, trying to access the `connections` object will fail.
     *
     * @experimental
     * @inheritdoc true
     */
    get isBoundToVpc(): boolean;
    /**
     * (experimental) Access the Connections object.
     *
     * Will fail if not a VPC-enabled Lambda Function
     *
     * @experimental
     * @inheritdoc true
     */
    get connections(): ec2.Connections;
    /**
     * (experimental) Returns a `lambda.Version` which represents the current version of this singleton Lambda function. A new version will be created every time the function's configuration changes.
     *
     * You can specify options for this version using the `currentVersionOptions`
     * prop when initializing the `lambda.SingletonFunction`.
     *
     * @experimental
     */
    get currentVersion(): Version;
    /**
     * (experimental) Adds a permission to the Lambda resource policy.
     *
     * @experimental
     */
    addPermission(name: string, permission: Permission): void;
    /**
     * (experimental) Using node.addDependency() does not work on this method as the underlying lambda function is modeled as a singleton across the stack. Use this method instead to declare dependencies.
     *
     * @experimental
     */
    addDependency(...up: cdk.IDependable[]): void;
    /**
     * (experimental) The SingletonFunction construct cannot be added as a dependency of another construct using node.addDependency(). Use this method instead to declare this as a dependency of another construct.
     *
     * @experimental
     */
    dependOn(down: cdk.IConstruct): void;
    /** @internal */
    _checkEdgeCompatibility(): void;
    /**
     * Returns the construct tree node that corresponds to the lambda function.
     * @internal
     */
    protected _functionNode(): cdk.ConstructNode;
    private ensureLambda;
}
