import * as appscaling from "../../aws-applicationautoscaling";
import { IConstruct } from "../../core";
/**
 * (experimental) Interface for scalable attributes.
 *
 * @experimental
 */
export interface IScalableFunctionAttribute extends IConstruct {
    /**
     * (experimental) Scale out or in to keep utilization at a given level.
     *
     * The utilization is tracked by the
     * LambdaProvisionedConcurrencyUtilization metric, emitted by lambda. See:
     * https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     *
     * @experimental
     */
    scaleOnUtilization(options: UtilizationScalingOptions): void;
    /**
     * (experimental) Scale out or in based on schedule.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, actions: appscaling.ScalingSchedule): void;
}
/**
 * (experimental) Options for enabling Lambda utilization tracking.
 *
 * @experimental
 */
export interface UtilizationScalingOptions extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) Utilization target for the attribute.
     *
     * For example, .5 indicates that 50 percent of allocated provisioned concurrency is in use.
     *
     * @experimental
     */
    readonly utilizationTarget: number;
}
/**
 * (experimental) Properties for enabling Lambda autoscaling.
 *
 * @experimental
 */
export interface AutoScalingOptions {
    /**
     * (experimental) Minimum capacity to scale to.
     *
     * @default 1
     * @experimental
     */
    readonly minCapacity?: number;
    /**
     * (experimental) Maximum capacity to scale to.
     *
     * @experimental
     */
    readonly maxCapacity: number;
}
