"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableFunctionAttribute = void 0;
const appscaling = require("../../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * A scalable lambda alias attribute
 */
class ScalableFunctionAttribute extends appscaling.BaseScalableAttribute {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     * Scale out or in to keep utilization at a given level. The utilization is tracked by the
     * LambdaProvisionedConcurrencyUtilization metric, emitted by lambda. See:
     * https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     */
    scaleOnUtilization(options) {
        if (!core_1.Token.isUnresolved(options.utilizationTarget) && (options.utilizationTarget < 0.1 || options.utilizationTarget > 0.9)) {
            throw new Error(`Utilization Target should be between 0.1 and 0.9. Found ${options.utilizationTarget}.`);
        }
        super.doScaleToTrackMetric('Tracking', {
            targetValue: options.utilizationTarget,
            predefinedMetric: appscaling.PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION,
            ...options,
        });
    }
    /**
     * Scale out or in based on schedule.
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
}
exports.ScalableFunctionAttribute = ScalableFunctionAttribute;
//# sourceMappingURL=data:application/json;base64,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