import * as cloudwatch from "../../aws-cloudwatch";
import { RemovalPolicy } from "../../core";
import { Construct } from 'constructs';
import { Alias, AliasOptions } from './alias';
import { EventInvokeConfigOptions } from './event-invoke-config';
import { IFunction, QualifiedFunctionBase } from './function-base';
/**
 * @experimental
 */
export interface IVersion extends IFunction {
    /**
     * (experimental) The most recently deployed version of this function.
     *
     * @experimental
     * @attribute true
     */
    readonly version: string;
    /**
     * (experimental) The underlying AWS Lambda function.
     *
     * @experimental
     */
    readonly lambda: IFunction;
    /**
     * (experimental) The ARN of the version for Lambda@Edge.
     *
     * @experimental
     */
    readonly edgeArn: string;
    /**
     * (experimental) Defines an alias for this version.
     *
     * @param aliasName The name of the alias.
     * @param options Alias options.
     * @experimental
     */
    addAlias(aliasName: string, options?: AliasOptions): Alias;
}
/**
 * (experimental) Options for `lambda.Version`.
 *
 * @experimental
 */
export interface VersionOptions extends EventInvokeConfigOptions {
    /**
     * (experimental) SHA256 of the version of the Lambda source code.
     *
     * Specify to validate that you're deploying the right version.
     *
     * @default No validation is performed
     * @experimental
     */
    readonly codeSha256?: string;
    /**
     * (experimental) Description of the version.
     *
     * @default Description of the Lambda
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Specifies a provisioned concurrency configuration for a function's version.
     *
     * @default No provisioned concurrency
     * @experimental
     */
    readonly provisionedConcurrentExecutions?: number;
    /**
     * (experimental) Whether to retain old versions of this function when a new version is created.
     *
     * @default RemovalPolicy.DESTROY
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Properties for a new Lambda version.
 *
 * @experimental
 */
export interface VersionProps extends VersionOptions {
    /**
     * (experimental) Function to get the value of.
     *
     * @experimental
     */
    readonly lambda: IFunction;
}
/**
 * @experimental
 */
export interface VersionAttributes {
    /**
     * (experimental) The version.
     *
     * @experimental
     */
    readonly version: string;
    /**
     * (experimental) The lambda function.
     *
     * @experimental
     */
    readonly lambda: IFunction;
}
/**
 * (experimental) A single newly-deployed version of a Lambda function.
 *
 * This object exists to--at deploy time--query the "then-current" version of
 * the Lambda function that it refers to. This Version object can then be
 * used in `Alias` to refer to a particular deployment of a Lambda.
 *
 * This means that for every new update you deploy to your Lambda (using the
 * CDK and Aliases), you must always create a new Version object. In
 * particular, it must have a different name, so that a new resource is
 * created.
 *
 * If you want to ensure that you're associating the right version with
 * the right deployment, specify the `codeSha256` property while
 * creating the `Version.
 *
 * @experimental
 */
export declare class Version extends QualifiedFunctionBase implements IVersion {
    /**
     * (experimental) Construct a Version object from a Version ARN.
     *
     * @param scope The cdk scope creating this resource.
     * @param id The cdk id of this resource.
     * @param versionArn The version ARN to create this version from.
     * @experimental
     */
    static fromVersionArn(scope: Construct, id: string, versionArn: string): IVersion;
    /**
     * @experimental
     */
    static fromVersionAttributes(scope: Construct, id: string, attrs: VersionAttributes): IVersion;
    /**
     * (experimental) The most recently deployed version of this function.
     *
     * @experimental
     */
    readonly version: string;
    /**
     * (experimental) The underlying AWS Lambda function.
     *
     * @experimental
     */
    readonly lambda: IFunction;
    /**
     * (experimental) The ARN fo the function.
     *
     * @experimental
     */
    readonly functionArn: string;
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     */
    readonly functionName: string;
    /**
     * (experimental) The qualifier of the version or alias of this function.
     *
     * A qualifier is the identifier that's appended to a version or alias ARN.
     *
     * @experimental
     */
    protected readonly qualifier: string;
    /**
     * (experimental) Whether the addPermission() call adds any permissions.
     *
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     *
     * @experimental
     */
    protected readonly canCreatePermissions = true;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VersionProps);
    /**
     * (experimental) The principal this Lambda Function is running as.
     *
     * @experimental
     */
    get grantPrincipal(): import("../../aws-iam").IPrincipal;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * Undefined if the function was imported without a role.
     *
     * @experimental
     */
    get role(): import("../../aws-iam").IRole | undefined;
    /**
     * (experimental) Return the given named metric for this Function.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Defines an alias for this version.
     *
     * @param aliasName The name of the alias (e.g. "live").
     * @param options Alias options.
     * @experimental
     */
    addAlias(aliasName: string, options?: AliasOptions): Alias;
    /**
     * (experimental) The ARN of the version for Lambda@Edge.
     *
     * @experimental
     */
    get edgeArn(): string;
    /**
     * Validate that the provisionedConcurrentExecutions makes sense
     *
     * Member must have value greater than or equal to 1
     */
    private determineProvisionedConcurrency;
}
/**
 * Given an opaque (token) ARN, returns a CloudFormation expression that extracts the
 * qualifier (= version or alias) from the ARN.
 *
 * Version ARNs look like this:
 *
 *   arn:aws:lambda:region:account-id:function:function-name:qualifier
 *
 * ..which means that in order to extract the `qualifier` component from the ARN, we can
 * split the ARN using ":" and select the component in index 7.
 *
 * @returns `FnSelect(7, FnSplit(':', arn))`
 */
export declare function extractQualifierFromArn(arn: string): string;
