import * as ecr from "../../aws-ecr";
import { Construct } from 'constructs';
import { AssetImageCodeProps, EcrImageCodeProps, Code } from './code';
import { Function, FunctionOptions } from './function';
/**
 * (experimental) Properties to configure a new DockerImageFunction construct.
 *
 * @experimental
 */
export interface DockerImageFunctionProps extends FunctionOptions {
    /**
     * (experimental) The source code of your Lambda function.
     *
     * You can point to a file in an
     * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
     * code as inline text.
     *
     * @experimental
     */
    readonly code: DockerImageCode;
}
/**
 * (experimental) Code property for the DockerImageFunction construct.
 *
 * @experimental
 */
export declare abstract class DockerImageCode {
    /**
     * (experimental) Use an existing ECR image as the Lambda code.
     *
     * @param repository the ECR repository that the image is in.
     * @param props properties to further configure the selected image.
     * @experimental
     */
    static fromEcr(repository: ecr.IRepository, props?: EcrImageCodeProps): DockerImageCode;
    /**
     * (experimental) Create an ECR image from the specified asset and bind it as the Lambda code.
     *
     * @param directory the directory from which the asset must be created.
     * @param props properties to further configure the selected image.
     * @experimental
     */
    static fromImageAsset(directory: string, props?: AssetImageCodeProps): DockerImageCode;
    /**
     * Produce a `Code` instance from this `DockerImageCode`.
     * @internal
     */
    abstract _bind(): Code;
}
/**
 * (experimental) Create a lambda function where the handler is a docker image.
 *
 * @experimental
 */
export declare class DockerImageFunction extends Function {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DockerImageFunctionProps);
}
