import * as cloudwatch from "../../aws-cloudwatch";
import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import { ConstructNode, IResource, Resource } from "../../core";
import { EventInvokeConfigOptions } from './event-invoke-config';
import { IEventSource } from './event-source';
import { EventSourceMapping, EventSourceMappingOptions } from './event-source-mapping';
import { IVersion } from './lambda-version';
import { Permission } from './permission';
/**
 * @experimental
 */
export interface IFunction extends IResource, ec2.IConnectable, iam.IGrantable {
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionName: string;
    /**
     * (experimental) The ARN fo the function.
     *
     * @experimental
     * @attribute true
     */
    readonly functionArn: string;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Whether or not this Lambda function was bound to a VPC.
     *
     * If this is is `false`, trying to access the `connections` object will fail.
     *
     * @experimental
     */
    readonly isBoundToVpc: boolean;
    /**
     * (experimental) The `$LATEST` version of this function.
     *
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     *
     * To obtain a reference to an explicit version which references the current
     * function configuration, use `lambdaFunction.currentVersion` instead.
     *
     * @experimental
     */
    readonly latestVersion: IVersion;
    /**
     * (experimental) The construct node where permissions are attached.
     *
     * @experimental
     */
    readonly permissionsNode: ConstructNode;
    /**
     * (experimental) Adds an event source that maps to this AWS Lambda function.
     *
     * @param id construct ID.
     * @param options mapping options.
     * @experimental
     */
    addEventSourceMapping(id: string, options: EventSourceMappingOptions): EventSourceMapping;
    /**
     * (experimental) Adds a permission to the Lambda resource policy.
     *
     * @param id The id for the permission construct.
     * @param permission The permission to grant to this Lambda function.
     * @see Permission for details.
     * @experimental
     */
    addPermission(id: string, permission: Permission): void;
    /**
     * (experimental) Adds a statement to the IAM role assumed by the instance.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Grant the given identity permissions to invoke this Lambda.
     *
     * @experimental
     */
    grantInvoke(identity: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Lambda Return the given named metric for this Function.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the Duration of this Lambda How long execution of this Lambda takes.
     *
     * Average over 5 minutes
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     *
     * Sum over 5 minutes
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     *
     * Sum over 5 minutes
     *
     * @default sum over 5 minutes
     * @experimental
     */
    metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Adds an event source to this function.
     *
     * Event sources are implemented in the @aws-cdk/aws-lambda-event-sources module.
     *
     * The following example adds an SQS Queue as an event source:
     * ```
     * import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
     * myFunction.addEventSource(new SqsEventSource(myQueue));
     * ```
     *
     * @experimental
     */
    addEventSource(source: IEventSource): void;
    /**
     * (experimental) Configures options for asynchronous invocation.
     *
     * @experimental
     */
    configureAsyncInvoke(options: EventInvokeConfigOptions): void;
}
/**
 * (experimental) Represents a Lambda function defined outside of this stack.
 *
 * @experimental
 */
export interface FunctionAttributes {
    /**
     * (experimental) The ARN of the Lambda function.
     *
     * Format: arn:<partition>:lambda:<region>:<account-id>:function:<function-name>
     *
     * @experimental
     */
    readonly functionArn: string;
    /**
     * (experimental) The IAM execution role associated with this function.
     *
     * If the role is not specified, any role-related operations will no-op.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (deprecated) Id of the security group of this Lambda, if in a VPC.
     *
     * This needs to be given in order to support allowing connections
     * to this Lambda.
     *
     * @deprecated use `securityGroup` instead
     */
    readonly securityGroupId?: string;
    /**
     * (experimental) The security group of this Lambda, if in a VPC.
     *
     * This needs to be given in order to support allowing connections
     * to this Lambda.
     *
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Setting this property informs the CDK that the imported function is in the same environment as the stack.
     *
     * This affects certain behaviours such as, whether this function's permission can be modified.
     * When not configured, the CDK attempts to auto-determine this. For environment agnostic stacks, i.e., stacks
     * where the account is not specified with the `env` property, this is determined to be false.
     *
     * Set this to property *ONLY IF* the imported function is in the same account as the stack
     * it's imported in.
     *
     * @default - depends: true, if the Stack is configured with an explicit `env` (account and region) and the account is the same as this function.
     * For environment-agnostic stacks this will default to `false`.
     * @experimental
     */
    readonly sameEnvironment?: boolean;
}
/**
 * @experimental
 */
export declare abstract class FunctionBase extends Resource implements IFunction, ec2.IClientVpnConnectionHandler {
    /**
     * (experimental) The principal this Lambda Function is running as.
     *
     * @experimental
     */
    abstract readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     */
    abstract readonly functionName: string;
    /**
     * (experimental) The ARN fo the function.
     *
     * @experimental
     */
    abstract readonly functionArn: string;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * Undefined if the function was imported without a role.
     *
     * @experimental
     */
    abstract readonly role?: iam.IRole;
    /**
     * (experimental) The construct node where permissions are attached.
     *
     * @experimental
     */
    abstract readonly permissionsNode: ConstructNode;
    /**
     * (experimental) Whether the addPermission() call adds any permissions.
     *
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     *
     * @experimental
     */
    protected abstract readonly canCreatePermissions: boolean;
    /**
     * Actual connections object for this Lambda
     *
     * May be unset, in which case this Lambda is not configured use in a VPC.
     * @internal
     */
    protected _connections?: ec2.Connections;
    private _latestVersion?;
    /**
     * Mapping of invocation principals to grants. Used to de-dupe `grantInvoke()` calls.
     * @internal
     */
    protected _invocationGrants: Record<string, iam.Grant>;
    /**
     * (experimental) Adds a permission to the Lambda resource policy.
     *
     * @param id The id for the permission construct.
     * @param permission The permission to grant to this Lambda function.
     * @see Permission for details.
     * @experimental
     */
    addPermission(id: string, permission: Permission): void;
    /**
     * (experimental) Adds a statement to the IAM role assumed by the instance.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Access the Connections object.
     *
     * Will fail if not a VPC-enabled Lambda Function
     *
     * @experimental
     */
    get connections(): ec2.Connections;
    /**
     * (experimental) The `$LATEST` version of this function.
     *
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     *
     * To obtain a reference to an explicit version which references the current
     * function configuration, use `lambdaFunction.currentVersion` instead.
     *
     * @experimental
     */
    get latestVersion(): IVersion;
    /**
     * (experimental) Whether or not this Lambda function was bound to a VPC.
     *
     * If this is is `false`, trying to access the `connections` object will fail.
     *
     * @experimental
     */
    get isBoundToVpc(): boolean;
    /**
     * (experimental) Adds an event source that maps to this AWS Lambda function.
     *
     * @experimental
     */
    addEventSourceMapping(id: string, options: EventSourceMappingOptions): EventSourceMapping;
    /**
     * (experimental) Grant the given identity permissions to invoke this Lambda.
     *
     * @experimental
     */
    grantInvoke(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Adds an event source to this function.
     *
     * Event sources are implemented in the @aws-cdk/aws-lambda-event-sources module.
     *
     * The following example adds an SQS Queue as an event source:
     * ```
     * import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
     * myFunction.addEventSource(new SqsEventSource(myQueue));
     * ```
     *
     * @experimental
     */
    addEventSource(source: IEventSource): void;
    /**
     * (experimental) Configures options for asynchronous invocation.
     *
     * @experimental
     */
    configureAsyncInvoke(options: EventInvokeConfigOptions): void;
    /**
     * Returns the construct tree node that corresponds to the lambda function.
     * For use internally for constructs, when the tree is set up in non-standard ways. Ex: SingletonFunction.
     * @internal
     */
    protected _functionNode(): ConstructNode;
    /**
     * Given the function arn, check if the account id matches this account
     *
     * Function ARNs look like this:
     *
     *   arn:aws:lambda:region:account-id:function:function-name
     *
     * ..which means that in order to extract the `account-id` component from the ARN, we can
     * split the ARN using ":" and select the component in index 4.
     *
     * @returns true if account id of function matches the account specified on the stack, false otherwise.
     *
     * @internal
     */
    protected _isStackAccount(): boolean;
    /**
     * Translate IPrincipal to something we can pass to AWS::Lambda::Permissions
     *
     * Do some nasty things because `Permission` supports a subset of what the
     * full IAM principal language supports, and we may not be able to parse strings
     * outright because they may be tokens.
     *
     * Try to recognize some specific Principal classes first, then try a generic
     * fallback.
     */
    private parsePermissionPrincipal;
    private parseConditions;
    private isPrincipalWithConditions;
}
/**
 * @experimental
 */
export declare abstract class QualifiedFunctionBase extends FunctionBase {
    /**
     * @experimental
     */
    abstract readonly lambda: IFunction;
    /**
     * (experimental) The construct node where permissions are attached.
     *
     * @experimental
     */
    readonly permissionsNode: ConstructNode;
    /**
     * (experimental) The qualifier of the version or alias of this function.
     *
     * A qualifier is the identifier that's appended to a version or alias ARN.
     *
     * @see https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#API_GetFunctionConfiguration_RequestParameters
     * @experimental
     */
    protected abstract readonly qualifier: string;
    /**
     * (experimental) The `$LATEST` version of this function.
     *
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     *
     * To obtain a reference to an explicit version which references the current
     * function configuration, use `lambdaFunction.currentVersion` instead.
     *
     * @experimental
     */
    get latestVersion(): IVersion;
    /**
     * (experimental) Configures options for asynchronous invocation.
     *
     * @experimental
     */
    configureAsyncInvoke(options: EventInvokeConfigOptions): void;
}
