"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInvokeConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * (experimental) Configure options for asynchronous invocation on a version or an alias.
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 *
 * @experimental
 */
class EventInvokeConfig extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: (_b = props.retryAttempts) !== null && _b !== void 0 ? _b : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
_a = JSII_RTTI_SYMBOL_1;
EventInvokeConfig[_a] = { fqn: "monocdk.aws_lambda.EventInvokeConfig", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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