import { IFunction } from './function-base';
import { Construct } from "../../core";
/**
 * (experimental) A destination configuration.
 *
 * @experimental
 */
export interface DestinationConfig {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the destination resource.
     *
     * @experimental
     */
    readonly destination: string;
}
/**
 * (experimental) The type of destination.
 *
 * @experimental
 */
export declare enum DestinationType {
    /**
     * (experimental) Failure.
     *
     * @experimental
     */
    FAILURE = "Failure",
    /**
     * (experimental) Success.
     *
     * @experimental
     */
    SUCCESS = "Success"
}
/**
 * (experimental) Options when binding a destination to a function.
 *
 * @experimental
 */
export interface DestinationOptions {
    /**
     * (experimental) The destination type.
     *
     * @experimental
     */
    readonly type: DestinationType;
}
/**
 * (experimental) A Lambda destination.
 *
 * @experimental
 */
export interface IDestination {
    /**
     * (experimental) Binds this destination to the Lambda function.
     *
     * @experimental
     */
    bind(scope: Construct, fn: IFunction, options?: DestinationOptions): DestinationConfig;
}
