import * as ecr from "../../aws-ecr";
import * as ecr_assets from "../../aws-ecr-assets";
import * as s3 from "../../aws-s3";
import * as s3_assets from "../../aws-s3-assets";
import * as cdk from "../../core";
import { Construct } from "../../core";
/**
 * (experimental) Represents the Lambda Handler Code.
 *
 * @experimental
 */
export declare abstract class Code {
    /**
     * (experimental) Lambda handler code as an S3 object.
     *
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @param objectVersion Optional S3 object version.
     * @experimental
     */
    static fromBucket(bucket: s3.IBucket, key: string, objectVersion?: string): S3Code;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `fromBucket`
     */
    static bucket(bucket: s3.IBucket, key: string, objectVersion?: string): S3Code;
    /**
     * (experimental) Inline code for Lambda handler.
     *
     * @param code The actual handler code (limited to 4KiB).
     * @returns `LambdaInlineCode` with inline code.
     * @experimental
     */
    static fromInline(code: string): InlineCode;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `fromInline`
     */
    static inline(code: string): InlineCode;
    /**
     * (experimental) Loads the function code from a local disk path.
     *
     * @param path Either a directory with the Lambda code bundle or a .zip file.
     * @experimental
     */
    static fromAsset(path: string, options?: s3_assets.AssetOptions): AssetCode;
    /**
     * (experimental) Loads the function code from an asset created by a Docker build.
     *
     * By default, the asset is expected to be located at `/asset` in the
     * image.
     *
     * @param path The path to the directory containing the Docker file.
     * @param options Docker build options.
     * @experimental
     */
    static fromDockerBuild(path: string, options?: DockerBuildAssetOptions): AssetCode;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `fromAsset`
     */
    static asset(path: string): AssetCode;
    /**
     * (experimental) Creates a new Lambda source defined using CloudFormation parameters.
     *
     * @param props optional construction properties of {@link CfnParametersCode}.
     * @returns a new instance of `CfnParametersCode`
     * @experimental
     */
    static fromCfnParameters(props?: CfnParametersCodeProps): CfnParametersCode;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `fromCfnParameters`
     */
    static cfnParameters(props?: CfnParametersCodeProps): CfnParametersCode;
    /**
     * (experimental) Use an existing ECR image as the Lambda code.
     *
     * @param repository the ECR repository that the image is in.
     * @param props properties to further configure the selected image.
     * @experimental
     */
    static fromEcrImage(repository: ecr.IRepository, props?: EcrImageCodeProps): EcrImageCode;
    /**
     * (experimental) Create an ECR image from the specified asset and bind it as the Lambda code.
     *
     * @param directory the directory from which the asset must be created.
     * @param props properties to further configure the selected image.
     * @experimental
     */
    static fromAssetImage(directory: string, props?: AssetImageCodeProps): AssetImageCode;
    /**
     * (deprecated) Determines whether this Code is inline code or not.
     *
     * @deprecated this value is ignored since inline is now determined based on the
     * the `inlineCode` field of `CodeConfig` returned from `bind()`.
     */
    abstract readonly isInline: boolean;
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @param scope The binding scope.
     * @experimental
     */
    abstract bind(scope: Construct): CodeConfig;
    /**
     * (experimental) Called after the CFN function resource has been created to allow the code class to bind to it.
     *
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     *
     * @experimental
     */
    bindToResource(_resource: cdk.CfnResource, _options?: ResourceBindOptions): void;
}
/**
 * (experimental) Result of binding `Code` into a `Function`.
 *
 * @experimental
 */
export interface CodeConfig {
    /**
     * (experimental) The location of the code in S3 (mutually exclusive with `inlineCode` and `image`).
     *
     * @default - code is not an s3 location
     * @experimental
     */
    readonly s3Location?: s3.Location;
    /**
     * (experimental) Inline code (mutually exclusive with `s3Location` and `image`).
     *
     * @default - code is not inline code
     * @experimental
     */
    readonly inlineCode?: string;
    /**
     * (experimental) Docker image configuration (mutually exclusive with `s3Location` and `inlineCode`).
     *
     * @default - code is not an ECR container image
     * @experimental
     */
    readonly image?: CodeImageConfig;
}
/**
 * (experimental) Result of the bind when an ECR image is used.
 *
 * @experimental
 */
export interface CodeImageConfig {
    /**
     * (experimental) URI to the Docker image.
     *
     * @experimental
     */
    readonly imageUri: string;
    /**
     * (experimental) Specify or override the CMD on the specified Docker image or Dockerfile.
     *
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the CMD specified in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#cmd
     * @experimental
     */
    readonly cmd?: string[];
    /**
     * (experimental) Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     *
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the ENTRYPOINT in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     * @experimental
     */
    readonly entrypoint?: string[];
}
/**
 * (experimental) Lambda code from an S3 archive.
 *
 * @experimental
 */
export declare class S3Code extends Code {
    private key;
    private objectVersion?;
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline = false;
    private bucketName;
    /**
     * @experimental
     */
    constructor(bucket: s3.IBucket, key: string, objectVersion?: string | undefined);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(_scope: Construct): CodeConfig;
}
/**
 * (experimental) Lambda code from an inline string (limited to 4KiB).
 *
 * @experimental
 */
export declare class InlineCode extends Code {
    private code;
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline = true;
    /**
     * @experimental
     */
    constructor(code: string);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(_scope: Construct): CodeConfig;
}
/**
 * (experimental) Lambda code from a local directory.
 *
 * @experimental
 */
export declare class AssetCode extends Code {
    readonly path: string;
    private readonly options;
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline = false;
    private asset?;
    /**
     * @param path The path to the asset file or directory.
     * @experimental
     */
    constructor(path: string, options?: s3_assets.AssetOptions);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(scope: Construct): CodeConfig;
    /**
     * (experimental) Called after the CFN function resource has been created to allow the code class to bind to it.
     *
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     *
     * @experimental
     */
    bindToResource(resource: cdk.CfnResource, options?: ResourceBindOptions): void;
}
/**
 * @experimental
 */
export interface ResourceBindOptions {
    /**
     * (experimental) The name of the CloudFormation property to annotate with asset metadata.
     *
     * @default Code
     * @see https://github.com/aws/aws-cdk/issues/1432
     * @experimental
     */
    readonly resourceProperty?: string;
}
/**
 * (experimental) Construction properties for {@link CfnParametersCode}.
 *
 * @experimental
 */
export interface CfnParametersCodeProps {
    /**
     * (experimental) The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in.
     *
     * Must be of type 'String'.
     *
     * @default a new parameter will be created
     * @experimental
     */
    readonly bucketNameParam?: cdk.CfnParameter;
    /**
     * (experimental) The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at.
     *
     * Must be of type 'String'.
     *
     * @default a new parameter will be created
     * @experimental
     */
    readonly objectKeyParam?: cdk.CfnParameter;
}
/**
 * (experimental) Lambda code defined using 2 CloudFormation parameters.
 *
 * Useful when you don't have access to the code of your Lambda from your CDK code, so you can't use Assets,
 * and you want to deploy the Lambda in a CodePipeline, using CloudFormation Actions -
 * you can fill the parameters using the {@link #assign} method.
 *
 * @experimental
 */
export declare class CfnParametersCode extends Code {
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline = false;
    private _bucketNameParam?;
    private _objectKeyParam?;
    /**
     * @experimental
     */
    constructor(props?: CfnParametersCodeProps);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(scope: Construct): CodeConfig;
    /**
     * (experimental) Create a parameters map from this instance's CloudFormation parameters.
     *
     * It returns a map with 2 keys that correspond to the names of the parameters defined in this Lambda code,
     * and as values it contains the appropriate expressions pointing at the provided S3 location
     * (most likely, obtained from a CodePipeline Artifact by calling the `artifact.s3Location` method).
     * The result should be provided to the CloudFormation Action
     * that is deploying the Stack that the Lambda with this code is part of,
     * in the `parameterOverrides` property.
     *
     * @param location the location of the object in S3 that represents the Lambda code.
     * @experimental
     */
    assign(location: s3.Location): {
        [name: string]: any;
    };
    /**
     * @experimental
     */
    get bucketNameParam(): string;
    /**
     * @experimental
     */
    get objectKeyParam(): string;
}
/**
 * (experimental) Properties to initialize a new EcrImageCode.
 *
 * @experimental
 */
export interface EcrImageCodeProps {
    /**
     * (experimental) Specify or override the CMD on the specified Docker image or Dockerfile.
     *
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the CMD specified in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#cmd
     * @experimental
     */
    readonly cmd?: string[];
    /**
     * (experimental) Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     *
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the ENTRYPOINT in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     * @experimental
     */
    readonly entrypoint?: string[];
    /**
     * (experimental) The image tag to use when pulling the image from ECR.
     *
     * @default 'latest'
     * @experimental
     */
    readonly tag?: string;
}
/**
 * (experimental) Represents a Docker image in ECR that can be bound as Lambda Code.
 *
 * @experimental
 */
export declare class EcrImageCode extends Code {
    private readonly repository;
    private readonly props;
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline: boolean;
    /**
     * @experimental
     */
    constructor(repository: ecr.IRepository, props?: EcrImageCodeProps);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(_: Construct): CodeConfig;
}
/**
 * (experimental) Properties to initialize a new AssetImage.
 *
 * @experimental
 */
export interface AssetImageCodeProps extends ecr_assets.DockerImageAssetOptions {
    /**
     * (experimental) Specify or override the CMD on the specified Docker image or Dockerfile.
     *
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the CMD specified in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#cmd
     * @experimental
     */
    readonly cmd?: string[];
    /**
     * (experimental) Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     *
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., `[ 'executable', 'param1', 'param2' ]`.
     *
     * @default - use the ENTRYPOINT in the docker image or Dockerfile.
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     * @experimental
     */
    readonly entrypoint?: string[];
}
/**
 * (experimental) Represents an ECR image that will be constructed from the specified asset and can be bound as Lambda code.
 *
 * @experimental
 */
export declare class AssetImageCode extends Code {
    private readonly directory;
    private readonly props;
    /**
     * (experimental) Determines whether this Code is inline code or not.
     *
     * @experimental
     */
    readonly isInline: boolean;
    /**
     * @experimental
     */
    constructor(directory: string, props: AssetImageCodeProps);
    /**
     * (experimental) Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(scope: Construct): CodeConfig;
}
/**
 * (experimental) Options when creating an asset from a Docker build.
 *
 * @experimental
 */
export interface DockerBuildAssetOptions extends cdk.DockerBuildOptions {
    /**
     * (experimental) The path in the Docker image where the asset is located after the build operation.
     *
     * @default /asset
     * @experimental
     */
    readonly imagePath?: string;
    /**
     * (experimental) The path on the local filesystem where the asset will be copied using `docker cp`.
     *
     * @default - a unique temporary directory in the system temp directory
     * @experimental
     */
    readonly outputPath?: string;
}
