"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeSigningConfig = exports.UntrustedArtifactOnDeployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const lambda_generated_1 = require("./lambda.generated");
/**
 * (experimental) Code signing configuration policy for deployment validation failure.
 *
 * @experimental
 */
var UntrustedArtifactOnDeployment;
(function (UntrustedArtifactOnDeployment) {
    UntrustedArtifactOnDeployment["ENFORCE"] = "Enforce";
    UntrustedArtifactOnDeployment["WARN"] = "Warn";
})(UntrustedArtifactOnDeployment = exports.UntrustedArtifactOnDeployment || (exports.UntrustedArtifactOnDeployment = {}));
/**
 * (experimental) Defines a Code Signing Config.
 *
 * @experimental
 * @resource AWS::Lambda::CodeSigningConfig
 */
class CodeSigningConfig extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const signingProfileVersionArns = props.signingProfiles.map(signingProfile => {
            return signingProfile.signingProfileVersionArn;
        });
        const resource = new lambda_generated_1.CfnCodeSigningConfig(this, 'Resource', {
            allowedPublishers: {
                signingProfileVersionArns,
            },
            codeSigningPolicies: {
                untrustedArtifactOnDeployment: (_b = props.untrustedArtifactOnDeployment) !== null && _b !== void 0 ? _b : UntrustedArtifactOnDeployment.WARN,
            },
            description: props.description,
        });
        this.codeSigningConfigArn = resource.attrCodeSigningConfigArn;
        this.codeSigningConfigId = resource.attrCodeSigningConfigId;
    }
    /**
     * (experimental) Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param codeSigningConfigArn The ARN of code signing config.
     * @experimental
     */
    static fromCodeSigningConfigArn(scope, id, codeSigningConfigArn) {
        const codeSigningProfileId = core_1.Stack.of(scope).parseArn(codeSigningConfigArn).resourceName;
        if (!codeSigningProfileId) {
            throw new Error(`Code signing config ARN must be in the format 'arn:aws:lambda:<region>:<account>:code-signing-config:<codeSigningConfigArn>', got: '${codeSigningConfigArn}'`);
        }
        const assertedCodeSigningProfileId = codeSigningProfileId;
        class Import extends core_1.Resource {
            constructor() {
                super(scope, id);
                this.codeSigningConfigArn = codeSigningConfigArn;
                this.codeSigningConfigId = assertedCodeSigningProfileId;
            }
        }
        return new Import();
    }
}
exports.CodeSigningConfig = CodeSigningConfig;
_a = JSII_RTTI_SYMBOL_1;
CodeSigningConfig[_a] = { fqn: "monocdk.aws_lambda.CodeSigningConfig", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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