import { ISigningProfile } from "../../aws-signer";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Code signing configuration policy for deployment validation failure.
 *
 * @experimental
 */
export declare enum UntrustedArtifactOnDeployment {
    /**
     * (experimental) Lambda blocks the deployment request if signature validation checks fail.
     *
     * @experimental
     */
    ENFORCE = "Enforce",
    /**
     * (experimental) Lambda allows the deployment of the code package, but issues a warning.
     *
     * Lambda issues a new Amazon CloudWatch metric, called a signature validation error and also stores the warning in CloudTrail.
     *
     * @experimental
     */
    WARN = "Warn"
}
/**
 * (experimental) A Code Signing Config.
 *
 * @experimental
 */
export interface ICodeSigningConfig extends IResource {
    /**
     * (experimental) The ARN of Code Signing Config.
     *
     * @experimental
     * @attribute true
     */
    readonly codeSigningConfigArn: string;
    /**
     * (experimental) The id of Code Signing Config.
     *
     * @experimental
     * @attribute true
     */
    readonly codeSigningConfigId: string;
}
/**
 * (experimental) Construction properties for a Code Signing Config object.
 *
 * @experimental
 */
export interface CodeSigningConfigProps {
    /**
     * (experimental) List of signing profiles that defines a trusted user who can sign a code package.
     *
     * @experimental
     */
    readonly signingProfiles: ISigningProfile[];
    /**
     * (experimental) Code signing configuration policy for deployment validation failure.
     *
     * If you set the policy to Enforce, Lambda blocks the deployment request
     * if signature validation checks fail.
     * If you set the policy to Warn, Lambda allows the deployment and
     * creates a CloudWatch log.
     *
     * @default UntrustedArtifactOnDeployment.WARN
     * @experimental
     */
    readonly untrustedArtifactOnDeployment?: UntrustedArtifactOnDeployment;
    /**
     * (experimental) Code signing configuration description.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Defines a Code Signing Config.
 *
 * @experimental
 * @resource AWS::Lambda::CodeSigningConfig
 */
export declare class CodeSigningConfig extends Resource implements ICodeSigningConfig {
    /**
     * (experimental) Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param codeSigningConfigArn The ARN of code signing config.
     * @experimental
     */
    static fromCodeSigningConfigArn(scope: Construct, id: string, codeSigningConfigArn: string): ICodeSigningConfig;
    /**
     * (experimental) The ARN of Code Signing Config.
     *
     * @experimental
     */
    readonly codeSigningConfigArn: string;
    /**
     * (experimental) The id of Code Signing Config.
     *
     * @experimental
     */
    readonly codeSigningConfigId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CodeSigningConfigProps);
}
