import * as lambda from "../../aws-lambda";
import { AssetHashType } from "../../core";
import { Construct } from "../../core";
/**
 * (experimental) Properties for a PythonFunction.
 *
 * @experimental
 */
export interface PythonFunctionProps extends lambda.FunctionOptions {
    /**
     * (experimental) The path to the root directory of the function.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The path (relative to entry) to the index file containing the exported handler.
     *
     * @default index.py
     * @experimental
     */
    readonly index?: string;
    /**
     * (experimental) The name of the exported handler in the index file.
     *
     * @default handler
     * @experimental
     */
    readonly handler?: string;
    /**
     * (experimental) The runtime environment.
     *
     * Only runtimes of the Python family are
     * supported.
     *
     * @default lambda.Runtime.PYTHON_3_7
     * @experimental
     */
    readonly runtime?: lambda.Runtime;
    /**
     * (experimental) Determines how asset hash is calculated. Assets will get rebuild and uploaded only if their hash has changed.
     *
     * If asset hash is set to `SOURCE` (default), then only changes to the source
     * directory will cause the asset to rebuild. This means, for example, that in
     * order to pick up a new dependency version, a change must be made to the
     * source tree. Ideally, this can be implemented by including a dependency
     * lockfile in your source tree or using fixed dependencies.
     *
     * If the asset hash is set to `OUTPUT`, the hash is calculated after
     * bundling. This means that any change in the output will cause the asset to
     * be invalidated and uploaded. Bear in mind that `pip` adds timestamps to
     * dependencies it installs, which implies that in this mode Python bundles
     * will _always_ get rebuild and uploaded. Normally this is an anti-pattern
     * since build
     *
     * @default AssetHashType.SOURCE By default, hash is calculated based on the
     * contents of the source directory. This means that only updates to the
     * source will cause the asset to rebuild.
     * @experimental
     */
    readonly assetHashType?: AssetHashType;
    /**
     * (experimental) Specify a custom hash for this asset.
     *
     * If `assetHashType` is set it must
     * be set to `AssetHashType.CUSTOM`. For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     *
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     *
     * @default - based on `assetHashType`
     * @experimental
     */
    readonly assetHash?: string;
}
/**
 * (experimental) A Python Lambda function.
 *
 * @experimental
 */
export declare class PythonFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PythonFunctionProps);
}
