import { DockerImage } from "../../core";
/**
 * (experimental) Bundling options.
 *
 * @experimental
 */
export interface BundlingOptions {
    /**
     * (experimental) Whether to minify files when bundling.
     *
     * @default false
     * @experimental
     */
    readonly minify?: boolean;
    /**
     * (experimental) Whether to include source maps when bundling.
     *
     * @default false
     * @experimental
     */
    readonly sourceMap?: boolean;
    /**
     * (experimental) Target environment for the generated JavaScript code.
     *
     * @default - the node version of the runtime
     * @see https://esbuild.github.io/api/#target
     * @experimental
     */
    readonly target?: string;
    /**
     * (experimental) Use loaders to change how a given input file is interpreted.
     *
     * Configuring a loader for a given file type lets you load that file type with
     * an `import` statement or a `require` call.
     *
     * @default - use esbuild default loaders
     * @see https://esbuild.github.io/api/#loader
     * @experimental
     * @example
     *
     * { '.png': 'dataurl' }
     */
    readonly loader?: {
        [ext: string]: string;
    };
    /**
     * (experimental) Log level for esbuild.
     *
     * @default LogLevel.WARNING
     * @experimental
     */
    readonly logLevel?: LogLevel;
    /**
     * (experimental) Whether to preserve the original `name` values even in minified code.
     *
     * In JavaScript the `name` property on functions and classes defaults to a
     * nearby identifier in the source code.
     *
     * However, minification renames symbols to reduce code size and bundling
     * sometimes need to rename symbols to avoid collisions. That changes value of
     * the `name` property for many of these cases. This is usually fine because
     * the `name` property is normally only used for debugging. However, some
     * frameworks rely on the `name` property for registration and binding purposes.
     * If this is the case, you can enable this option to preserve the original
     * `name` values even in minified code.
     *
     * @default false
     * @experimental
     */
    readonly keepNames?: boolean;
    /**
     * (experimental) Normally the esbuild automatically discovers `tsconfig.json` files and reads their contents during a build.
     *
     * However, you can also configure a custom `tsconfig.json` file to use instead.
     *
     * This is similar to entry path, you need to provide path to your custom `tsconfig.json`.
     *
     * This can be useful if you need to do multiple builds of the same code with different settings.
     *
     * @default - automatically discovered by `esbuild`
     * @experimental
     * @example
     *
     * { 'tsconfig': 'path/custom.tsconfig.json' }
     */
    readonly tsconfig?: string;
    /**
     * (experimental) This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
     *
     * The metadata in this JSON file follows this schema (specified using TypeScript syntax):
     *
     * ```typescript
     *   {
     *      outputs: {
     *           [path: string]: {
     *             bytes: number
     *             inputs: {
     *               [path: string]: { bytesInOutput: number }
     *             }
     *             imports: { path: string }[]
     *             exports: string[]
     *           }
     *         }
     *      }
     * }
     * ```
     * This data can then be analyzed by other tools. For example,
     * bundle buddy can consume esbuild's metadata format and generates a treemap visualization
     * of the modules in your bundle and how much space each one takes up.
     *
     * @default - false
     * @see https://esbuild.github.io/api/#metafile
     * @experimental
     */
    readonly metafile?: boolean;
    /**
     * (experimental) Use this to insert an arbitrary string at the beginning of generated JavaScript files.
     *
     * This is similar to footer which inserts at the end instead of the beginning.
     *
     * This is commonly used to insert comments:
     *
     * @default -  no comments are passed
     * @experimental
     */
    readonly banner?: string;
    /**
     * (experimental) Use this to insert an arbitrary string at the end of generated JavaScript files.
     *
     * This is similar to banner which inserts at the beginning instead of the end.
     *
     * This is commonly used to insert comments
     *
     * @default -  no comments are passed
     * @experimental
     */
    readonly footer?: string;
    /**
     * (experimental) Environment variables defined when bundling runs.
     *
     * @default - no environment variables are defined.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) Replace global identifiers with constant expressions.
     *
     * @default - no replacements are made
     * @experimental
     * @example
     *
     * { 'process.env.API_KEY': JSON.stringify('xxx-xxxx-xxx') }
     */
    readonly define?: {
        [key: string]: string;
    };
    /**
     * (experimental) A list of modules that should be considered as externals (already available in the runtime).
     *
     * @default ['aws-sdk']
     * @experimental
     */
    readonly externalModules?: string[];
    /**
     * (experimental) A list of modules that should be installed instead of bundled.
     *
     * Modules are
     * installed in a Lambda compatible environment only when bundling runs in
     * Docker.
     *
     * @default - all modules are bundled
     * @experimental
     */
    readonly nodeModules?: string[];
    /**
     * (experimental) The version of esbuild to use when running in a Docker container.
     *
     * @default - latest v0
     * @experimental
     */
    readonly esbuildVersion?: string;
    /**
     * (experimental) Build arguments to pass when building the bundling image.
     *
     * @default - no build arguments are passed
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * (experimental) Force bundling in a Docker container even if local bundling is possible.
     *
     * This is useful if your function relies on node modules
     * that should be installed (`nodeModules`) in a Lambda compatible
     * environment.
     *
     * @default false
     * @experimental
     */
    readonly forceDockerBundling?: boolean;
    /**
     * (experimental) A custom bundling Docker image.
     *
     * This image should have esbuild installed globally. If you plan to use `nodeModules`
     * it should also have `npm` or `yarn` depending on the lock file you're using.
     *
     * See https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/lib/Dockerfile
     * for the default image provided by @aws-cdk/aws-lambda-nodejs.
     *
     * @default - use the Docker image provided by
     * @experimental
     * @aws-cdk /aws-lambda-nodejs
     */
    readonly dockerImage?: DockerImage;
    /**
     * (experimental) Command hooks.
     *
     * @default - do not run additional commands
     * @experimental
     */
    readonly commandHooks?: ICommandHooks;
}
/**
 * (experimental) Command hooks.
 *
 * These commands will run in the environment in which bundling occurs: inside
 * the container for Docker bundling or on the host OS for local bundling.
 *
 * Commands are chained with `&&`.
 *
 * @experimental
 * @example
 *
 * {
 *   // Copy a file from the input directory to the output directory
 *   // to include it in the bundled asset
 *   afterBundling(inputDir: string, outputDir: string): string[] {
 *     return [`cp ${inputDir}/my-binary.node ${outputDir}`];
 *   }
 *   // ...
 * }
 */
export interface ICommandHooks {
    /**
     * (experimental) Returns commands to run before bundling.
     *
     * Commands are chained with `&&`.
     *
     * @experimental
     */
    beforeBundling(inputDir: string, outputDir: string): string[];
    /**
     * (experimental) Returns commands to run before installing node modules.
     *
     * This hook only runs when node modules are installed.
     *
     * Commands are chained with `&&`.
     *
     * @experimental
     */
    beforeInstall(inputDir: string, outputDir: string): string[];
    /**
     * (experimental) Returns commands to run after bundling.
     *
     * Commands are chained with `&&`.
     *
     * @experimental
     */
    afterBundling(inputDir: string, outputDir: string): string[];
}
/**
 * (experimental) Log level for esbuild.
 *
 * @experimental
 */
export declare enum LogLevel {
    /**
     * (experimental) Show everything.
     *
     * @experimental
     */
    INFO = "info",
    /**
     * (experimental) Show warnings and errors.
     *
     * @experimental
     */
    WARNING = "warning",
    /**
     * (experimental) Show errors only.
     *
     * @experimental
     */
    ERROR = "error",
    /**
     * (experimental) Show nothing.
     *
     * @experimental
     */
    SILENT = "silent"
}
