"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageManager = void 0;
const os = require("os");
const path = require("path");
/**
 * A node package manager
 */
class PackageManager {
    constructor(props) {
        this.lockFile = props.lockFile;
        this.installCommand = props.installCommand;
        this.runCommand = props.runCommand;
    }
    static fromLockFile(lockFilePath) {
        const lockFile = path.basename(lockFilePath);
        switch (lockFile) {
            case PackageManager.NPM.lockFile:
                return PackageManager.NPM;
            case PackageManager.YARN.lockFile:
                return PackageManager.YARN;
            case PackageManager.PNPM.lockFile:
                return PackageManager.PNPM;
            default:
                return PackageManager.NPM;
        }
    }
    runBinCommand(bin) {
        const [runCommand, ...runArgs] = this.runCommand;
        return [
            os.platform() === 'win32' ? `${runCommand}.cmd` : runCommand,
            ...runArgs,
            bin,
        ].join(' ');
    }
}
exports.PackageManager = PackageManager;
PackageManager.NPM = new PackageManager({
    lockFile: 'package-lock.json',
    installCommand: ['npm', 'install'],
    runCommand: ['npx', '--no-install'],
});
PackageManager.YARN = new PackageManager({
    lockFile: 'yarn.lock',
    installCommand: ['yarn', 'install'],
    runCommand: ['yarn', 'run'],
});
PackageManager.PNPM = new PackageManager({
    lockFile: 'pnpm-lock.yaml',
    installCommand: ['pnpm', 'install'],
    runCommand: ['pnpm', 'run'],
});
//# sourceMappingURL=data:application/json;base64,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