"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * An esbuild installation
 */
class EsbuildInstallation {
    static detect() {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersion('esbuild');
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const esbuild = child_process_1.spawnSync('esbuild', ['--version']);
            if (esbuild.status === 0 && !esbuild.error) {
                return {
                    isLocal: false,
                    version: esbuild.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.EsbuildInstallation = EsbuildInstallation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXNidWlsZC1pbnN0YWxsYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlc2J1aWxkLWluc3RhbGxhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpREFBMEM7QUFDMUMsaUNBQTZDO0FBQzdDOztHQUVHO0FBQ0gsTUFBc0IsbUJBQW1CO0lBQzlCLE1BQU0sQ0FBQyxNQUFNO1FBQ2hCLElBQUk7WUFDQSw0QkFBNEI7WUFDNUIsTUFBTSxPQUFPLEdBQUcsMEJBQW1CLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDL0MsSUFBSSxPQUFPLEVBQUU7Z0JBQ1QsT0FBTztvQkFDSCxPQUFPLEVBQUUsSUFBSTtvQkFDYixPQUFPO2lCQUNWLENBQUM7YUFDTDtZQUNELCtCQUErQjtZQUMvQixNQUFNLE9BQU8sR0FBRyx5QkFBUyxDQUFDLFNBQVMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7WUFDcEQsSUFBSSxPQUFPLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUU7Z0JBQ3hDLE9BQU87b0JBQ0gsT0FBTyxFQUFFLEtBQUs7b0JBQ2QsT0FBTyxFQUFFLE9BQU8sQ0FBQyxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUMsSUFBSSxFQUFFO2lCQUM1QyxDQUFDO2FBQ0w7WUFDRCxPQUFPLFNBQVMsQ0FBQztTQUNwQjtRQUNELE9BQU8sR0FBRyxFQUFFO1lBQ1IsT0FBTyxTQUFTLENBQUM7U0FDcEI7SUFDTCxDQUFDO0NBR0o7QUEzQkQsa0RBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgc3Bhd25TeW5jIH0gZnJvbSAnY2hpbGRfcHJvY2Vzcyc7XG5pbXBvcnQgeyB0cnlHZXRNb2R1bGVWZXJzaW9uIH0gZnJvbSAnLi91dGlsJztcbi8qKlxuICogQW4gZXNidWlsZCBpbnN0YWxsYXRpb25cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEVzYnVpbGRJbnN0YWxsYXRpb24ge1xuICAgIHB1YmxpYyBzdGF0aWMgZGV0ZWN0KCk6IEVzYnVpbGRJbnN0YWxsYXRpb24gfCB1bmRlZmluZWQge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgLy8gQ2hlY2sgbG9jYWwgdmVyc2lvbiBmaXJzdFxuICAgICAgICAgICAgY29uc3QgdmVyc2lvbiA9IHRyeUdldE1vZHVsZVZlcnNpb24oJ2VzYnVpbGQnKTtcbiAgICAgICAgICAgIGlmICh2ZXJzaW9uKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICAgICAgaXNMb2NhbDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgdmVyc2lvbixcbiAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgLy8gRmFsbGJhY2sgdG8gYSBnbG9iYWwgdmVyc2lvblxuICAgICAgICAgICAgY29uc3QgZXNidWlsZCA9IHNwYXduU3luYygnZXNidWlsZCcsIFsnLS12ZXJzaW9uJ10pO1xuICAgICAgICAgICAgaWYgKGVzYnVpbGQuc3RhdHVzID09PSAwICYmICFlc2J1aWxkLmVycm9yKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICAgICAgaXNMb2NhbDogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgIHZlcnNpb246IGVzYnVpbGQuc3Rkb3V0LnRvU3RyaW5nKCkudHJpbSgpLFxuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgICB9XG4gICAgICAgIGNhdGNoIChlcnIpIHtcbiAgICAgICAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgICAgIH1cbiAgICB9XG4gICAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGlzTG9jYWw6IGJvb2xlYW47XG4gICAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHZlcnNpb246IHN0cmluZztcbn1cbiJdfQ==