/// <reference types="node" />
import { AssetCode, Runtime } from "../../aws-lambda";
import * as cdk from "../../core";
import { BundlingOptions } from './types';
/**
 * Options for bundling
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Directory containing your go.mod file
     *
     * This will accept either a directory path containing a `go.mod` file
     * or a filepath to your `go.mod` file (i.e. `path/to/go.mod`).
     *
     * This will be used as the source of the volume mounted in the Docker
     * container and will be the directory where it will run `go build` from.
     *
     * @default - the path is found by walking up parent directories searching for
     *  a `go.mod` file from the location of `entry`
     */
    readonly moduleDir: string;
    /**
     * The path to the folder or file that contains the main application entry point files for the project.
     *
     * This accepts either a path to a directory or file.
     *
     * If a directory path is provided then it will assume there is a Go entry file (i.e. `main.go`) and
     * will construct the build command using the directory path.
     *
     * For example, if you provide the entry as:
     *
     *     entry: 'my-lambda-app/cmd/api'
     *
     * Then the `go build` command would be:
     *
     *     `go build ./cmd/api`
     *
     * If a path to a file is provided then it will use the filepath in the build command.
     *
     * For example, if you provide the entry as:
     *
     *     entry: 'my-lambda-app/cmd/api/main.go'
     *
     * Then the `go build` command would be:
     *
     *     `go build ./cmd/api/main.go`
     */
    readonly entry: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: Runtime;
}
/**
 * Bundling
 */
export declare class Bundling implements cdk.BundlingOptions {
    private readonly props;
    static bundle(options: BundlingProps): AssetCode;
    static clearRunsLocallyCache(): void;
    private static runsLocally?;
    readonly image: cdk.DockerImage;
    readonly command: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly local?: cdk.ILocalBundling;
    private readonly relativeEntryPath;
    constructor(props: BundlingProps);
    createBundlingCommand(inputDir: string, outputDir: string, osPlatform?: NodeJS.Platform): string;
}
