import * as lambda from "../../aws-lambda";
import * as sqs from "../../aws-sqs";
import { Duration } from "../../core";
/**
 * @experimental
 */
export interface SqsEventSourceProps {
    /**
     * (experimental) The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     *
     * Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range: Minimum value of 1. Maximum value of 10.
     *
     * @default 10
     * @experimental
     */
    readonly batchSize?: number;
    /**
     * (experimental) The maximum amount of time to gather records before invoking the function.
     *
     * Valid Range: Minimum value of 0 minutes. Maximum value of 5 minutes.
     *
     * @default - no batching window. The lambda function will be invoked immediately with the records that are available.
     * @experimental
     */
    readonly maxBatchingWindow?: Duration;
    /**
     * (experimental) If the SQS event source mapping should be enabled.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Use an Amazon SQS queue as an event source for AWS Lambda.
 *
 * @experimental
 */
export declare class SqsEventSource implements lambda.IEventSource {
    readonly queue: sqs.IQueue;
    private readonly props;
    private _eventSourceMappingId?;
    /**
     * @experimental
     */
    constructor(queue: sqs.IQueue, props?: SqsEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
    /**
     * (experimental) The identifier for this EventSourceMapping.
     *
     * @experimental
     */
    get eventSourceMappingId(): string;
}
