"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const notifs = require("../../aws-s3-notifications"); // Automatically re-written from '@aws-cdk/aws-s3-notifications'
/**
 * (experimental) Use S3 bucket notifications as an event source for AWS Lambda.
 *
 * @experimental
 */
class S3EventSource {
    /**
     * @experimental
     */
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
_a = JSII_RTTI_SYMBOL_1;
S3EventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.S3EventSource", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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