"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const stream_1 = require("./stream");
/**
 * (experimental) Use an Amazon Kinesis stream as an event source for AWS Lambda.
 *
 * @experimental
 */
class KinesisEventSource extends stream_1.StreamEventSource {
    /**
     * @experimental
     */
    constructor(stream, props) {
        super(props);
        this.stream = stream;
        this._eventSourceMappingId = undefined;
        this.props.batchSize !== undefined && cdk.withResolved(this.props.batchSize, batchSize => {
            if (batchSize < 1 || batchSize > 10000) {
                throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize})`);
            }
        });
    }
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target) {
        const eventSourceMapping = target.addEventSourceMapping(`KinesisEventSource:${cdk.Names.nodeUniqueId(this.stream.node)}`, this.enrichMappingOptions({ eventSourceArn: this.stream.streamArn }));
        this._eventSourceMappingId = eventSourceMapping.eventSourceMappingId;
        this.stream.grantRead(target);
        // The `grantRead` API provides all the permissions recommended by the Kinesis team for reading a stream.
        // `DescribeStream` permissions are not required to read a stream as it's covered by the `DescribeStreamSummary`
        // and `SubscribeToShard` APIs.
        // The Lambda::EventSourceMapping resource validates against the `DescribeStream` permission. So we add it explicitly.
        // FIXME This permission can be removed when the event source mapping resource drops it from validation.
        this.stream.grant(target, 'kinesis:DescribeStream');
    }
    /**
     * (experimental) The identifier for this EventSourceMapping.
     *
     * @experimental
     */
    get eventSourceMappingId() {
        if (!this._eventSourceMappingId) {
            throw new Error('KinesisEventSource is not yet bound to an event source mapping');
        }
        return this._eventSourceMappingId;
    }
}
exports.KinesisEventSource = KinesisEventSource;
_a = JSII_RTTI_SYMBOL_1;
KinesisEventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.KinesisEventSource", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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