import { ISecurityGroup, IVpc, SubnetSelection } from "../../aws-ec2";
import * as lambda from "../../aws-lambda";
import * as secretsmanager from "../../aws-secretsmanager";
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 * (experimental) Properties for a Kafka event source.
 *
 * @experimental
 */
export interface KafkaEventSourceProps extends StreamEventSourceProps {
    /**
     * (experimental) the Kafka topic to subscribe to.
     *
     * @experimental
     */
    readonly topic: string;
    /**
     * (experimental) the secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details.
     *
     * @experimental
     */
    readonly secret: secretsmanager.ISecret;
}
/**
 * (experimental) Properties for a MSK event source.
 *
 * @experimental
 */
export interface ManagedKafkaEventSourceProps extends KafkaEventSourceProps {
    /**
     * (experimental) an MSK cluster construct.
     *
     * @experimental
     */
    readonly clusterArn: string;
}
/**
 * (experimental) The authentication method to use with SelfManagedKafkaEventSource.
 *
 * @experimental
 */
export declare enum AuthenticationMethod {
    /**
     * (experimental) SASL_SCRAM_512_AUTH authentication method for your Kafka cluster.
     *
     * @experimental
     */
    SASL_SCRAM_512_AUTH = "SASL_SCRAM_512_AUTH",
    /**
     * (experimental) SASL_SCRAM_256_AUTH authentication method for your Kafka cluster.
     *
     * @experimental
     */
    SASL_SCRAM_256_AUTH = "SASL_SCRAM_256_AUTH"
}
/**
 * (experimental) Properties for a self managed Kafka cluster event source.
 *
 * If your Kafka cluster is only reachable via VPC make sure to configure it.
 *
 * @experimental
 */
export interface SelfManagedKafkaEventSourceProps extends KafkaEventSourceProps {
    /**
     * (experimental) The list of host and port pairs that are the addresses of the Kafka brokers in a "bootstrap" Kafka cluster that a Kafka client connects to initially to bootstrap itself.
     *
     * They are in the format `abc.xyz.com:xxxx`.
     *
     * @experimental
     */
    readonly bootstrapServers: string[];
    /**
     * (experimental) If your Kafka brokers are only reachable via VPC provide the VPC here.
     *
     * @default none
     * @experimental
     */
    readonly vpc?: IVpc;
    /**
     * (experimental) If your Kafka brokers are only reachable via VPC, provide the subnets selection here.
     *
     * @default - none, required if setting vpc
     * @experimental
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * (experimental) If your Kafka brokers are only reachable via VPC, provide the security group here.
     *
     * @default - none, required if setting vpc
     * @experimental
     */
    readonly securityGroup?: ISecurityGroup;
    /**
     * (experimental) The authentication method for your Kafka cluster.
     *
     * @default AuthenticationMethod.SASL_SCRAM_512_AUTH
     * @experimental
     */
    readonly authenticationMethod?: AuthenticationMethod;
}
/**
 * (experimental) Use a MSK cluster as a streaming source for AWS Lambda.
 *
 * @experimental
 */
export declare class ManagedKafkaEventSource extends StreamEventSource {
    private innerProps;
    /**
     * @experimental
     */
    constructor(props: ManagedKafkaEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
}
/**
 * (experimental) Use a self hosted Kafka installation as a streaming source for AWS Lambda.
 *
 * @experimental
 */
export declare class SelfManagedKafkaEventSource extends StreamEventSource {
    private innerProps;
    /**
     * @experimental
     */
    constructor(props: SelfManagedKafkaEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
    private mappingId;
    private sourceAccessConfigurations;
}
