import * as dynamodb from "../../aws-dynamodb";
import * as lambda from "../../aws-lambda";
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 * @experimental
 */
export interface DynamoEventSourceProps extends StreamEventSourceProps {
}
/**
 * (experimental) Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 *
 * @experimental
 */
export declare class DynamoEventSource extends StreamEventSource {
    private readonly table;
    private _eventSourceMappingId?;
    /**
     * @experimental
     */
    constructor(table: dynamodb.ITable, props: DynamoEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
    /**
     * (experimental) The identifier for this EventSourceMapping.
     *
     * @experimental
     */
    get eventSourceMappingId(): string;
}
