"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiEventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("../../aws-apigateway"); // Automatically re-written from '@aws-cdk/aws-apigateway'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * @experimental
 */
class ApiEventSource {
    /**
     * @experimental
     */
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target) {
        const id = `${core_1.Names.nodeUniqueId(target.node)}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
_a = JSII_RTTI_SYMBOL_1;
ApiEventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.ApiEventSource", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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